/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.SafeResourceBundle;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.common.SgSessionKiller;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.SimpleGateway;
import com.aem.shelp.util.SimpleGatewayVisibilityDialog;
import com.aem.shelp.util.service.SimpleServiceOutputParser;
import com.aem.utils.CronTabUtil;
import com.aem.utils.FileCopyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import jwrapper.jwutils.JWSystem;
import jwrapper.logging.ProcessOutputUtil;
import utils.files.PermissionsUtil;
import utils.message.Message;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.string.CharStack;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.images.ImageLoader;
import utils.vm.VMFork;

public class SimpleGatewayInstallerV3 {
    private static final boolean ALWAYS_COPY_JRE = true;

    private static String getStacktrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    private static void installAndLaunchSimpleGateway(String cacheLocation, String nativeUtilsLocation, String dir, byte[] config, ProcessOutputUtil outputUtil) throws Exception {
        outputUtil.logMessage("Killing any live SG sessions");
        SgSessionKiller.startKillingAllSessionsMMoveAndSgServices((long)600000L, (boolean)true);
        outputUtil.logMessage("Waiting until sessions gone (" + new Date() + ")");
        SgSessionKiller.waitUntilHasKilled();
        SgSessionKiller.stopKillingSessions();
        outputUtil.logMessage("Sessions are gone (" + new Date() + "), launching installation");
        try {
            SimpleGatewayInstallerV3.installAndLaunchSimpleGateway2(cacheLocation, nativeUtilsLocation, dir, config, outputUtil);
        }
        catch (Exception t) {
            SgSessionKiller.stopKillingSessions();
            throw t;
        }
    }

    private static void installAndLaunchSimpleGateway2(String cacheLocation, String nativeUtilsLocation, String dir, byte[] config, ProcessOutputUtil outputUtil) throws Exception {
        String dirlib = dir + File.separator + "lib";
        File workingDir = new File(dir);
        String javaExe = VMFork.getJavaExe();
        File oldSimpleServiceFile = new File(nativeUtilsLocation, "SimpleService.exe");
        File newSimpleServiceFile = new File(dir, "SimpleService.exe");
        if (!oldSimpleServiceFile.exists()) {
            oldSimpleServiceFile = new File(cacheLocation, "SimpleService.exe");
        }
        try {
            File targetDir = new File(dir);
            if (targetDir.exists()) {
                Process p;
                if (OS.isWindows()) {
                    outputUtil.logMessage("Removing existing Windows service");
                    p = Runtime.getRuntime().exec(new String[]{oldSimpleServiceFile.getAbsolutePath(), "-uninstall", "sgateway.service"}, null, new File(dir));
                    SimpleServiceOutputParser parser = new SimpleServiceOutputParser(p);
                    p.waitFor();
                    parser.parse();
                } else {
                    outputUtil.logMessage("Stopping existing service");
                    p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib/customer.jar", "com.aem.sgateway.SimpleGatewayServiceStop"}, null, workingDir);
                    new ProcessPrinter(p, System.out, System.out);
                    p.waitFor();
                    outputUtil.logMessage("    - Service stopped.");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Throwable tt = t.getCause();
            if (tt == null) {
                IOException ex = new IOException(Language.get("SG_INSTALLER_FAILED_UNINSTALL_SERVICE") + ": " + t.getMessage());
                ex.initCause(tt);
                throw ex;
            }
            String message = SimpleGatewayInstallerV3.getStacktrace(tt);
            if (message.indexOf("1060:") != -1) {
                outputUtil.logMessage("No service to remove");
            }
            IOException ex = new IOException(Language.get("SG_INSTALLER_FAILED_UNINSTALL_SERVICE") + ": " + t.getMessage());
            ex.initCause(tt);
            throw ex;
        }
        outputUtil.logMessage("Copying installation files");
        File dirLibFile = new File(dirlib);
        if (new File(cacheLocation, "customer.jar").exists()) {
            FileCopyUtil.copyFile("customer.jar", JWSystem.getAppFolder(), dirLibFile);
        } else {
            FileCopyUtil.copyFile("customer.jar", nativeUtilsLocation, dirlib);
        }
        if (new File(cacheLocation, "liquidlnf.jar").exists()) {
            FileCopyUtil.copyFile("liquidlnf.jar", JWSystem.getAppFolder(), dirLibFile);
        } else {
            FileCopyUtil.copyFile("liquidlnf.jar", nativeUtilsLocation, dirlib);
        }
        if (new File(nativeUtilsLocation, "SimpleService.exe").exists()) {
            FileCopyUtil.copyFile("SimpleService.exe", nativeUtilsLocation, dir);
        } else {
            FileCopyUtil.copyFile("SimpleService.exe", cacheLocation, dir);
        }
        FileCopyUtil.copyFile("utils_wnative.dll", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("utils_wnative64.dll", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_lnative.so", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_lnative64.so", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_mnative.jnilib", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_mnative64.jnilib", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_m_lion_native.jnilib", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("libutils_m_lion_native64.jnilib", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("elevatesh.exe", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("elevatesh_mac", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("shcad.exe", nativeUtilsLocation, dirlib);
        FileCopyUtil.copyFile("SessionLauncher.exe", nativeUtilsLocation, dirlib);
        outputUtil.logMessage("Copying translations");
        FileCopyUtil.storeBytesToFile(Language.DEFLANG_SRC, "default_translation.txt", dir);
        String javaHome = SimpleGatewayInstallerV3.copyJRE(new File(dir, "jre"));
        if (javaHome != null) {
            javaExe = VMFork.getJavaExe(javaHome);
        }
        outputUtil.logMessage("Writing service configuration file");
        FileOutputStream fout = new FileOutputStream(SimpleGatewayConfig.getConfigLocation());
        fout.write(config);
        fout.close();
        if (OS.isWindows()) {
            String path = dir;
            path.replace('\\', File.separatorChar);
            path.replace('/', File.separatorChar);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("NAME:SimpleHelpSimpleGatewayService\n");
            sb.append("DISPLAYNAME:SimpleHelp SimpleGateway Service\n");
            sb.append("DESCRIPTION:SimpleHelp installed SimpleGateway Service\n");
            sb.append("WORKINGDIR:" + path + "\n");
            sb.append("CMDLINE:" + javaExe + " -cp lib\\customer.jar com.aem.sgateway.SimpleGatewayService\n");
            sb.append("AUTORESTART:yes\n");
            sb.append("INTERACTIVE:yes\n");
            sb.append("\n");
            String javaExeWQ = javaExe;
            if (!javaExe.startsWith("\"")) {
                javaExeWQ = "\"" + javaExe + "\"";
            }
            outputUtil.logMessage("Writing Windows service file");
            new File(dir + File.separator + "sgateway.service").delete();
            FileOutputStream fout2 = new FileOutputStream(dir + File.separator + "sgateway.service");
            fout2.write(sb.toString().getBytes());
            fout2.close();
            fout2 = new FileOutputStream(dir + File.separator + "installservice.bat");
            fout2.write("cmd.exe /c lib\\elevatesh.exe SimpleService.exe -install sgateway.service".getBytes());
            fout2.close();
            fout2 = new FileOutputStream(dir + File.separator + "removeservice.bat");
            fout2.write("cmd.exe /c lib\\elevatesh.exe SimpleService.exe -uninstall sgateway.service".getBytes());
            fout2.close();
            fout2 = new FileOutputStream(dir + File.separator + "gatewaystart.bat");
            fout2.write((javaExeWQ + " -cp lib\\customer.jar com.aem.sgateway.SimpleGatewayService\n").getBytes());
            fout2.close();
            fout2 = new FileOutputStream(dir + File.separator + "gatewaystop.bat");
            fout2.write((javaExeWQ + " -cp lib\\customer.jar com.aem.sgateway.SimpleGatewayServiceStop\n").getBytes());
            fout2.close();
            try {
                outputUtil.logMessage("Installing Windows service");
                Process p = Runtime.getRuntime().exec(new String[]{newSimpleServiceFile.getAbsolutePath(), "-install", "sgateway.service"}, null, new File(dir));
                SimpleServiceOutputParser parser = new SimpleServiceOutputParser(p);
                p.waitFor();
                parser.parse();
            }
            catch (Throwable t) {
                IOException ex = new IOException(Language.get("SG_INSTALLER_FAILED_INSTALL_SERVICE") + ": " + t.getMessage());
                ex.initCause(t);
                throw ex;
            }
        }
        if (OS.isMacOS()) {
            File startScript = new File(workingDir, "gatewaystart.sh");
            FileOutputStream fout3 = new FileOutputStream(startScript);
            fout3.write((javaExe + " -cp lib/customer.jar com.aem.sgateway.SimpleGatewayService &\n").getBytes());
            fout3.close();
            File stopScript = new File(workingDir, "gatewaystop.sh");
            fout3 = new FileOutputStream(stopScript);
            fout3.write((javaExe + " -cp lib/customer.jar com.aem.sgateway.SimpleGatewayServiceStop\n").getBytes());
            fout3.close();
            outputUtil.logMessage("Stopping existing service");
            Process p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib/customer.jar", "com.aem.sgateway.SimpleGatewayServiceStop"}, null, workingDir);
            new ProcessPrinter(p, System.out, System.out);
            p.waitFor();
            outputUtil.logMessage("    - Service stopped.");
            PermissionsUtil.setRecursiveFullPermissions(new File(dir).getAbsolutePath());
            outputUtil.logMessage("Installing Launch Agent");
            outputUtil.startLogMessage();
            outputUtil.endLogMessage();
            outputUtil.logMessage("    - Agent installed.");
        } else {
            fout = new FileOutputStream(dir + "/gatewaystart.sh");
            fout.write((javaExe + " -cp lib/customer.jar com.aem.sgateway.SimpleGatewayService &\n").getBytes());
            fout.close();
            fout = new FileOutputStream(dir + "/gatewaystop.sh");
            fout.write((javaExe + " -cp lib/customer.jar com.aem.sgateway.SimpleGatewayServiceStop\n").getBytes());
            fout.close();
            outputUtil.logMessage("Stopping existing service");
            Process p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib/customer.jar", "com.aem.sgateway.SimpleGatewayServiceStop"}, null, new File(dir));
            new ProcessPrinter(p, System.out, System.out);
            p.waitFor();
            outputUtil.logMessage("Starting new service");
            p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib/customer.jar", "com.aem.sgateway.SimpleGatewayService"}, null, new File(dir));
            new ProcessPrinter(p, System.out, System.out);
            try {
                outputUtil.logMessage("Adding cron entry");
                File cronDir = new File(dir + "/cron");
                cronDir.mkdirs();
                FileOutputStream fout4 = new FileOutputStream(dir + "/cron/cronStart.sh");
                if (OS.isLinux()) {
                    fout4.write("export DISPLAY=:0\n".getBytes());
                    String[] psOutput = RunCommandGetOutput.runCommandGetOutput(new String[]{"ps", "a"});
                    CharStack stack = new CharStack(psOutput[0]);
                    stack.popUntil('X', false);
                    stack.popUntil("-auth ", false);
                    stack.popWhitespace();
                    String xAuthPath = stack.popText(true);
                    char[] p2 = null;
                    boolean correctPassword = false;
                    do {
                        if ((p2 = SimpleGatewayInstallerV3.getSudoPassword(outputUtil)) == null) continue;
                        try {
                            SimpleGatewayInstallerV3.checkSudoFileExists(p2, "/tmp", outputUtil);
                            correctPassword = true;
                        }
                        catch (IncorrectPasswordException ex) {
                            outputUtil.logMessage("[SG Install] Sudo password incorrect. Asking again...");
                            correctPassword = false;
                        }
                    } while (p2 != null && !correctPassword);
                    if (p2 != null) {
                        outputUtil.logMessage("[SG Install] Checking XAuth locations...");
                        if (!SimpleGatewayInstallerV3.checkSudoFileExists(p2, xAuthPath, outputUtil)) {
                            outputUtil.logMessage("[SG Install] Failed. Trying some common locations...");
                            String[] alternatives = new String[]{"/var/gdm/:0.Xauth", "/var/lib/gdm/:0.Xauth", "/var/kdm/:0.Xauth", "/var/lib/kdm/:0.Xauth", "/var/xdm/:0.Xauth", "/var/lib/xdm/:0.Xauth"};
                            xAuthPath = null;
                            for (int i = 0; i < alternatives.length && xAuthPath == null; ++i) {
                                String path = alternatives[i];
                                if (!SimpleGatewayInstallerV3.checkSudoFileExists(p2, path, outputUtil)) continue;
                                xAuthPath = path;
                            }
                        }
                        if (xAuthPath == null) {
                            outputUtil.logMessage("[SG Install] Warning: XAuth is not set.");
                            JOptionPane.showMessageDialog(null, Language.get("NO_XAUTH_SET") + "\n\n" + Language.get("NO_XAUTH_SET2"), Language.get("NO_XAUTH_SET_TITLE"), 2, ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"));
                            fout4.write("export XAUTHORITY=\n".getBytes());
                        } else {
                            fout4.write(("export XAUTHORITY=" + xAuthPath + "\n").getBytes());
                        }
                    } else {
                        outputUtil.logMessage("[SG Install] Warning: XAuth is not set - password not provided.");
                        JOptionPane.showMessageDialog(null, Language.get("NO_XAUTH_SET") + "\n\n" + Language.get("NO_XAUTH_SET2"), Language.get("NO_XAUTH_SET_TITLE"), 2, ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"));
                        fout4.write("export XAUTHORITY=\n".getBytes());
                    }
                    fout4.write(("cd " + dir + "\n").getBytes());
                    fout4.write((javaExe + " -cp " + dir + "/lib/customer.jar com.aem.sgateway.SimpleGatewayService > " + dir + "/cron/cron.log 2>&1\n").getBytes());
                    outputUtil.logMessage("[SG Install] Installing reboot service");
                    CronTabUtil.addRebootCronJob((String)"root", (char[])p2, (String)("sh " + dir + "/cron/cronStart.sh"));
                    outputUtil.logMessage("[SG Install] Installed Reboot Service.");
                } else {
                    fout4.write(("cd " + dir + "\n").getBytes());
                    fout4.write((javaExe + " -cp " + dir + "/lib/customer.jar com.aem.sgateway.SimpleGatewayService > " + dir + "/cron/cron.log 2>&1\n").getBytes());
                    outputUtil.logMessage("[SG Install] Installing reboot service");
                    CronTabUtil.addRebootCronJob((String)("sh " + dir + "/cron/cronStart.sh"));
                    outputUtil.logMessage("[SG Install] Installed Reboot Service.");
                }
                fout4.flush();
            }
            catch (Throwable t) {
                outputUtil.logMessage("Unable to install CRON service: " + t.getMessage());
                outputUtil.logError("Unable to install CRON service: " + t.getMessage());
                t.printStackTrace();
                IOException ex = new IOException(Language.get("SG_INSTALLER_FAILED_INSTALL_SERVICE"));
                ex.initCause(t);
                throw ex;
            }
        }
    }

    private static String copyJRE(File targetDirectory) {
        try {
            File javaHome = new File(System.getProperty("java.home"));
            System.out.println("[SG Install] Utilising JavaHome: " + javaHome);
            if (OS.isMacOS()) {
                File parentJavaHome = javaHome.getParentFile();
                Process exec = Runtime.getRuntime().exec(new String[]{"rm", "-fR", targetDirectory.getAbsolutePath()});
                new ProcessPrinter(exec, System.out, System.err);
                exec.waitFor();
                System.out.println("[SG Install] Recreating target directory");
                targetDirectory.mkdirs();
                exec = Runtime.getRuntime().exec(new String[]{"cp", "-R", parentJavaHome.getAbsolutePath() + File.separator, targetDirectory.getAbsolutePath()});
                new ProcessPrinter(exec, System.out, System.err);
                exec.waitFor();
                return new File(targetDirectory, javaHome.getName()).getAbsolutePath();
            }
            System.out.println("[SG Install] Installing appropriate JRE files.");
            FileCopyUtil.fastCopyFiles(javaHome, targetDirectory);
            try {
                if (OS.isLinux()) {
                    System.out.println("[SG Install] Setting bin/java to be executable.");
                    File binDir = new File(targetDirectory, "bin");
                    if (binDir != null) {
                        PermissionsUtil.setExecutableForMe(new File(binDir, "java"));
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[SG Install] Could not set java to be executable.");
                t.printStackTrace();
            }
            return targetDirectory.getAbsolutePath();
        }
        catch (Throwable t) {
            System.out.println("[SimpleGatewayInstaller] Copy JRE failed (" + t.getMessage() + ")");
            t.printStackTrace();
            return null;
        }
    }

    private static char[] getSudoPassword(ProcessOutputUtil outputUtil) {
        outputUtil.logMessage("[SG Install] Requesting SUDO password...");
        JLabel label = new JLabel("<html>" + Language.get("SUDO_MESSAGE") + "<br><br></html>");
        JLabel note = new JLabel("<html><br>" + Language.get("SUDO_NOTE") + "</html>");
        JPasswordField jpf = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(Language.get("SUDO_PASSWORD") + ": "), "West");
        panel.add((Component)jpf, "Center");
        panel.setBorder(SHBorderFactory.createEmptyBorder(0, 30, 0, 30));
        int result = JOptionPane.showConfirmDialog(null, new Object[]{label, panel, note}, Language.get("SUDO_TITLE"), 2);
        if (result == 0) {
            outputUtil.logMessage("[SG Install] Got Password.");
            return jpf.getPassword();
        }
        return null;
    }

    private static Process runProcessWithPassword(char[] p, String command) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"sh", "-c", "echo " + new String(p) + " | sudo -S " + command});
    }

    private static boolean checkSudoFileExists(char[] p, String authPath, ProcessOutputUtil outputUtil) throws IncorrectPasswordException {
        try {
            outputUtil.logMessage("[SG Install] Executing sudo process.");
            Process proc = SimpleGatewayInstallerV3.runProcessWithPassword(p, "ls " + authPath);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ByteArrayOutputStream berr = new ByteArrayOutputStream();
            new ProcessPrinter(proc, bout, berr);
            outputUtil.logMessage("[SG Install] Waiting for result.");
            int result = proc.waitFor();
            bout.flush();
            berr.flush();
            String stdout = bout.toString();
            String stderr = berr.toString();
            if (result == 0) {
                return true;
            }
            outputUtil.logMessage("[SG Install] failed with output: " + stderr + "\n");
            if (stderr.indexOf("Password:") != -1 && stderr.indexOf("Password:") != stderr.lastIndexOf("Password:")) {
                throw new IncorrectPasswordException();
            }
            if (stderr.indexOf("Sorry") != -1) {
                throw new IncorrectPasswordException();
            }
            return false;
        }
        catch (Throwable t) {
            if (t instanceof IncorrectPasswordException) {
                throw (IncorrectPasswordException)t;
            }
            outputUtil.logMessage("Could not check status of file: " + authPath);
            t.printStackTrace();
            return false;
        }
    }

    public static Message getInstallMessage(byte[] configbytes, String cacheDir, String libsDir, String logFileLocation, byte[] translations) {
        Message message = new Message();
        message.append(configbytes);
        message.append(cacheDir);
        message.append(libsDir);
        message.append(logFileLocation);
        message.append(translations);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSGInstallation(Message message) throws Throwable {
        ProcessOutputUtil outputUtil = null;
        outputUtil = SimpleGatewayInstallerV3.initLog(new File((String)message.get(3)));
        try {
            byte[] configbytes = (byte[])message.get(0);
            String cacheDir = (String)message.get(1);
            String libsDir = (String)message.get(2);
            byte[] translations = (byte[])message.get(4);
            Language.DEFLANG_SRC = translations;
            Language.DEFLANG = new SafeResourceBundle(new ByteArrayInputStream(Language.DEFLANG_SRC));
            File installDir = SimpleGateway.getV3InstallLocation();
            if (!SimpleGateway.canWriteToDir(SimpleGateway.getV3InstallLocation())) {
                throw new IOException("SimpleGateway Install: Access Denied.");
            }
            outputUtil.logMessage("Showing visibility dialog");
            CancelListener cl = new CancelListener();
            try {
                SimpleGatewayVisibilityDialog vv;
                cl.vv = vv = new SimpleGatewayVisibilityDialog(Language.get("PERSISTENT_CONNECTION_TITLE"), Language.get("CANCEL"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("PERSISTENT_CONNECTION_MESSAGE"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
                vv.addActionListener(cl);
                vv.setVisible(true);
                try {
                    Object object = cl.NOTIFY;
                    synchronized (object) {
                        cl.NOTIFY.wait(5000L);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                vv.setVisible(false);
            }
            catch (Throwable t) {
                outputUtil.logMessage("Error showing visibility dialog: " + t.getMessage());
                t.printStackTrace();
            }
            if (!cl.cancelled) {
                SimpleGatewayInstallerV3.installAndLaunchSimpleGateway(cacheDir, libsDir, installDir.getAbsolutePath(), configbytes, outputUtil);
                outputUtil.writeResult(1);
            }
        }
        catch (Throwable t) {
            if (outputUtil != null) {
                outputUtil.writeResult(2);
                outputUtil.logMessage(t.getMessage());
                outputUtil.logError(t.getMessage());
                outputUtil.logStackTrace(t);
            }
        }
        finally {
            if (outputUtil != null) {
                outputUtil.close();
            }
        }
    }

    private static ProcessOutputUtil initLog(File logFile) throws FileNotFoundException {
        ProcessOutputUtil output = new ProcessOutputUtil("SimpleGatewayInstaller", logFile);
        output.logMessage("Created log file: " + logFile.getAbsolutePath());
        return output;
    }

    static class IncorrectPasswordException
    extends Exception {
        IncorrectPasswordException() {
        }
    }

    static class CancelListener
    implements ActionListener {
        boolean cancelled = false;
        SimpleGatewayVisibilityDialog vv;
        Object NOTIFY = new Object();

        CancelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancelled = true;
            this.vv.setVisible(false);
            Object object = this.NOTIFY;
            synchronized (object) {
                this.NOTIFY.notifyAll();
            }
        }
    }
}

