/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.WEnv;
import com.aem.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.string.CharStack;

public class SafeModeUtil {
    private File bootIni;
    private File backupIni;

    public SafeModeUtil() throws Throwable {
        if (OS.isWindows() && !OS.isWindowsVistaOrAbove()) {
            this.bootIni = SafeModeUtil.locateBootIni();
            this.backupIni = new File(this.bootIni.getCanonicalPath().toLowerCase().replaceAll("boot", "boot_old"));
            if (this.bootIni == null) {
                System.err.println("[SafeModeUtil] Error locating boot.ini");
                throw new Throwable("[SafeModeUtil] Error locating boot.ini");
            }
        }
    }

    public boolean setBootIntoSafeMode() {
        try {
            int firstIndex;
            String defOs;
            int nextIndex;
            if (OS.isWindowsVistaOrAbove()) {
                File queryexe;
                Process process;
                try {
                    process = Runtime.getRuntime().exec(new String[]{"bcdedit", "/set", "safeboot", "network"});
                }
                catch (IOException ex) {
                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "bcdedit", "/set", "safeboot", "network"});
                }
                new ProcessPrinter(process, System.out, System.err);
                int ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                process = Runtime.getRuntime().exec("cmd.exe /c bcdedit /set safeboot network");
                new ProcessPrinter(process, System.out, System.err);
                ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                String windir = WEnv.getEnv("WINDIR").trim();
                System.out.println("[SafeModeUtil] Windir is '" + windir + "'");
                if (!windir.endsWith("\\")) {
                    windir = windir + "\\";
                }
                if (!(queryexe = new File(windir + "System32\\bcdedit.exe")).exists()) {
                    queryexe = new File(windir + "sysnative\\bcdedit.exe");
                }
                if (!queryexe.exists()) {
                    queryexe = new File(windir + "SysWOW64\\bcdedit.exe");
                }
                String command = "\"" + queryexe.getAbsolutePath() + "\" /set safeboot network";
                process = Runtime.getRuntime().exec(command);
                new ProcessPrinter(process, System.out, System.err);
                ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                throw new Throwable("bcdedit returned " + ret);
            }
            String bootIni = this.readBootINI();
            int newLine = Math.min(bootIni.indexOf(10, (nextIndex = bootIni.indexOf(defOs = SafeModeUtil.getDefaultOS(bootIni), (firstIndex = bootIni.indexOf(defOs)) + 1)) + 1), bootIni.indexOf(13, nextIndex + 1));
            if (newLine == -1) {
                String bootLine = bootIni.substring(nextIndex);
                if (bootLine.toLowerCase().contains("/SAFEBOOT".toLowerCase())) {
                    System.out.println("SAFEBOOT Already set.");
                    return true;
                }
                bootIni = bootIni + " /SAFEBOOT:NETWORK ";
            } else {
                String bootLine = bootIni.substring(nextIndex, newLine);
                if (bootLine.toLowerCase().contains("/SAFEBOOT".toLowerCase())) {
                    System.out.println("SAFEBOOT Already set.");
                    return true;
                }
                String str1 = bootIni.substring(0, newLine).trim();
                String str2 = "";
                if (newLine < bootIni.length()) {
                    str2 = bootIni.substring(newLine, bootIni.length());
                }
                str1 = str1.trim();
                str2 = str2.trim();
                bootIni = str1 + " /SAFEBOOT:NETWORK\r\n" + str2;
            }
            this.writeBootINI(bootIni);
            return true;
        }
        catch (Throwable t) {
            System.out.println("[SafeModeUtil] Requesting safe mode reboot failed: " + t.getMessage());
            t.printStackTrace();
            return false;
        }
    }

    public boolean setBootIntoNormalMode() {
        try {
            if (OS.isWindowsVistaOrAbove()) {
                File queryexe;
                Process process;
                try {
                    process = Runtime.getRuntime().exec(new String[]{"bcdedit", "/deletevalue", "safeboot"});
                }
                catch (IOException ex) {
                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "bcdedit", "/deletevalue", "safeboot"});
                }
                new ProcessPrinter(process, System.out, System.err);
                int ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                process = Runtime.getRuntime().exec("cmd.exe /c bcdedit /deletevalue safeboot");
                new ProcessPrinter(process, System.out, System.err);
                ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                String windir = WEnv.getEnv("WINDIR").trim();
                System.out.println("[SafeModeUtil] Windir is '" + windir + "'");
                if (!windir.endsWith("\\")) {
                    windir = windir + "\\";
                }
                if (!(queryexe = new File(windir + "System32\\bcdedit.exe")).exists()) {
                    queryexe = new File(windir + "sysnative\\bcdedit.exe");
                }
                if (!queryexe.exists()) {
                    queryexe = new File(windir + "SysWOW64\\bcdedit.exe");
                }
                String command = "\"" + queryexe.getAbsolutePath() + "\" /deletevalue safeboot";
                process = Runtime.getRuntime().exec(command);
                new ProcessPrinter(process, System.out, System.err);
                ret = process.waitFor();
                if (ret == 0) {
                    return true;
                }
                throw new Throwable("bcdedit returned " + ret);
            }
            String bootIni = this.readBootINI();
            bootIni = bootIni.replaceAll("/SAFEBOOT:NETWORK", "");
            this.writeBootINI(bootIni);
            return true;
        }
        catch (Throwable t) {
            System.out.println("[SafeModeUtil] Resetting normal mode reboot failed: " + t.getMessage());
            t.printStackTrace();
            return false;
        }
    }

    private static String getDefaultOS(String bootIniContent) {
        CharStack stack = new CharStack(bootIniContent.toCharArray());
        stack.popUntil("default=", false);
        String def = stack.popUntil('\n', true);
        if (def != null) {
            def = def.trim();
        }
        return def;
    }

    private String readBootINI() throws Throwable {
        this.setAttributes(this.bootIni, true);
        FileInputStream fin = new FileInputStream(this.bootIni);
        String ret = StreamUtils.readAllAsStringISO88951(fin);
        fin.close();
        this.setAttributes(this.bootIni, false);
        return ret;
    }

    private void writeBootINI(String content) throws Throwable {
        this.setAttributes(this.bootIni, true);
        if (this.backupIni.exists()) {
            this.setAttributes(this.backupIni, true);
            this.backupIni.delete();
        }
        SafeModeUtil.copy(this.bootIni, this.backupIni);
        this.setAttributes(this.backupIni, false);
        content = content.trim();
        FileOutputStream fout = new FileOutputStream(this.bootIni);
        fout.write(content.getBytes("ISO-8859-1"));
        this.setAttributes(this.bootIni, false);
    }

    private static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private boolean setAttributes(File file, boolean enableReadWrite) throws Throwable {
        Process process = enableReadWrite ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "attrib", "-h", "-r", "-s", file.getCanonicalPath()}) : Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "attrib", "+h", "+r", "+s", file.getCanonicalPath()});
        new ProcessPrinter(process, System.out, System.err);
        int ret = process.waitFor();
        if (ret == 0) {
            return true;
        }
        throw new Throwable("Setting attributes returned " + ret);
    }

    private static File locateBootIni() {
        for (char drive = 'C'; drive <= 'Z'; drive = (char)(drive + '\u0001')) {
            File file = new File(drive + ":\\boot.ini");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("[SafeModeUtil] Executing SafeModeUtil");
        System.out.flush();
        try {
            boolean result = false;
            if (args.length == 0) {
                System.out.println("Please supply an argument. 'on' to enable safe mode. 'off' to disable.");
                return;
            }
            if (args[0].equalsIgnoreCase("on")) {
                SafeModeUtil util = new SafeModeUtil();
                result = util.setBootIntoSafeMode();
            } else if (args[0].equalsIgnoreCase("off")) {
                SafeModeUtil util = new SafeModeUtil();
                result = util.setBootIntoNormalMode();
            } else {
                System.out.println("Please supply an argument. 'on' to enable safe mode. 'off' to disable.");
                return;
            }
            if (result) {
                System.out.println("[SafeModeUtil] Complete: Success");
            } else {
                System.out.println("[SafeModeUtil] Complete: Failed");
                System.exit(1);
            }
        }
        catch (Throwable t) {
            System.out.println("[SafeModeUtil] Complete: Failed [" + t.getMessage() + "]");
            t.printStackTrace();
            System.exit(1);
        }
    }
}

