/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.attempt.Attempt;
import com.aem.nodelink.attempt.AttemptValidation;
import com.aem.nodelink.attempt.ConcurrentAttempt;
import com.aem.nodelink.attempt.ConcurrentAttemptListener;
import com.aem.nodelink.attempt.NodelinkAttempt;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.loc.LocalEndpoint;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.sgateway.SGHttpsUtil;
import com.aem.shelp.util.ConnectionDiagnosis;
import com.aem.tests.Testing;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jwrapper.jwutils.JWSystem;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.CheapTimingPrintStream;
import utils.progtools.Counter;
import utils.progtools.MapOfLists;
import utils.switches.Switches;
import utils.udp.bidirectional.StatelessUDPListener;
import utils.udp.bidirectional.UDPClient;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;

public class SHelpNodelinkConnector
implements ConcurrentAttemptListener {
    public static boolean DIAGNOSE_INCLUDE_UDP_TO_SERVER = true;
    public static boolean DIAGNOSE_INCLUDE_PURE_HTTP = false;
    public static boolean DIAGNOSE_INCLUDE_DIRECT_TCP = false;
    static AttemptValidation DEF_VALIDATOR = new PingValidator(100L);
    private static String lastHost;
    private static int lastPort;

    private SHelpNodelinkConnector() {
    }

    @Override
    public void layerFailed(int layerIndex) {
        if (layerIndex == 0) {
            System.out.println("Direct or proxied TCP connections failed");
        }
    }

    public static void quizUDP(String host, int http_port) {
        try {
            StatelessUDPListener listener = new StatelessUDPListener();
            UDPClient client = new UDPClient(host, http_port, listener);
            Message m = new Message(2001000);
            client.send(MessageUtils.messageToBytes(m));
            for (int i = 0; i < 10 && !listener.hasData(); ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                client.send(MessageUtils.messageToBytes(m));
            }
            if (listener.hasData()) {
                Message ret = MessageUtils.bytesToMessage(listener.getAndClearData());
                System.out.println("My external IP is " + ret.get(0));
                System.out.println("My external port is " + ret.get(1));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public static String diagnoseConnectionIssues(boolean extended) throws Exception {
        return SHelpNodelinkConnector.diagnoseConnectionIssues(lastHost, lastPort, extended, true);
    }

    public static String diagnoseConnectionIssues(String host, int http_port, boolean extended, boolean liveConnection) throws Exception {
        return SHelpNodelinkConnector.diagnoseConnectionIssues(host, http_port, extended, liveConnection, new StringBuffer());
    }

    public static String diagnoseConnectionIssues(String host, int http_port, boolean extended, boolean liveConnection, StringBuffer sb) throws Exception {
        boolean worked;
        ConnectionDiagnosis diag;
        NodelinkAttempt attempt;
        StringBuffer summary = new StringBuffer();
        summary.append("Checking for issues with connection to (" + SGHttpsUtil.getRequiredHttpProtocol() + ") " + host + ":" + http_port + " [" + extended + "]...\n");
        sb.append("More detailed debug information follows...\n\n");
        sb.append(new Date() + ": Diagnosing NodeLink connection types\n");
        double minsEach = 1.5;
        if (extended) {
            minsEach = 5.5;
        }
        sb.append("\n");
        sb.append(new Date() + ": Please NOTE: This connection test will test various aspects of your connection \n");
        sb.append(new Date() + ": including the ongoing stability of your connections to the SH server.\n");
        sb.append(new Date() + ": It will take some minutes to complete...\n");
        sb.append("\n");
        int http_or_tcp_port = http_port;
        int ssl_proxying_port = http_port;
        try {
            PortsThread portquery = new PortsThread(new URL(SGHttpsUtil.getRequiredHttpProtocol() + "://" + host + ":" + http_port + "/availableports"));
            portquery.start();
            portquery.join(8000L);
            int[] ports = portquery.ports;
            if (ports != null) {
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] != 443) continue;
                    ssl_proxying_port = 443;
                    sb.append(new Date() + ": Proxying attempts will be made to port 443 (default is " + http_port + ")\n");
                }
            }
        }
        catch (Throwable portquery) {
            // empty catch block
        }
        boolean workedSoFar = false;
        Node them = new Node();
        if (DIAGNOSE_INCLUDE_DIRECT_TCP) {
            sb.append(new Date() + ": Testing Direct TCP connection\n");
            Node tmpme = new Node();
            tmpme.setSingleUse(true);
            tmpme.setRemoteNodeAddress(them, new TcpEndpoint(host, http_or_tcp_port));
            attempt = new NodelinkAttempt("Direct TCP connection on port " + http_or_tcp_port, tmpme, them, 2, DEF_VALIDATOR);
            diag = new ConnectionDiagnosis();
            worked = SHelpNodelinkConnector.appendResult(sb, summary, !workedSoFar, diag.diagnoseFromClient(attempt, extended, liveConnection, sb));
            boolean bl = workedSoFar = workedSoFar || worked;
        }
        if (DIAGNOSE_INCLUDE_UDP_TO_SERVER) {
            DecimalFormat df = new DecimalFormat("###0.###");
            sb.append(new Date() + ": Testing UDP to server\n");
            sb.append(new Date() + ": - (port " + http_or_tcp_port + ")\n");
            UDPTestWait test = new UDPTestWait(host, http_or_tcp_port, sb);
            if (test.workedOK) {
                sb.append(new Date() + ": -- Successful responses (" + test.validResponses + "/" + test.requests + " = " + df.format(100.0 - 100.0 / (double)test.requests * (double)test.validResponses) + "% loss, " + (test.requests - test.validResponses) + " packets) from server for UDP on " + http_or_tcp_port + "\n");
            } else {
                sb.append(new Date() + ": -- No response from server for UDP on " + http_or_tcp_port + "\n");
            }
            if (http_or_tcp_port != ssl_proxying_port) {
                sb.append(new Date() + ": - (port " + ssl_proxying_port + ")\n");
                test = new UDPTestWait(host, ssl_proxying_port, sb);
                if (test.workedOK) {
                    sb.append(new Date() + ": -- Successful response (" + test.validResponses + "/" + test.requests + " = " + df.format(100.0 - 100.0 / (double)test.requests * (double)test.validResponses) + "%loss, " + (test.requests - test.validResponses) + " packets)  from server for UDP on " + ssl_proxying_port + "\n");
                } else {
                    sb.append(new Date() + ": -- No response from server for UDP on " + ssl_proxying_port + "\n");
                }
            }
        }
        if (DIAGNOSE_INCLUDE_PURE_HTTP) {
            sb.append(new Date() + ": Testing Pure HTTP connection\n");
            try {
                Proxy proxy = JWSystem.getDefaultDetectedProxy();
                if (proxy == null) {
                    sb.append(new Date() + ": - No HTTP Proxy (null)\n");
                } else {
                    sb.append(new Date() + ": " + proxy.toString() + "\n");
                }
            }
            catch (Throwable t) {
                sb.append(new Date() + ": - Unable to check proxy settings " + t + "\n");
            }
            Node tmpme = new Node();
            tmpme.setSingleUse(true);
            if (http_or_tcp_port == 80) {
                tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("http://" + host + "/data")));
            } else {
                tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("http://" + host + ":" + http_or_tcp_port + "/data")));
            }
            attempt = new NodelinkAttempt("HTTP connection (via HTTP proxy if necessary) on port " + http_or_tcp_port, tmpme, them, 0, DEF_VALIDATOR);
            diag = new ConnectionDiagnosis();
            worked = SHelpNodelinkConnector.appendResult(sb, summary, !workedSoFar, diag.diagnoseFromClient(attempt, extended, liveConnection, sb));
            workedSoFar = workedSoFar || worked;
        }
        sb.append("\n");
        sb.append(new Date() + ": All tests are complete, please press the 'copy to clipboard' button and email the results to your tech.\n");
        String result = summary.toString() + "\n" + sb.toString();
        try {
            FileOutputStream fout = new FileOutputStream("ConnectionDiagnosis.txt");
            fout.write(result.getBytes());
            fout.flush();
            fout.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    private static boolean appendResult(StringBuffer sb, StringBuffer summary, boolean noneWorkedSoFar, String[] result) {
        summary.append(result[0]);
        if (result[2].equalsIgnoreCase("FAIL")) {
            return false;
        }
        if (noneWorkedSoFar) {
            if (result[0].indexOf("died") != -1) {
                summary.append(" -- ***PROBLEM*** This is the preferred connection but it appeared to fail one or more times after it was established.\n");
                summary.append(" -- This might indicate that the a network security device or virus/network protection software is interfering with the connection after it has been established on the port mentioned above.\n");
            } else {
                summary.append(" -- ***OK*** This is the preferred connection and it appeared to work OK without any failures.\n");
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String port;
        String host;
        System.setOut(new CheapTimingPrintStream(System.out));
        System.out.println("Cheap timing print stream installed");
        System.out.println("Usage: SHelpNodelinkConnector <host> <port> [extended]");
        if (args.length == 0) {
            System.out.println("Host:");
            host = StreamUtils.readLine(System.in);
            System.out.println("Port:");
            port = StreamUtils.readLine(System.in);
        } else {
            host = args[0];
            port = args[1];
        }
        String versions = StreamUtils.readAllAsStringUTF8(new URL("http://" + host + ":" + port + "/allversions").openStream());
        System.out.println(versions);
        System.out.println("Connection: " + SHelpNodelinkConnector.getConnection(host, Integer.parseInt(port), null));
        System.exit(0);
    }

    public static NodeLink getLocalProxyServerConnection(NodeLinkStatusListener status) throws Exception {
        Node them = new Node();
        Node tmpme = new Node();
        tmpme.setRemoteNodeAddress(them, new LocalEndpoint("LOCAL-PROXYSERVER"));
        return new NodeLink(tmpme, them);
    }

    public static NodeLink getSpecificConnection(int type, String host, int http_port, NodeLinkStatusListener status) throws Exception {
        return SHelpNodelinkConnector.getConnection(type, host, http_port, status);
    }

    public static NodeLink getConnection(String host, int http_port, NodeLinkStatusListener status) throws Exception {
        return SHelpNodelinkConnector.getConnection(-1, host, http_port, status);
    }

    private static NodeLink getConnection(int type, String host, int http_port, NodeLinkStatusListener status) throws Exception {
        Attempt attempt;
        Node tmpme;
        long SSL_HTTPS_URL_DELAY;
        long HTTPS_ENCAPSULATED_DELAY;
        long HTTP_ENCAPSULATED_DELAY;
        System.out.println("[Nodelink] Using NodeLink attempt utility to make connection...");
        if (Testing.amTesting() && Testing.queryTestingBoolean("RANDOMISE_CONNECTION_TYPES") && type == -1) {
            double rand = Math.random();
            if (rand < 0.25) {
                System.out.println("[Testing] Randomly forced HTTP transport");
                type = 4;
            } else if (rand < 0.5) {
                System.out.println("[Testing] Randomly forced TCP transport");
                type = 2;
            } else if (rand < 0.75) {
                System.out.println("[Testing] Randomly forced HTTPS transport");
                type = 3;
            } else {
                System.out.println("[Testing] Forced no specific transport to test multi-connects");
            }
        }
        int http_or_tcp_port = http_port;
        int ssl_proxying_port = http_port;
        try {
            PortsThread portquery = new PortsThread(new URL(SGHttpsUtil.getRequiredHttpProtocol() + "://" + host + ":" + http_port + "/availableports"));
            portquery.start();
            portquery.join(8000L);
            int[] ports = portquery.ports;
            if (ports != null) {
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] != 443) continue;
                    ssl_proxying_port = 443;
                    System.out.println("Proxying attempts will be made to port 443 (default is " + http_port + ")");
                }
            }
        }
        catch (Throwable portquery) {
            // empty catch block
        }
        Node them = new Node();
        long TCP_DIRECT_DELAY = 0L;
        if (Switches.SH_1566_prioritiseTransportHttpOverSsl || Switches.SH_1566_disableSslTransport) {
            HTTP_ENCAPSULATED_DELAY = 3000L;
            HTTPS_ENCAPSULATED_DELAY = 4500L;
            SSL_HTTPS_URL_DELAY = 6000L;
        } else {
            SSL_HTTPS_URL_DELAY = 3000L;
            HTTP_ENCAPSULATED_DELAY = 4500L;
            HTTPS_ENCAPSULATED_DELAY = 6000L;
        }
        if (type == 4) {
            System.out.println("[Nodelink] Trying to specifically establish an HTTP connection...");
            HTTP_ENCAPSULATED_DELAY = 0L;
            TCP_DIRECT_DELAY = 1500L;
            HTTPS_ENCAPSULATED_DELAY = 3000L;
        } else if (type == 3) {
            System.out.println("[Nodelink] Trying to specifically establish an HTTPS connection...");
            HTTPS_ENCAPSULATED_DELAY = 0L;
            SSL_HTTPS_URL_DELAY = 0L;
            TCP_DIRECT_DELAY = 4000L;
            HTTP_ENCAPSULATED_DELAY = 5000L;
        } else if (type == 2) {
            System.out.println("[Nodelink] Trying to specifically establish a pure TCP connection...");
            TCP_DIRECT_DELAY = 0L;
        }
        ConcurrentAttempt cat = new ConcurrentAttempt(new SHelpNodelinkConnector());
        if (!(CentralDebugging.DISABLE_CONNECTION_TCP || CentralDebugging.NL_FORCE_HTTP_ONLY || CentralDebugging.NL_FORCE_HTTPS_IF_POSSIBLE)) {
            tmpme = new Node();
            tmpme.setSingleUse(true);
            tmpme.setRemoteNodeAddress(them, new TcpEndpoint(host, http_or_tcp_port));
            if (type == -1 || type == 2) {
                cat.appendAttemptToCurrentLayer(new NodelinkAttempt("Direct TCP connection (" + host + ":" + http_or_tcp_port + ")", tmpme, them, 2, DEF_VALIDATOR, TCP_DIRECT_DELAY));
            }
        }
        if (!Switches.SH_1566_disableSslTransport && !CentralDebugging.DISABLE_CONNECTION_SSL) {
            if (!CentralDebugging.NL_FORCE_HTTP_ONLY) {
                tmpme = new Node();
                tmpme.setSingleUse(true);
                tmpme.setRemoteNodeAddress(them, new TcpEndpoint(host, http_or_tcp_port, true));
                if (type == -1 || type == 3) {
                    cat.appendAttemptToCurrentLayer(new NodelinkAttempt("SSL HTTPS connection (" + host + ":" + http_or_tcp_port + ")", tmpme, them, 1, DEF_VALIDATOR, SSL_HTTPS_URL_DELAY));
                }
            }
            if (http_or_tcp_port != ssl_proxying_port && !CentralDebugging.NL_FORCE_HTTP_ONLY) {
                tmpme = new Node();
                tmpme.setSingleUse(true);
                tmpme.setRemoteNodeAddress(them, new TcpEndpoint(host, ssl_proxying_port, true));
                if (type == -1 || type == 3) {
                    cat.appendAttemptToCurrentLayer(new NodelinkAttempt("SSL HTTPS connection (" + host + ":" + ssl_proxying_port + ")", tmpme, them, 1, DEF_VALIDATOR, SSL_HTTPS_URL_DELAY + 500L));
                }
            }
        }
        if (!CentralDebugging.DISABLE_CONNECTION_HTTP) {
            tmpme = new Node();
            tmpme.setSingleUse(true);
            if (http_or_tcp_port == 80) {
                tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("http://" + host + "/data")));
            } else {
                tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("http://" + host + ":" + http_or_tcp_port + "/data")));
            }
            if (type == -1 || type == 4) {
                cat.appendAttemptToCurrentLayer(new NodelinkAttempt("HTTP encapsulated (" + host + ":" + http_or_tcp_port + ")", tmpme, them, 0, DEF_VALIDATOR, HTTP_ENCAPSULATED_DELAY));
            }
        }
        if (Switches.SH_1740_attemptFullDuplexOverSsl) {
            if (!CentralDebugging.DISABLE_CONNECTION_FDHTTPS) {
                tmpme = new Node();
                tmpme.setSingleUse(true);
                if (http_or_tcp_port == 443) {
                    tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("https://" + host + "/data"), Switches.SH_1740_fullDuplexAcceptAllSslCerts));
                } else {
                    tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("https://" + host + ":" + http_or_tcp_port + "/data"), Switches.SH_1740_fullDuplexAcceptAllSslCerts));
                }
                if (type == -1 || type == 3) {
                    cat.appendAttemptToCurrentLayer(new NodelinkAttempt("HTTPS encapsulated (" + host + ":" + http_or_tcp_port + ")", tmpme, them, 1, DEF_VALIDATOR, HTTPS_ENCAPSULATED_DELAY));
                }
            }
            if (http_or_tcp_port != ssl_proxying_port) {
                tmpme = new Node();
                tmpme.setSingleUse(true);
                if (ssl_proxying_port == 443) {
                    tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("https://" + host + "/data"), Switches.SH_1740_fullDuplexAcceptAllSslCerts));
                } else {
                    tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL("https://" + host + ":" + ssl_proxying_port + "/data"), Switches.SH_1740_fullDuplexAcceptAllSslCerts));
                }
                if (type == -1 || type == 3) {
                    cat.appendAttemptToCurrentLayer(new NodelinkAttempt("HTTPS encapsulated (" + host + ":" + ssl_proxying_port + ")", tmpme, them, 1, DEF_VALIDATOR, HTTPS_ENCAPSULATED_DELAY + 1000L));
                }
            }
        }
        if ((attempt = cat.attemptNow()) == null) {
            throw new ConnectException("Unable to connect to " + host + ":" + http_or_tcp_port + " or " + host + ":" + ssl_proxying_port);
        }
        NodelinkAttempt nla = (NodelinkAttempt)attempt;
        NodeLink sock = nla.getNodeLink();
        lastHost = host;
        lastPort = http_port;
        System.out.println("Connection made by: " + nla.getName() + " - " + sock);
        return sock;
    }

    public static void dumpCondensedCompleteThreadStacks(File save) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream pout = new PrintStream(bout);
            Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)method.invoke(null, new Object[0]);
            Object[] keys = map.keySet().toArray();
            pout.println("[AllThreadsTrace] Full Thread Trace Printout " + new Date());
            pout.println("[AllThreadsTrace] Total Threads: x" + keys.length);
            StringBuffer sb = new StringBuffer();
            HashMap staks = new HashMap();
            MapOfLists<String, Thread> byTrace = new MapOfLists<String, Thread>(true);
            Counter<String> sorter = new Counter<String>();
            for (int i = 0; i < keys.length; ++i) {
                Thread th = (Thread)keys[i];
                StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                Thread.State tstate = th.getState();
                String tname = th.getName();
                StringBuffer stacks = new StringBuffer();
                for (int z = 0; z < stack.length; ++z) {
                    stacks.append("\tat " + stack[z] + "\n");
                }
                String tstak = stacks.toString();
                byTrace.add(tstak, th);
                sorter.add(tstak, 1.0);
            }
            keys = byTrace.keySet().toArray();
            sorter.sortByValue(false);
            ArrayList keylist = sorter.getSortedKeys();
            for (int i = 0; i < keylist.size(); ++i) {
                String key;
                String tstak = key = (String)keylist.get(i);
                List all = byTrace.get(key);
                pout.println();
                pout.println("[AllThreadsTrace] " + all.size() + "x threads with trace:");
                pout.println(tstak);
                pout.println("   Thread Names:");
                for (int k = 0; k < all.size(); ++k) {
                    Thread th = (Thread)all.get(k);
                    if (k == 0) {
                        pout.print("   ");
                    } else if (k % 3 == 0) {
                        pout.println();
                        pout.print("   ");
                    }
                    pout.print(th.getName() + " (" + (Object)((Object)th.getState()) + "),");
                }
                pout.println();
            }
            pout.flush();
            String text = new String(bout.toByteArray());
            System.out.println(text);
            if (save != null) {
                FileOutputStream fout = new FileOutputStream(save);
                fout.write(bout.toByteArray());
                fout.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class UDPTestWait
    implements UDPListener {
        UDPClient client;
        boolean finished = false;
        boolean workedOK = false;
        int validResponses = 0;
        int requests = 0;

        public UDPTestWait(String host, int port, StringBuffer sb) {
            try {
                int freq = 150;
                int Nsecs = 60;
                sb.append(new Date() + ": -- Testing UDP (t=" + freq + "ms, s=" + Nsecs + "s)...\n");
                this.client = new UDPClient(host, port, this);
                Message m = new Message(55430003);
                for (int i = 0; i < 1000 / freq * Nsecs; ++i) {
                    this.client.send(MessageUtils.messageToBytes(m));
                    Thread.sleep(freq);
                    ++this.requests;
                }
                Thread.sleep(7000L);
                sb.append(new Date() + ": -- Finished waiting for responses\n");
            }
            catch (Exception x) {
                x.printStackTrace();
                this.workedOK = false;
                this.finished = true;
            }
            try {
                this.die();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
            Message m = MessageUtils.bytesToMessage(dat);
            if (m.getType() == 55430003) {
                this.workedOK = true;
                this.finished = true;
                ++this.validResponses;
            } else {
                System.out.println("Received invalid message");
            }
        }

        public void die() {
            this.client.die();
        }
    }

    private static class PortsThread
    extends Thread {
        URL url;
        int[] ports;

        public PortsThread(URL url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream in = new BufferedInputStream(this.url.openStream());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[500];
                int n = 0;
                while (n != -1) {
                    n = ((InputStream)in).read(buf);
                    if (n <= 0) continue;
                    bout.write(buf, 0, n);
                }
                String allports = new String(bout.toByteArray(), "UTF8");
                String[] all = allports.split(",");
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < all.length; ++i) {
                    try {
                        list.add(new Integer(Integer.parseInt(all[i])));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (list.size() > 0) {
                    int[] tmp = new int[list.size()];
                    for (int i = 0; i < tmp.length; ++i) {
                        tmp[i] = (Integer)list.get(i);
                        System.out.println("Server is available on port " + tmp[i]);
                    }
                    this.ports = tmp;
                } else {
                    this.ports = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static class PingValidator
    implements AttemptValidation {
        long duration;

        public PingValidator(long duration) {
            this.duration = duration;
        }

        @Override
        public void validate(String desc, NodeLink nl) throws IOException {
            long quit = System.currentTimeMillis() + this.duration;
            System.out.println("[SHelpNLConn] Validating " + desc + " " + this.duration + "...");
            while (System.currentTimeMillis() < quit) {
                StreamUtils.writeLong(nl.getOutputStream(), 653377110706450433L);
                nl.getOutputStream().flush();
                StreamUtils.readLong(nl.getInputStream());
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            System.out.println("[SHelpNLConn] Validated");
        }
    }
}

