/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.images.ImageLoader;

public class PleaseWaitDialog
extends AbstractDialogPanel
implements ActionListener {
    private final AbstractGlassDialog dialog;
    private boolean cancelled;

    public PleaseWaitDialog(RootPaneContainer rootPane, String title, String pleaseWaitMessage, PleaseWaitCancelListener cancelListener) {
        InfiniteCircularProgressIcon circularInfinite = SHProgressIcons.getCircularInfinite(SHProgressIcons.SIZE_48);
        circularInfinite.setUpdateComponent(this.getRootComponent());
        circularInfinite.switchOn();
        this.setIcon(circularInfinite);
        this.setPreferredWidth(400);
        FixedWidthLabel label = new FixedWidthLabel("<html>" + pleaseWaitMessage);
        this.setContent(label);
        if (cancelListener != null) {
            JButton button = this.addRightButton(Language.get("CANCEL"), true, this);
            button.setIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        }
        this.dialog = new AbstractGlassDialog(rootPane, 400, (AbstractDialogPanel)this);
        this.dialog.setTitle(title);
        this.dialog.showDialog(false);
    }

    public PleaseWaitDialog(RootPaneContainer rootPaneContainer, String title, String message) {
        this(rootPaneContainer, title, message, null);
    }

    public void hideDialog() {
        this.dialog.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancelled = true;
        this.dialogHandler.cancelPressed();
    }

    public void setVisible(boolean visible) {
        this.dialog.setVisible(visible);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public static interface PleaseWaitCancelListener {
        public void cancelled();
    }
}

