/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.ServerManagement;
import com.aem.nodelink.utils.SafeClock;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;
import utils.progtools.CheapTimingPrintStream;
import utils.progtools.CheapTimingProvider;
import utils.progtools.EnElapsedTimeFormatter;
import utils.switches.Switches;

public class OneClock
implements CheapTimingProvider {
    public static long DELAY = 60000L;
    public static long lastWrite = 0L;
    public static Object LOCK = new Object();
    public static ClockThread thread;
    private static boolean setStdout;
    static EnElapsedTimeFormatter etf;
    static long centralTimeAtLastPrint;
    static long safeTimeAtLastPrint;

    public static long getCentralTimeNow() {
        long delta = SafeClock.currentTimeMillis() - safeTimeAtLastPrint;
        return centralTimeAtLastPrint + delta;
    }

    @Override
    public String getCheapTime() {
        if (ServerManagement.isServerJVM()) {
            return etf.getCompressedFormattedTime(SafeClock.currentTimeMillis(), true);
        }
        return etf.getCompressedFormattedTime(OneClock.getCentralTimeNow(), true);
    }

    public static CheapTimingPrintStream getCheapTimingStream(OutputStream out) {
        CheapTimingPrintStream ctp = new CheapTimingPrintStream(out);
        ctp.setProvider(new OneClock());
        return ctp;
    }

    public static void print(long time) {
        OneClock.print(time, true);
    }

    public static String translate(long time) {
        return etf.getCompressedFormattedTime(time, false) + " vs " + new Date();
    }

    private static void print(long time, boolean write) {
        long T;
        if (!setStdout) {
            setStdout = true;
            if (Switches.SH_1559_centralClockStdout) {
                try {
                    Method method = Class.forName("jwrapper.logging.StdLogging").getDeclaredMethod("setCheapTimingProvider", CheapTimingProvider.class);
                    method.invoke(null, new OneClock());
                    System.out.println("[CentralisedTime] Set stdout provider");
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
        }
        if ((T = SafeClock.currentTimeMillis()) - safeTimeAtLastPrint < DELAY - 5000L) {
            return;
        }
        centralTimeAtLastPrint = time;
        safeTimeAtLastPrint = T;
        System.out.println("[CentralisedTime] " + etf.getCompressedFormattedTime(time, false) + " vs " + new Date());
        if (write && !ServerManagement.isServerJVM()) {
            File clock = OneClock.getSharedClockFile();
            if (System.currentTimeMillis() - clock.lastModified() > DELAY - 5000L) {
                try {
                    lastWrite = SafeClock.currentTimeMillis();
                    FileUtil.writeFileAsString(clock, "" + time);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static File getSharedClockFile() {
        File shared = JWSystem.getAllAppVersionsSharedFolder();
        File clock = new File(shared, "oneclock");
        return clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startClockThread() {
        block6: {
            try {
                if (ServerManagement.isServerJVM()) break block6;
                Object object = LOCK;
                synchronized (object) {
                    if (thread == null) {
                        thread = new ClockThread();
                        thread.setName("OneClockThread");
                        thread.start();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        setStdout = false;
        etf = new EnElapsedTimeFormatter();
        centralTimeAtLastPrint = SafeClock.currentTimeMillis();
        safeTimeAtLastPrint = SafeClock.currentTimeMillis();
    }

    static class ClockThread
    extends Thread {
        ClockThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (SafeClock.currentTimeMillis() - lastWrite <= DELAY + 5000L) continue;
                    File clock = OneClock.getSharedClockFile();
                    if (System.currentTimeMillis() - clock.lastModified() >= 5000L) continue;
                    long T = Long.parseLong(FileUtil.readFileAsString(clock));
                    OneClock.print(T, false);
                    Thread.sleep(DELAY - 5000L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

