/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.ui.NodeLinkStatusLabel;
import com.aem.sdesktop.interfaces.ConnectionCountProvider;
import com.aem.sdesktop.util.ConnectionSpeedListener;
import java.awt.Graphics;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import utils.swing.images.ImageLoader;

public class NodeLinkStatus
extends NodeLinkStatusLabel
implements ConnectionSpeedListener {
    JLabel speed = new JLabel("");
    boolean onlyShowWarningIcons = false;
    ResourceBundle lang;
    boolean slowConnection = false;
    int slowPort = -1;
    boolean showText = true;
    ConnectionCountProvider conn;

    public NodeLinkStatus(boolean isPreloading) {
        this.remove(this.panel);
        this.add("West", this.speed);
        if (isPreloading) {
            this.quit();
        }
    }

    public NodeLinkStatus(ResourceBundle bundle, boolean isPreloading) {
        super(bundle);
        this.remove(this.panel);
        this.add("West", this.speed);
        this.lang = bundle;
        if (isPreloading) {
            this.quit();
        }
    }

    public void setOnlyShowWarningIcons(boolean onlyShowWarningIcons) {
        this.onlyShowWarningIcons = onlyShowWarningIcons;
    }

    public void showText(boolean show) {
        this.showText = show;
    }

    @Override
    public void paint(Graphics g) {
        if (this.showText) {
            this.label.setText(this.panel.getToolTipText());
        } else {
            this.label.setText("");
            this.label.setToolTipText(this.panel.getToolTipText());
        }
        if (this.panel.dead) {
            this.label.setIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        } else if (!this.panel.established) {
            if (!this.onlyShowWarningIcons) {
                this.label.setIcon(ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
            }
        } else if (this.panel.ok) {
            if (!this.onlyShowWarningIcons) {
                this.label.setIcon(ImageLoader.getImageIcon("images/svg/general/world.svg,24"));
            }
        } else {
            this.label.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
        }
        if (this.slowConnection) {
            this.speed.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
            if (this.lang != null) {
                this.speed.setToolTipText(this.lang.getString(this.lang.getString("SLOW_HTTP_CONNECTION") + " " + this.slowPort));
            }
        }
        super.paint(g);
    }

    public void setConnectionCountProvider(ConnectionCountProvider conn) {
        this.conn = conn;
    }

    @Override
    protected void update() {
        try {
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void linkDead(NodeLink link, String msg) {
        if (this.conn != null) {
            if (this.conn.getLiveConnectionCount(null) < 1) {
                super.linkDead(link, msg);
            }
        } else {
            super.linkDead(link, msg);
        }
    }

    @Override
    public void linkOK(NodeLink link) {
        this.dead = false;
        this.panel.dead = false;
        super.linkOK(link);
    }

    @Override
    public void connectionIsSlow(int tcpPortToOpen) {
        this.slowConnection = true;
        this.slowPort = tcpPortToOpen;
        System.out.println("Only a slow HTTP connection was possible, you may wish to arrange outgoing TCP access on port " + tcpPortToOpen);
        try {
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

