/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.mdupload.fs.MirrorStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import utils.multiplex.FastMxInputStream;
import utils.multiplex.FastMxOutputStream;

public class MachineStream
implements MirrorStreamProvider,
NodeLinkStatusListener {
    private NodeLink nl;
    private Socket sock;
    public FastMxInputStream in;
    public FastMxOutputStream out;

    public MachineStream(Socket sock, FastMxInputStream in, FastMxOutputStream out) {
        this.sock = sock;
        this.in = in;
        this.out = out;
    }

    public MachineStream(NodeLink sock, FastMxInputStream in, FastMxOutputStream out) {
        this.nl = sock;
        this.in = in;
        this.out = out;
        this.nl.addLinkStatusListener(this);
    }

    public void shutdown(String reason) {
        if (this.nl != null) {
            try {
                this.nl.stop(reason);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.in.closeAll(new IOException(reason));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.nl != null) {
            return "Direct NL " + this.nl;
        }
        InetSocketAddress addr = (InetSocketAddress)this.sock.getRemoteSocketAddress();
        return "Direct Sock " + addr.getAddress().toString() + ":" + addr.getPort();
    }

    public void close(String reason) {
        try {
            if (this.nl != null) {
                this.nl.stop(reason);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public InputStream getIn(short chan) {
        return this.in.getInputStream(chan, "MachineStream" + chan);
    }

    @Override
    public OutputStream getOut(short chan) {
        return this.out.getOutputStream(chan);
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        this.shutdown(reason);
    }
}

