/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.MousePositionUtil;
import java.awt.Point;
import java.awt.Toolkit;
import sun.awt.HeadlessToolkit;

public class MachineInUseMonitor {
    private Point lastPoint;
    private int time;
    private long lastTime = System.currentTimeMillis();
    private long lastHeadlessCheck = 0L;
    private boolean isHeadless = false;

    public MachineInUseMonitor() {
        this(30000);
    }

    public MachineInUseMonitor(int intervaltime) {
        System.out.println("[MachineInUseMonitor] Initialising...");
        this.time = intervaltime;
        this.lastPoint = MousePositionUtil.get().getLocation();
    }

    public boolean isAvailable() {
        return MousePositionUtil.get().isAvailable();
    }

    public boolean isInUse() {
        if (MousePositionUtil.get().isAvailable()) {
            if (System.currentTimeMillis() - this.lastTime < (long)this.time) {
                return true;
            }
            Point newPoint = MousePositionUtil.get().getRobustLocationSum();
            if (newPoint != null && this.lastPoint != null && !newPoint.equals(this.lastPoint)) {
                this.lastPoint = newPoint;
                this.lastTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }
        return false;
    }

    public static void main(String[] args) throws InterruptedException {
        Thread.sleep(5000L);
        MachineInUseMonitor min = new MachineInUseMonitor();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(min.isInUse() + " - " + min.checkIfHeadless());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkIfHeadless() {
        try {
            if (System.currentTimeMillis() - this.lastHeadlessCheck < (long)this.time) {
                return this.isHeadless;
            }
            this.lastHeadlessCheck = System.currentTimeMillis();
            Toolkit t = Toolkit.getDefaultToolkit();
            this.isHeadless = t instanceof HeadlessToolkit;
        }
        catch (Throwable t) {
            this.isHeadless = true;
        }
        return this.isHeadless;
    }
}

