/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.WReg;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;

public class GetDoubleClickTime {
    static long doubleClickTime = -99L;

    public static long getDoubleClickTimeMillis() {
        if (doubleClickTime != -99L) {
            return doubleClickTime;
        }
        try {
            if (OS.isWindows()) {
                String str = WReg.get("HKEY_CURRENT_USER\\Control Panel\\Mouse", "DoubleClickSpeed", "REG_SZ");
                doubleClickTime = Long.parseLong(str.trim());
            } else if (OS.isLinux()) {
                doubleClickTime = -1L;
            } else if (OS.isMacOS()) {
                String str = RunCommandGetOutput.runCommandGetOutputThrowErrors("defaults read -g com.apple.mouse.doubleClickThreshold")[0];
                doubleClickTime = (long)(1000.0 * Double.parseDouble(str));
            } else {
                doubleClickTime = -1L;
            }
        }
        catch (Exception x) {
            System.out.println("[GetDoubleClickTime] Could not detect double click time: " + x.getMessage());
            doubleClickTime = -1L;
        }
        return doubleClickTime;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Double click time is " + GetDoubleClickTime.getDoubleClickTimeMillis() + "ms");
    }
}

