/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.LogicalArray;
import com.aem.utils.NonNativeLogicalArray;

public class FnvHash2D {
    private static final int[] starts = new int[]{0, 2, 1, 3};
    private static int startslen = starts.length;
    private static final int[] startsBounded = new int[]{0, 3, 1, 4, 2, 5, 3, 6};
    private static int startsBoundedlen = startsBounded.length;
    private static int[] allStartsBounded = new int[1000];
    CachedPatternLogicalArray cpla = new CachedPatternLogicalArray();
    int cpla_key;

    private static long hashTest(LogicalArray la) {
        int width = la.getWidth();
        int height = la.getHeight();
        long hash = 2166136261L;
        int start = 0;
        for (int y = 0; y < height; ++y) {
            switch (y % 6) {
                case 0: {
                    start = 0;
                    break;
                }
                case 1: {
                    start = 3;
                    break;
                }
                case 2: {
                    start = 1;
                    break;
                }
                case 3: {
                    start = 4;
                    break;
                }
                case 4: {
                    start = 2;
                    break;
                }
                case 5: {
                    start = 5;
                }
            }
            for (int x = start; x < width; x += 6) {
                hash ^= (long)la.getXY(x, y);
                hash *= 16777619L;
            }
        }
        return hash;
    }

    public long hashCached(LogicalArray la) {
        return this.hashCached(la, 0, 0, la.getWidth(), la.getHeight());
    }

    public long hashCached(LogicalArray la, int ox, int oy, int w, int h) {
        int N = this.cpla.N;
        int[] xs = this.cpla.xs;
        int[] ys = this.cpla.ys;
        int key = w * 10000 + h;
        if (this.cpla_key == key) {
            long hash = 2166136261L;
            for (int n = 0; n < N; ++n) {
                hash ^= (long)la.getXY(ox + xs[n], oy + ys[n]);
                hash *= 16777619L;
            }
            return hash;
        }
        this.cpla_key = key;
        this.cpla.reset(la);
        long hash = FnvHash2D.hashScreenChunk(this.cpla, ox, oy, w, h);
        N = this.cpla.N;
        xs = this.cpla.xs;
        ys = this.cpla.ys;
        int n = 0;
        while (n < N) {
            int n2 = n;
            xs[n2] = xs[n2] - ox;
            int n3 = n++;
            ys[n3] = ys[n3] - oy;
        }
        return hash;
    }

    public static long hashScreenChunk(LogicalArray la, int ox, int oy, int w, int h) {
        int y;
        int x;
        long hash = 2166136261L;
        int height = h + oy;
        int width = w + ox;
        if (w < 6 || h < 6) {
            for (int y2 = oy; y2 < height; ++y2) {
                for (int x2 = ox; x2 < width; ++x2) {
                    hash ^= (long)la.getXY(x2, y2);
                    hash *= 16777619L;
                }
            }
            return hash;
        }
        int height1 = height - 1;
        int height2 = height - 2;
        int height3 = height - 3;
        int width1 = width - 1;
        int width2 = width - 2;
        int width3 = width - 3;
        int edge1 = 3;
        int edge2 = 2;
        for (x = ox; x < width; ++x) {
            hash ^= (long)la.getXY(x, oy + 0);
            hash *= 16777619L;
            if (x % edge1 == 0 || x == width - 1) {
                hash ^= (long)la.getXY(x, oy + 1);
                hash *= 16777619L;
            }
            if (x % edge2 == 0 || x == width - 1) {
                hash ^= (long)la.getXY(x, oy + 2);
                hash *= 16777619L;
            }
            hash ^= (long)la.getXY(x, height1);
            hash *= 16777619L;
            if (x % edge1 == 0 || x == width - 1) {
                hash ^= (long)la.getXY(x, height2);
                hash *= 16777619L;
            }
            if (x % edge2 != 0 && x != width - 1) continue;
            hash ^= (long)la.getXY(x, height3);
            hash *= 16777619L;
        }
        for (y = oy + 3; y < height3; ++y) {
            hash ^= (long)la.getXY(ox + 0, y);
            hash *= 16777619L;
            if (y % edge1 == 0 || y == height3 - 1) {
                hash ^= (long)la.getXY(ox + 1, y);
                hash *= 16777619L;
            }
            if (y % edge2 == 0 || y == height3 - 1) {
                hash ^= (long)la.getXY(ox + 2, y);
                hash *= 16777619L;
            }
            hash ^= (long)la.getXY(width1, y);
            hash *= 16777619L;
            if (y % edge1 == 0 || y == height3 - 1) {
                hash ^= (long)la.getXY(width2, y);
                hash *= 16777619L;
            }
            if (y % edge2 != 0 && y != height3 - 1) continue;
            hash ^= (long)la.getXY(width3, y);
            hash *= 16777619L;
        }
        int n = 0;
        int[] C = new int[]{1, 3, 2};
        for (y = oy + 3; y < height3; ++y) {
            if (y % 2 == 0) {
                int index = 0;
                for (x = ox + startsBounded[n % startsBoundedlen] - 7; x < width3; x += C[index]) {
                    if (x >= ox + 3) {
                        hash ^= (long)la.getXY(x, y);
                        hash *= 16777619L;
                    }
                    if (++index < C.length) continue;
                    index = 0;
                }
            } else {
                for (x = ox + startsBounded[n % startsBoundedlen] + 3; x < width3; x += 6) {
                    hash ^= (long)la.getXY(x, y);
                    hash *= 16777619L;
                }
            }
            ++n;
        }
        return hash;
    }

    public static void main(String[] args) throws Exception {
        int[] source = new int[4096];
        FnvHash2D fnv = new FnvHash2D();
        NonNativeLogicalArray la = new NonNativeLogicalArray(64, 64, source, 64, 0, 0);
        for (int i = 0; i < 4; ++i) {
            long N = 0L;
            long stop = System.currentTimeMillis() + 1000L;
            while (System.currentTimeMillis() < stop) {
                for (int z = 0; z < 100; ++z) {
                    fnv.hashCached(la, 0, 0, 64, 64);
                    ++N;
                }
            }
            System.out.println(N + " chunks per second = " + N / 1426L + " 3000x2000 screens per second");
        }
    }

    static {
        for (int y = 0; y < allStartsBounded.length; ++y) {
            FnvHash2D.allStartsBounded[y] = startsBounded[y % startsBoundedlen];
        }
    }

    private class CachedPatternLogicalArray
    implements LogicalArray {
        int[] xs = new int[1600];
        int[] ys = new int[1600];
        int N = 0;
        LogicalArray la;

        private CachedPatternLogicalArray() {
        }

        public void reset(LogicalArray la) {
            this.la = la;
            this.N = 0;
        }

        @Override
        public int getWidth() {
            return this.la.getWidth();
        }

        @Override
        public int getHeight() {
            return this.la.getHeight();
        }

        @Override
        public int getYOffset(int y) {
            return this.la.getYOffset(y);
        }

        @Override
        public int getSourceOffset(int x, int y) {
            return this.la.getSourceOffset(x, y);
        }

        @Override
        public int getXY(int x, int y) {
            try {
                this.xs[this.N] = x;
                this.ys[this.N++] = y;
            }
            catch (ArrayIndexOutOfBoundsException xx) {
                int[] tmp = new int[this.xs.length + 1000];
                System.arraycopy(this.xs, 0, tmp, 0, this.xs.length);
                this.xs = tmp;
                tmp = new int[this.ys.length + 1000];
                System.arraycopy(this.ys, 0, tmp, 0, this.ys.length);
                this.ys = tmp;
                this.xs[this.N] = x;
                this.ys[this.N++] = y;
            }
            return this.la.getXY(x, y);
        }

        @Override
        public void setXY(int x, int y, int val) {
            this.la.setXY(x, y, val);
        }
    }
}

