/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.sdesktop.util.DualPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import utils.stream.OpenByteArrayOutputStream;

public class FixedByteBuffer
extends OutputStream {
    public static PrintStream origOut;
    public static PrintStream origErr;
    public static FixedByteBuffer INSTANCE;
    Object LOCK = new Object();
    int minSizeBytes;
    OpenByteArrayOutputStream stored = new OpenByteArrayOutputStream();
    OpenByteArrayOutputStream cur = new OpenByteArrayOutputStream();

    public static void injectIntoStdout() {
        if (INSTANCE == null) {
            origOut = System.out;
            origErr = System.err;
            origOut.println("[LogTracking] Tracking log text");
        } else {
            origOut.println("[LogTracking] Log tracking already set up");
        }
        origOut.println("[LogTracking] replacing tracking");
        PrintStream p1 = origOut;
        INSTANCE = new FixedByteBuffer();
        PrintStream p2 = new PrintStream(INSTANCE);
        DualPrinter dp = new DualPrinter(p1, p2);
        System.setOut(new PrintStream(dp.createNewOutputStream()));
        System.setErr(new PrintStream(dp.createNewOutputStream()));
        origOut.println("[LogTracking] log tracking set up OK");
    }

    public FixedByteBuffer() {
        this.minSizeBytes = 60000;
    }

    public FixedByteBuffer(int minSizeBytes) {
        this.minSizeBytes = minSizeBytes;
    }

    public String getContents() {
        return new String(this.stored.getByteArray(), 0, this.stored.size()) + new String(this.cur.getByteArray(), 0, this.cur.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContentsTo(OutputStream out) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            out.write(this.stored.getByteArray(), 0, this.stored.size());
            out.write(this.cur.getByteArray(), 0, this.cur.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.cur.write(b);
            this.switchIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.cur.write(b);
            this.switchIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.cur.write(b, off, len);
            this.switchIfNecessary();
        }
    }

    private void switchIfNecessary() {
        if (this.cur.size() > this.minSizeBytes) {
            OpenByteArrayOutputStream tmp = this.stored;
            if ((double)tmp.size() > (double)this.minSizeBytes * 1.25) {
                tmp = new OpenByteArrayOutputStream();
            } else {
                tmp.reset();
            }
            this.stored = this.cur;
            this.cur = tmp;
        }
    }

    public static void main(String[] args) throws Exception {
        FixedByteBuffer fb = new FixedByteBuffer(30000);
        CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG = "dog";
        FixedByteBuffer.injectIntoStdout();
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.err.println("weet");
        System.err.println("weet");
        INSTANCE.writeContentsTo(System.out);
        FixedByteBuffer.injectIntoStdout();
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.err.println("weet");
        System.err.println("weet");
        INSTANCE.writeContentsTo(System.out);
        FixedByteBuffer.injectIntoStdout();
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.out.println("woot");
        System.err.println("weet");
        System.err.println("weet");
        INSTANCE.writeContentsTo(System.out);
        CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG = "*dog";
        Thread.sleep(200L);
        System.out.println("dogdog");
        System.out.println("DOG");
        System.out.println("bdog");
        System.out.println("bdogg");
        System.out.println("bdogb");
    }

    static {
        INSTANCE = null;
    }
}

