/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.util.ConnectionDiagnosis;
import com.aem.shelp.util.SHelpNodelinkConnector;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystemUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.listeners.SystemExitWindowListener;

public class ConnectionDiagnoser
implements ActionListener {
    SimpleHelpFrame frame;
    JButton go;
    JButton copy;
    JToggleButton sclock;
    JPanel buts;
    JPanel main;
    JPanel log;
    JTextArea area = new JTextArea();
    JScrollPane scroll = new JScrollPane(this.area);

    ConnectionDiagnoser() {
        this.frame = new SimpleHelpFrame("SH Connection Test (4.2+)");
        this.frame.setBounds(0, 0, 700, 500);
        this.frame.addWindowListener(new SystemExitWindowListener());
        this.initGUI();
        this.frame.setVisible(true);
        try {
            this.frame.setIconImage(JWSystemUI.getMyAppLogoImage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void initGUI() {
        this.go = new JButton("Check Connection");
        this.copy = new JButton("Copy to Clipboard");
        this.sclock = new JToggleButton("Scroll", true);
        this.buts = new JPanel();
        this.log = new JPanel();
        this.main = new JPanel();
        this.frame.getContentPane().add(this.main);
        this.main.setLayout(new BorderLayout());
        this.main.add("North", this.buts);
        this.main.add("Center", this.log);
        this.buts.setLayout(new FlowLayout(1));
        this.buts.add(this.go);
        this.buts.add(this.sclock);
        this.buts.add(this.copy);
        this.log.setLayout(new GridLayout(1, 1));
        this.log.add(this.scroll);
        this.go.addActionListener(this);
        this.copy.addActionListener(this);
        this.sclock.addActionListener(this);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        new ConnectionDiagnoser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.go) {
            String url = JOptionPane.showInputDialog(this.main, "Please enter your SimpleHelp server HTTP URL (e.g. http://1.2.3.4/)", "SH Server URL", -1);
            if (url != null) {
                new ConnectionTestThread(url).start();
            }
        } else if (o == this.copy) {
            ClipboardUtil.setClipboardAsText(this.area.getText());
        }
    }

    class DisplayThread
    extends Thread {
        Thread join;
        StringBuffer sb;

        public DisplayThread(Thread join, StringBuffer sb) {
            this.join = join;
            this.sb = sb;
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ConnectionDiagnoser.this.area.setText(this.sb.toString());
                if (ConnectionDiagnoser.this.sclock.isSelected()) {
                    ConnectionDiagnoser.this.area.setCaretPosition(ConnectionDiagnoser.this.area.getDocument().getLength());
                }
                ConnectionDiagnoser.this.area.repaint();
                ConnectionDiagnoser.this.scroll.repaint();
            } while (this.join.isAlive());
        }
    }

    class ConnectionTestThread
    extends Thread {
        String url;

        ConnectionTestThread(String url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionDiagnoser.this.go.setEnabled(false);
            try {
                if (!this.url.startsWith("http")) {
                    this.url = "http://" + this.url;
                }
                URL serverurl = new URL(this.url);
                String host = serverurl.getHost();
                int port = serverurl.getPort();
                if (port == -1) {
                    port = serverurl.getDefaultPort();
                }
                System.out.println("Testing: " + host + " / " + port);
                SHelpNodelinkConnector.DIAGNOSE_INCLUDE_PURE_HTTP = true;
                SHelpNodelinkConnector.DIAGNOSE_INCLUDE_DIRECT_TCP = true;
                SHelpNodelinkConnector.DIAGNOSE_INCLUDE_UDP_TO_SERVER = true;
                ConnectionDiagnosis.PERFORM_PARALLEL_CONNECTIONS_IN_DIAGNOSE = false;
                StringBuffer sb = new StringBuffer();
                new DisplayThread(this, sb).start();
                sb.append("Starting connection test against " + host + ":" + port + "...\n");
                sb.append("\n");
                sb.append("OS: " + JWGenericOS.getInstance().getOSNameWithBitness() + "\n");
                sb.append("\n");
                String results = SHelpNodelinkConnector.diagnoseConnectionIssues(host, port, true, false, sb);
                System.out.println("RESULTS:");
                System.out.println(results);
                Thread.sleep(1000L);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                ConnectionDiagnoser.this.go.setEnabled(true);
            }
        }
    }
}

