/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.WEnv;
import com.aem.utils.FileCopyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import utils.files.PermissionsUtil;
import utils.ostools.OS;

public class CacheDirUtil {
    static ArrayList LIST_OF_READABLE_DIRS = new ArrayList();
    private static String ALL_ACCESSIBLE_TEMP_DIR = null;
    private static Random random = new Random();

    public static boolean testDir(String dir) {
        if (LIST_OF_READABLE_DIRS.contains(dir)) {
            return true;
        }
        System.out.println("[CacheDirUtil] Testing directory " + dir + " for write access and for unacceptable characters (missed cache)");
        if (dir.indexOf(35) != -1 || dir.indexOf(33) != -1) {
            System.out.println("Error: " + dir + " contains a hash character '#' or '!' which causes problems in JVM classpath.");
            return false;
        }
        new File(dir).mkdirs();
        try {
            File f = new File(dir + File.separator + "testfile");
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(0);
            fout.flush();
            fout.close();
            if (!f.exists()) {
                System.out.println("[CacheDirUtil] Directory " + dir + " is NOT writable (no file created)");
                return false;
            }
            if (f.length() != 1L) {
                System.out.println("[CacheDirUtil] Directory " + dir + " is NOT writable (file not expected length)");
                return false;
            }
            System.out.println("[CacheDirUtil] Directory " + dir + " is writable");
            LIST_OF_READABLE_DIRS.add(dir);
            return true;
        }
        catch (Throwable e) {
            System.out.println("[CacheDirUtil] Directory " + dir + " is NOT writable (error " + e + ")");
            return false;
        }
    }

    public static String getUserSubDir(String sysprop, String subdir) {
        String userdir = System.getProperty(sysprop);
        if (userdir.endsWith("/")) {
            userdir = userdir.substring(0, userdir.length() - 1);
        }
        if (userdir.endsWith("\\")) {
            userdir = userdir.substring(0, userdir.length() - 1);
        }
        if (userdir.replace('\\', '/').toLowerCase().endsWith("/desktop")) {
            userdir = userdir.substring(0, userdir.length() - "/desktop".length());
        }
        String dir = userdir + File.separator + subdir;
        return dir;
    }

    public static File createUniqueAccessibleTempDir(String prefix) throws IOException {
        File directory;
        File tempDir = new File(CacheDirUtil.getAllAccessibleTempDir());
        File[] children = tempDir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (!file.isDirectory() || !file.getName().startsWith(prefix + "_")) continue;
                FileCopyUtil.removeDirectory(file);
            }
        }
        if ((directory = new File(CacheDirUtil.getAllAccessibleTempDir(), prefix)).exists()) {
            FileCopyUtil.removeDirectory(directory);
        }
        int count = 0;
        boolean haveCreated = false;
        while (!haveCreated) {
            while (directory.exists()) {
                directory = new File(CacheDirUtil.getAllAccessibleTempDir(), prefix + "_" + Math.abs(random.nextInt()));
                ++count;
                if (!directory.exists() || !FileCopyUtil.removeDirectory(directory)) continue;
            }
            haveCreated = directory.mkdirs();
            if (count > 100) {
                return directory;
            }
            ++count;
        }
        return directory;
    }

    public static String getAllAccessibleTempDir() {
        if (ALL_ACCESSIBLE_TEMP_DIR != null) {
            return ALL_ACCESSIBLE_TEMP_DIR;
        }
        if (OS.isWindowsVistaOrAbove()) {
            String result = WEnv.getEnv("ALLUSERSPROFILE");
            if (result == null) {
                ALL_ACCESSIBLE_TEMP_DIR = System.getProperty("java.io.tmpdir");
                return ALL_ACCESSIBLE_TEMP_DIR;
            }
            File file = new File(result, "SimpleHelp");
            if (!file.exists()) {
                file.mkdir();
            }
            PermissionsUtil.setRecursiveFullPermissions(file.getAbsolutePath());
            ALL_ACCESSIBLE_TEMP_DIR = file.getAbsolutePath();
            return ALL_ACCESSIBLE_TEMP_DIR;
        }
        ALL_ACCESSIBLE_TEMP_DIR = System.getProperty("java.io.tmpdir");
        return ALL_ACCESSIBLE_TEMP_DIR;
    }
}

