/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.vnc;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import java.awt.Window;
import java.io.IOException;
import javax.swing.RootPaneContainer;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.validators.RequiredValidator;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class VNCConnectGlassDialog
extends OKCancelDialogPanel
implements AbstractField.ChangeListener {
    private TextField hostnameField;
    private TextField portField;
    private String hostname;
    private String port;
    private FixedWidthCUIPanel cuiPanel;

    public VNCConnectGlassDialog() {
        super(Language.get("CONNECT"), Language.get("CANCEL"));
    }

    public void showDialog(RootPaneContainer rpc) {
        this.cuiPanel = new FixedWidthCUIPanel();
        this.addFields();
        this.setContent(this.cuiPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, 370, (AbstractDialogPanel)this);
        dialog.showDialog();
        if (this.isOK()) {
            ResultPair[] filledOutResults = this.cuiPanel.getResults(Language.DEFLANG);
            this.hostname = filledOutResults[0].getValue();
            this.port = filledOutResults[1].getValue();
            try {
                SessionProperties.INSTANCE.setPropNoSave(SessionProperties.VNC_HOSTNAME, this.hostname);
                SessionProperties.INSTANCE.setPropAndSave(SessionProperties.VNC_PORT, this.port);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void addFields() {
        String hostname = "";
        String port = "";
        try {
            hostname = SessionProperties.INSTANCE.getProp(SessionProperties.VNC_HOSTNAME);
            port = SessionProperties.INSTANCE.getProp(SessionProperties.VNC_PORT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hostnameField = new TextField(Language.get("VNC_HOSTNAME"), this);
        this.hostnameField.addValidator(RequiredValidator.REQUIRED_INSTANCE);
        if (hostname != null) {
            this.hostnameField.setDefaultValue(hostname);
        }
        this.portField = new TextField(Language.get("PORT"), this, 1);
        this.portField.setWidthPercentage(25);
        this.portField.setLengthConstraints(5, 1);
        this.portField.setDefaultValue("5900");
        this.portField.addValidator(RequiredValidator.REQUIRED_INSTANCE);
        if (port != null) {
            this.portField.setDefaultValue(port);
        }
        this.cuiPanel.setFields(new CUIField[]{this.hostnameField, this.portField});
    }

    public String getVNCHostname() {
        return this.hostname;
    }

    public String getVNCPort() {
        return this.port;
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle.loadTestBundle();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        ((Window)frame).setSize(500, 500);
        frame.setVisible(true);
        VNCConnectGlassDialog d = new VNCConnectGlassDialog();
        d.showDialog(frame);
        System.out.println(d.getVNCHostname() + " - " + d.getVNCPort());
    }

    @Override
    public void changed(AbstractField source) {
        this.setOkEnabled(this.cuiPanel.isValid());
    }
}

