/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.shelp.tech.video.AbstractMessageProcessor;
import com.aem.utils.CursorInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.split.SplitByteArrayList;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;

public class VideoPlayer {
    private JPanel rootComponent = new JPanel();
    private BufferedImage image;
    private BufferedImagePanel imagePanel;
    private ControlPanel controlPanel = new ControlPanel();
    private File video;
    private double videoFirstTime;
    private double videoLengthMS;
    private SplitByteArrayList messageList;
    private AbstractMessageProcessor playThread;
    private CursorInfo currentCursor = null;
    private int cursorX;
    private int cursorY;
    private Rectangle requestRect = null;
    private ChunkHeader header = new ChunkHeader();

    public VideoPlayer(File video, boolean scaleImage) {
        this.video = video;
        this.initUI(scaleImage);
    }

    public void setBufferedImageSize(int w, int h) {
        if (this.image == null) {
            this.image = new BufferedImage(w, h, 1);
        } else {
            BufferedImage newImage = new BufferedImage(w, h, 1);
            int[] oldPixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            int[] newPixels = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
            int rowWidth = Math.min(this.image.getWidth(), w);
            int height = Math.min(this.image.getHeight(), h);
            for (int y = 0; y < height; ++y) {
                System.arraycopy(oldPixels, y * this.image.getWidth(), newPixels, y * newImage.getWidth(), rowWidth);
            }
            this.image = newImage;
        }
        if (this.playThread != null) {
            this.playThread.setImage(this.image);
        }
    }

    public void loadVideo() throws IOException {
        this.messageList = new SplitByteArrayList(this.video, this.header, 0x2800000L);
        this.messageList.setReadCacheMaximumSizeBytes(0x1400000L);
        this.videoFirstTime = this.messageList.getTime(1L);
        this.videoLengthMS = this.messageList.getLastTime() - this.videoFirstTime;
        this.controlPanel.setVideoDuration(this.videoLengthMS);
    }

    public void playFromTime(long timeOffset) {
        long time = (long)(this.videoFirstTime + (double)timeOffset);
        long startIndex = 0L;
        if (timeOffset > 0L) {
            startIndex = this.messageList.getIndex(time);
        }
        this.playFromIndex(startIndex);
    }

    private void pause() {
        if (this.playThread != null) {
            this.playThread.pause();
        }
        this.controlPanel.pause();
    }

    private void play() {
        if (this.controlPanel.isAtEnd()) {
            this.controlPanel.setToBeginning();
        }
        if (this.playThread == null) {
            this.playFromIndex(0L);
        } else {
            long currentTime = this.controlPanel.getTime();
            this.playFromTime(currentTime);
        }
    }

    public void playFromIndex(long messageIndex) {
        if (this.playThread != null) {
            this.playThread.die();
        }
        if (this.image != null) {
            int[] rgbadat = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            Arrays.fill(rgbadat, 0);
        }
        this.playThread = new VideoPlayerMessageProcessor();
        this.playThread.skipToIndex(messageIndex);
        this.playThread.start();
        this.controlPanel.play();
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    private void initUI(boolean scaleImage) {
        this.imagePanel = new BufferedImagePanel(scaleImage);
        this.rootComponent.setLayout(new BorderLayout());
        this.rootComponent.add((Component)this.imagePanel, "Center");
        this.rootComponent.add((Component)this.controlPanel, "South");
    }

    public void cleanup() {
        if (this.messageList != null) {
            try {
                this.messageList.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.messageList = null;
        }
        System.out.println("[VideoPlayer] Cleaning up video player");
        if (this.playThread != null) {
            System.out.println("[VideoPlayer] Cleaning up playThread");
            this.playThread.die();
            this.playThread = null;
        }
        if (this.controlPanel != null) {
            System.out.println("[VideoPlayer] Cleaning up controlPanel");
            this.controlPanel.cleanup();
            this.controlPanel = null;
        }
        this.image = null;
    }

    class ControlPanel
    extends JPanel
    implements Runnable,
    ActionListener {
        private JSlider slider = new JSlider(0, 100, 0);
        private JLabel timer = new JLabel();
        private JButton playPauseButton = new JButton(ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
        private boolean isPlaying = false;
        private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
        private boolean ignoreSliderUpdates = false;

        public void play() {
            if (!this.isPlaying) {
                this.isPlaying = true;
                this.playPauseButton.setIcon(ImageLoader.getImageIcon("images/svg/av/pause.svg,16"));
                new Thread(this).start();
            }
        }

        public void cleanup() {
            this.pause();
        }

        public void setToBeginning() {
            this.slider.setValue(0);
            this.setTime();
        }

        public boolean isAtEnd() {
            return this.slider.getValue() == this.slider.getMaximum();
        }

        public long getTime() {
            return this.slider.getValue() * 1000;
        }

        private void pause() {
            if (this.isPlaying) {
                this.isPlaying = false;
                this.playPauseButton.setIcon(ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
            }
        }

        public void setVideoDuration(double maxLengthMS) {
            this.slider.setMaximum((int)(maxLengthMS / 1000.0));
        }

        private void updateTimeAndTicker() {
            this.ignoreSliderUpdates = true;
            this.slider.setValue(this.slider.getValue() + 1);
            this.setTime();
            this.ignoreSliderUpdates = false;
        }

        private void setTime() {
            long timeMS = this.slider.getValue() * 1000;
            String formattedTime = this.sdf.format(new Date(timeMS));
            this.timer.setText(formattedTime);
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (this.isPlaying) {
                startTime += 1000L;
                try {
                    long timeToSleep = startTime - System.currentTimeMillis();
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isPlaying) continue;
                this.updateTimeAndTicker();
                if (this.slider.getValue() != this.slider.getMaximum()) continue;
                this.pause();
            }
        }

        public ControlPanel() {
            this.sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.slider, "Center");
            this.add((Component)this.timer, "East");
            this.add((Component)this.playPauseButton, "West");
            this.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
            this.timer.setFont(SHStyle.smallerFont);
            this.setTime();
            this.playPauseButton.addActionListener(this);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (ControlPanel.this.isPlaying && !ControlPanel.this.ignoreSliderUpdates) {
                        VideoPlayer.this.playFromTime((long)ControlPanel.this.slider.getValue() * 1000L);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isPlaying) {
                VideoPlayer.this.pause();
            } else {
                VideoPlayer.this.play();
            }
        }
    }

    class BufferedImagePanel
    extends JPanel {
        private boolean scaleImage;

        public BufferedImagePanel(boolean scaleImage) {
            this.scaleImage = scaleImage;
        }

        private int scale(int value, double factor) {
            return (int)((double)value * factor);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            super.paintComponent(g);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setColor(Color.DARK_GRAY);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (VideoPlayer.this.image != null) {
                double scaleX = (double)this.getWidth() / (double)VideoPlayer.this.image.getWidth();
                double scaleY = (double)this.getHeight() / (double)VideoPlayer.this.image.getHeight();
                double scale = Math.min(1.0, Math.min(scaleX, scaleY));
                if (!this.scaleImage) {
                    scale = 1.0;
                }
                int scaledImageWidth = this.scale(VideoPlayer.this.image.getWidth(), scale);
                int scaledImageHeight = this.scale(VideoPlayer.this.image.getHeight(), scale);
                int xOffset = Math.max((this.getWidth() - scaledImageWidth) / 2, 0);
                int yOffset = Math.max((this.getHeight() - scaledImageHeight) / 2, 0);
                g.translate(xOffset, yOffset);
                g.drawImage(VideoPlayer.this.image, 0, 0, scaledImageWidth, scaledImageHeight, 0, 0, VideoPlayer.this.image.getWidth(), VideoPlayer.this.image.getHeight(), null);
                if (VideoPlayer.this.currentCursor != null) {
                    BufferedImage cImage = VideoPlayer.this.currentCursor.getImage();
                    int scaledWidth = this.scale(cImage.getWidth(), scale);
                    int scaledHeight = this.scale(cImage.getHeight(), scale);
                    int dx = this.scale(VideoPlayer.this.cursorX, scale);
                    int dy = this.scale(VideoPlayer.this.cursorY, scale);
                    g.drawImage(cImage, dx, dy, dx + scaledWidth, dy + scaledHeight, 0, 0, cImage.getWidth(), cImage.getHeight(), null);
                }
                if (VideoPlayer.this.requestRect != null) {
                    Rectangle scaledRequestRect = new Rectangle(this.scale(((VideoPlayer)VideoPlayer.this).requestRect.x, scale), this.scale(((VideoPlayer)VideoPlayer.this).requestRect.y, scale), this.scale(((VideoPlayer)VideoPlayer.this).requestRect.width, scale), this.scale(((VideoPlayer)VideoPlayer.this).requestRect.height, scale));
                    Area area = new Area(new Rectangle(0, 0, scaledImageWidth, scaledImageHeight));
                    area.subtract(new Area(scaledRequestRect));
                    g.setColor(new Color(0, 0, 0, 200));
                    g2d.fill(area);
                }
            }
        }
    }

    class VideoPlayerMessageProcessor
    extends AbstractMessageProcessor {
        public VideoPlayerMessageProcessor() {
            super(VideoPlayer.this.messageList);
        }

        @Override
        public void processCursorImage(CursorInfo info) {
            VideoPlayer.this.currentCursor = info;
        }

        @Override
        public void processEndFrame(boolean skipUIAndSleep, long timeSinceStart) {
            if (!skipUIAndSleep) {
                VideoPlayer.this.imagePanel.repaint();
            }
        }

        @Override
        public void processCursorLocation(boolean skipUIAndSleep, int x, int y) {
            VideoPlayer.this.cursorX = x;
            VideoPlayer.this.cursorY = y;
            if (!skipUIAndSleep) {
                VideoPlayer.this.imagePanel.repaint();
            }
        }

        @Override
        public void processRequestRectangle(Rectangle rect) {
            VideoPlayer.this.requestRect = rect;
        }

        @Override
        public void processScreenSize(int width, int height) {
            VideoPlayer.this.setBufferedImageSize(width, height);
        }

        @Override
        public void processUpdatedScreen(Rectangle updatedRect) {
        }

        @Override
        protected boolean isRealTime() {
            return true;
        }
    }
}

