/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.shelp.tech.video.AbstractMessageProcessor;
import com.aem.shelp.tech.video.PngExtractor;
import com.aem.utils.CursorInfo;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.split.SplitByteArrayList;

public class VideoConvertorToHTML {
    private File video;
    private SplitByteArrayList messageList;
    private double videoFirstTime;
    private double videoLengthMS;
    private File targetFile;
    private BufferedImage image;
    private ChunkHeader header;

    public VideoConvertorToHTML(File video, File targetFile) {
        System.out.println("[VideoConvertorToHTML] Converting " + video);
        this.video = video;
        this.targetFile = targetFile;
        this.header = new ChunkHeader();
    }

    public void convertVideo() throws IOException {
        this.messageList = new SplitByteArrayList(this.video, this.header, 0x2800000L);
        this.messageList.setReadCacheMaximumSizeBytes(0x1400000L);
        this.videoFirstTime = this.messageList.getTime(1L);
        this.videoLengthMS = this.messageList.getLastTime() - this.videoFirstTime;
        VideoConvertorMessageProcessor processor = new VideoConvertorMessageProcessor();
        processor.skipToIndex(0L);
        processor.run();
    }

    class VideoConvertorMessageProcessor
    extends AbstractMessageProcessor {
        private PngExtractor extractor;

        public VideoConvertorMessageProcessor() throws FileNotFoundException {
            super(VideoConvertorToHTML.this.messageList);
            this.extractor = new PngExtractor(VideoConvertorToHTML.this.targetFile);
        }

        @Override
        public void processCursorImage(CursorInfo info) {
            this.extractor.setCursorImage(info);
        }

        @Override
        public void processEndFrame(boolean skipUIAndSleep, long timeSinceStart) {
            this.extractor.incrementFrame(timeSinceStart);
        }

        @Override
        public void processCursorLocation(boolean skipUIAndSleep, int x, int y) {
            this.extractor.setCursorPosition(x, y);
        }

        @Override
        public void processRequestRectangle(Rectangle rect) {
        }

        @Override
        public void processScreenSize(int w, int h) {
            if (VideoConvertorToHTML.this.image == null) {
                VideoConvertorToHTML.this.image = new BufferedImage(w, h, 1);
            } else {
                BufferedImage newImage = new BufferedImage(w, h, 1);
                int[] oldPixels = ((DataBufferInt)VideoConvertorToHTML.this.image.getRaster().getDataBuffer()).getData();
                int[] newPixels = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
                int rowWidth = Math.min(VideoConvertorToHTML.this.image.getWidth(), w);
                for (int y = 0; y < VideoConvertorToHTML.this.image.getHeight(); ++y) {
                    System.arraycopy(oldPixels, y * VideoConvertorToHTML.this.image.getWidth(), newPixels, y * newImage.getWidth(), rowWidth);
                }
                VideoConvertorToHTML.this.image = newImage;
            }
            this.setImage(VideoConvertorToHTML.this.image);
        }

        @Override
        public void processUpdatedScreen(Rectangle updatedRect) {
            this.extractor.extractFromBufferedImage(VideoConvertorToHTML.this.image, updatedRect);
        }

        @Override
        protected boolean isRealTime() {
            return false;
        }
    }
}

