/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.tech.video.VideoConvertorToHTML;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import utils.files.AtomicFileOutputStream;

public class VideoConverterThread
extends Thread {
    private final LinkedList<File> videosToConvert = new LinkedList();
    private File videoQueueFile = new File(VideoUtils.VIDEOS_FOLDER, "encodingqueue");
    private boolean die = false;

    public VideoConverterThread() {
        super("VideoConverter");
        this.videoQueueFile.getParentFile().mkdir();
        try {
            this.loadQueueFromDisk();
        }
        catch (Throwable t) {
            System.out.println("[VideoConverterThread] Unable to load queued video repository from disk.");
            t.printStackTrace();
        }
        this.checkForTimestampVideoFileErrors();
        this.start();
    }

    private void checkForTimestampVideoFileErrors() {
        try {
            if (!VideoUtils.VIDEOS_FOLDER.exists()) {
                return;
            }
            System.out.println("[VideoConverterThread] Checking for erroneously uploaded recordings...");
            File[] years = VideoUtils.VIDEOS_FOLDER.listFiles();
            if (years != null) {
                for (File year : years) {
                    File[] months;
                    if (!year.isDirectory() || (months = year.listFiles()) == null) continue;
                    for (File month : months) {
                        File[] recordings;
                        if (!month.isDirectory() || (recordings = month.listFiles()) == null) continue;
                        Arrays.sort(recordings, new Comparator<File>(){

                            @Override
                            public int compare(File o1, File o2) {
                                return o1.getName().compareTo(o2.getName());
                            }
                        });
                        for (File recording : recordings) {
                            File possibleAlternative;
                            if (!recording.exists() || !recording.getName().endsWith(".svf") || recording.length() != 0L || (possibleAlternative = this.getActualRecordingWithID(recording, recordings)) == null) continue;
                            if (!recording.delete()) {
                                System.out.println("[VideoConverterThread] Unable to fix recording " + recording);
                                continue;
                            }
                            if (!possibleAlternative.renameTo(recording)) {
                                System.out.println("[VideoConverterThread] Unable to rename recording to " + recording);
                                continue;
                            }
                            this.videosToConvert.add(recording);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private File getActualRecordingWithID(File recording, File[] recordings) {
        String id = recording.getName();
        id = id.substring(0, id.lastIndexOf(46));
        id = id.substring(id.indexOf("--") + 2);
        for (File alternativeRecording : recordings) {
            if (alternativeRecording.length() <= 0L || !alternativeRecording.getName().endsWith("--" + id + ".svf")) continue;
            return alternativeRecording;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoToQueue(File file) throws IOException {
        LinkedList<File> linkedList = this.videosToConvert;
        synchronized (linkedList) {
            if (this.videosToConvert.contains(file)) {
                return;
            }
            this.videosToConvert.add(file);
            this.writeQueueToDisk();
            this.videosToConvert.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeQueueToDisk() throws IOException {
        LinkedList<File> linkedList = this.videosToConvert;
        synchronized (linkedList) {
            BufferedOutputStream fout = new BufferedOutputStream(new AtomicFileOutputStream(this.videoQueueFile));
            try {
                for (File next : this.videosToConvert) {
                    String path = next + "\n";
                    ((OutputStream)fout).write(path.getBytes("UTF8"));
                }
            }
            finally {
                ((OutputStream)fout).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueueFromDisk() throws IOException {
        if (!this.videoQueueFile.exists()) {
            return;
        }
        LinkedList<File> linkedList = this.videosToConvert;
        synchronized (linkedList) {
            AtomicFileOutputStream.prepareForReading(this.videoQueueFile);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.videoQueueFile), "UTF8"));
            try {
                String line = in.readLine();
                while (line != null) {
                    try {
                        File newFile = new File(line);
                        this.videosToConvert.add(newFile);
                    }
                    catch (Throwable t) {
                        System.out.println("[VideoConverterThread] Unable to load '" + line + "' from disk.");
                    }
                    line = in.readLine();
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.die) {
            File inputFile = null;
            LinkedList<File> linkedList = this.videosToConvert;
            synchronized (linkedList) {
                while (this.videosToConvert.size() == 0) {
                    try {
                        this.videosToConvert.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                inputFile = this.videosToConvert.getFirst();
            }
            try {
                File outputFile = new File(inputFile.getParentFile(), inputFile.getName().replace(".svf", ".html"));
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                long start = System.currentTimeMillis();
                System.out.println("[VideoConverterThread] Converting to " + outputFile);
                VideoConvertorToHTML convertor = new VideoConvertorToHTML(inputFile, outputFile);
                convertor.convertVideo();
                long diff = System.currentTimeMillis() - start;
                System.out.println("[VideoConverterThread] Conversion complete (took " + diff + "ms)");
            }
            catch (Throwable t) {
                System.out.println("[VideoConverterThread] Unable to convert video file " + inputFile);
                t.printStackTrace();
            }
            linkedList = this.videosToConvert;
            synchronized (linkedList) {
                this.videosToConvert.removeFirst();
                try {
                    this.writeQueueToDisk();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void die() {
        this.die = true;
    }

    public static void main(String[] args) throws IOException {
        File test = new File(".");
        File[] list = test.listFiles();
        VideoConverterThread thread = new VideoConverterThread();
        for (int i = 0; i < list.length; ++i) {
            thread.addVideoToQueue(list[i]);
        }
        thread = new VideoConverterThread();
        thread.loadQueueFromDisk();
    }
}

