/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.SupportSession;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import jwrapper.jwutils.JWSystem;

public class TechVideoRepository {
    public static File getVideoFileFor(AbstractSession session) {
        return TechVideoRepository.getSaveFileFor(session, ".svf");
    }

    public static File getSupportFolder() {
        File saveDirectory = new File(JWSystem.getAllAppVersionsSharedFolder(), "videos");
        if (!saveDirectory.exists()) {
            saveDirectory.mkdir();
        }
        File file = new File(saveDirectory, "support");
        file.mkdir();
        return file;
    }

    public static File getPresentationFolder() {
        File saveDirectory = new File(JWSystem.getAllAppVersionsSharedFolder(), "videos");
        if (!saveDirectory.exists()) {
            saveDirectory.mkdir();
        }
        File file = new File(saveDirectory, "presentation");
        file.mkdir();
        return file;
    }

    public static File getAccessFolder() {
        File saveDirectory = new File(JWSystem.getAllAppVersionsSharedFolder(), "videos");
        if (!saveDirectory.exists()) {
            saveDirectory.mkdir();
        }
        File file = new File(saveDirectory, "access");
        file.mkdir();
        return file;
    }

    public static File getSaveFileFor(AbstractSession session, String extension) {
        File parentFolder = null;
        parentFolder = session instanceof SupportSession ? TechVideoRepository.getSupportFolder() : (session instanceof AccessSession ? TechVideoRepository.getAccessFolder() : TechVideoRepository.getPresentationFolder());
        return VideoUtils.getVideoFileName(parentFolder, session, extension);
    }

    public static TechVideoIterator getVideoIterator() {
        return new TechVideoIterator();
    }

    public static File getLockFileFor(File targetFile) {
        File lockFile = new File(targetFile.getParentFile(), targetFile.getName() + ".lock");
        return lockFile;
    }

    public static class TechVideoIterator
    implements Iterator<File> {
        Queue<File> stack = new LinkedList<File>();
        File next = null;

        public TechVideoIterator() {
            this.stack.add(TechVideoRepository.getAccessFolder());
            this.stack.add(TechVideoRepository.getPresentationFolder());
            this.stack.add(TechVideoRepository.getSupportFolder());
        }

        @Override
        public boolean hasNext() {
            File[] files;
            if (this.stack.isEmpty()) {
                return false;
            }
            File pop = this.stack.poll();
            while (pop.isFile() && !pop.getName().endsWith(".svf")) {
                if (this.stack.isEmpty()) {
                    return false;
                }
                pop = this.stack.poll();
            }
            if (pop.isFile()) {
                this.next = pop;
                return true;
            }
            for (File f : files = pop.listFiles()) {
                this.stack.add(f);
            }
            return this.hasNext();
        }

        @Override
        public File next() {
            return this.next;
        }

        @Override
        public void remove() {
        }
    }
}

