/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.CentralDebugging;
import com.aem.shelp.tech.video.IFrame;
import com.aem.utils.CursorInfo;
import com.aem.utils.LogicalArrayUtil;
import com.aem.utils.NonNativeLogicalArray;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import utils.dataservice.local.datalist.split.SplitByteArrayList;
import utils.message.Message;
import utils.message.MessageUtils;

public abstract class AbstractMessageProcessor
extends Thread {
    private SplitByteArrayList messageList;
    private boolean die = false;
    private long currentMessageIndex;
    private boolean pause = false;
    private Object PLAY_LOCK = new Object();
    private BufferedImage image;
    private int[] decodeColors = new int[128];
    private boolean skipNextSleep;
    long lastMessageProcessTime = 0L;
    long lastMessageTime = 0L;
    double firstTime = 0.0;

    public AbstractMessageProcessor(SplitByteArrayList messageList) {
        super("AbstractMessageProcessor");
        this.messageList = messageList;
    }

    public abstract void processUpdatedScreen(Rectangle var1);

    public abstract void processCursorImage(CursorInfo var1);

    public abstract void processEndFrame(boolean var1, long var2);

    public abstract void processCursorLocation(boolean var1, int var2, int var3);

    public abstract void processRequestRectangle(Rectangle var1);

    public abstract void processScreenSize(int var1, int var2);

    protected abstract boolean isRealTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessageAtIndex(long currentMessageIndex, boolean skipUIAndSleeping) {
        int i;
        long amountOfTimeToProcessLastEvent2;
        long timeToSleep;
        double nextTime = this.messageList.getTime(currentMessageIndex);
        if (!skipUIAndSleeping && !this.skipNextSleep && this.lastMessageProcessTime != 0L && (timeToSleep = (long)(nextTime - (double)this.lastMessageTime - (double)(amountOfTimeToProcessLastEvent2 = System.currentTimeMillis() - this.lastMessageProcessTime))) > 0L) {
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.skipNextSleep = false;
        if (this.pause && !skipUIAndSleeping) {
            Object amountOfTimeToProcessLastEvent2 = this.PLAY_LOCK;
            synchronized (amountOfTimeToProcessLastEvent2) {
                try {
                    this.PLAY_LOCK.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        this.lastMessageProcessTime = System.currentTimeMillis();
        this.lastMessageTime = (long)nextTime;
        byte[] messageBytes = this.messageList.getBytes(currentMessageIndex);
        if (messageBytes == null) {
            return;
        }
        Message m = MessageUtils.bytesToMessage(messageBytes);
        boolean isCachedChunk = m.getType() == 1;
        switch (m.getType()) {
            case 2: {
                this.processEndFrame(skipUIAndSleeping, (long)(nextTime - this.firstTime));
                return;
            }
            case 3: {
                CursorInfo currentCursor = CursorInfo.fromMessage(m);
                this.processCursorImage(currentCursor);
                return;
            }
            case 4: {
                int cursorX = m.getNextInt();
                int cursorY = m.getNextInt();
                this.processCursorLocation(skipUIAndSleeping, cursorX, cursorY);
                this.processEndFrame(skipUIAndSleeping, (long)(nextTime - this.firstTime));
                return;
            }
            case 5: {
                Rectangle requestRect = new Rectangle(m.getNextInt(), m.getNextInt(), m.getNextInt(), m.getNextInt());
                this.processRequestRectangle(requestRect);
                return;
            }
            case 0: {
                return;
            }
            case 6: {
                int width = m.getNextInt();
                int height = m.getNextInt();
                this.processScreenSize(width, height);
                return;
            }
            case 7: {
                this.processTranslation(m);
                return;
            }
            case 8: {
                Rectangle changedRectangle = this.processReformedTranslation(m);
                this.processUpdatedScreen(changedRectangle);
                return;
            }
            case 9: {
                return;
            }
            case 10: {
                boolean isRecording = m.getNextBoolean();
                if (!isRecording) {
                    this.skipNextSleep = true;
                }
                return;
            }
        }
        if (this.image == null) {
            return;
        }
        boolean blackIsEmpty = false;
        int tmp = (Integer)m.get(0);
        int x = 0xFFFF & tmp >>> 16;
        int y = 0xFFFF & tmp;
        tmp = (Integer)m.get(1);
        int w = 0xFFFF & tmp >>> 16;
        int h = 0xFFFF & tmp;
        tmp = (Integer)m.get(2);
        int enc = tmp >>> 6;
        int fil = ((tmp & 0x3F) >>> 4) + 50;
        blackIsEmpty = (tmp & 0xF) >> 3 != 0;
        int comp = (tmp & 7) + 100;
        byte[] packet_dat = (byte[])m.get(3);
        int packet_len = packet_dat.length;
        int pointerx = -1;
        int pointery = -1;
        if (m.length() > 4) {
            tmp = (Integer)m.get(4);
            pointerx = (0xFFFF & tmp >>> 16) - 1;
            pointery = (0xFFFF & tmp) - 1;
        }
        int pN = 0;
        int colourCount = 0;
        if (!isCachedChunk) {
            colourCount = packet_dat[pN++];
        } else {
            pN += 4;
            if (CentralDebugging.VISUALLY_SHOW_CACHING) {
                for (i = 2; i < packet_dat.length; i += 4) {
                    packet_dat[i] = -1;
                }
            }
        }
        if (enc != 5) {
            int hh;
            if (colourCount == 0) {
                for (hh = y; hh < Math.min(y + h, this.image.getHeight()); ++hh) {
                    for (int ww = x; ww < Math.min(x + w, this.image.getWidth()); ++ww) {
                        tmp = -1;
                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                        if (blackIsEmpty && tmp == -16777216) continue;
                        this.setPixel(ww, hh, tmp);
                    }
                }
            } else if (colourCount == 1) {
                tmp = -1;
                tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                if (!blackIsEmpty || tmp != -16777216) {
                    for (hh = y; hh < Math.min(y + h, this.image.getHeight()); ++hh) {
                        for (int ww = x; ww < Math.min(x + w, this.image.getWidth()); ++ww) {
                            this.setPixel(ww, hh, tmp);
                        }
                    }
                }
            } else if (colourCount > 0 && colourCount <= 16) {
                int pixelsPerByte;
                int bitsPerPixel;
                for (i = 0; i < colourCount; ++i) {
                    tmp = -1;
                    tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                    tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                    this.decodeColors[i] = tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                }
                switch (colourCount) {
                    case 2: {
                        bitsPerPixel = 1;
                        pixelsPerByte = 8;
                        break;
                    }
                    case 3: 
                    case 4: {
                        bitsPerPixel = 2;
                        pixelsPerByte = 4;
                        break;
                    }
                    default: {
                        bitsPerPixel = 4;
                        pixelsPerByte = 2;
                    }
                }
                int mask = (1 << bitsPerPixel) - 1;
                int totalColours = w * h;
                int width = w;
                int dx = 0;
                int dy = 0;
                while (totalColours > 0) {
                    byte b = packet_dat[pN++];
                    for (int i2 = 0; i2 < pixelsPerByte && totalColours > 0; --totalColours, ++i2) {
                        int idx = b >> bitsPerPixel * (pixelsPerByte - 1 - i2);
                        if (!blackIsEmpty || this.decodeColors[idx &= mask] != -16777216) {
                            this.setPixel(x + dx, y + dy, this.decodeColors[idx]);
                        }
                        dy += ++dx / width;
                        dx %= width;
                    }
                }
            } else if (colourCount > 0 && colourCount < 128) {
                for (i = 0; i < colourCount; ++i) {
                    tmp = -1;
                    tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                    tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                    this.decodeColors[i] = tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                }
                int rgb = 0;
                int run = 0;
                int width = w;
                int dx = 0;
                int dy = 0;
                int totalColours = w * h;
                boolean tot = false;
                while (totalColours > 0) {
                    int idx;
                    if (((idx = packet_dat[pN++]) & 0x80) == 128) {
                        int b;
                        idx += 128;
                        run = 0;
                        do {
                            if ((b = packet_dat[pN++]) < 0) {
                                b += 256;
                            }
                            run += b;
                        } while (b == 255);
                    }
                    rgb = this.decodeColors[idx];
                    if (!blackIsEmpty || rgb != -16777216) {
                        this.setPixel(x + dx, y + dy, rgb);
                    }
                    --totalColours;
                    dy += ++dx / width;
                    dx %= width;
                    for (int i3 = 0; i3 < run && totalColours > 0; ++i3) {
                        if (!blackIsEmpty || rgb != -16777216) {
                            this.setPixel(x + dx, y + dy, rgb);
                        }
                        --totalColours;
                        dy += ++dx / width;
                        dx %= width;
                    }
                    run = 0;
                }
            }
        } else {
            pN = 0;
            int desiredHeight = Math.min(y + h, this.image.getHeight());
            int desiredWidth = Math.min(x + w, this.image.getWidth());
            for (int hh = y; hh < desiredHeight; ++hh) {
                for (int ww = x; ww < desiredWidth; ++ww) {
                    if (!blackIsEmpty || packet_dat[pN] != 0) {
                        tmp = -1;
                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                        this.setPixel(ww, hh, tmp);
                    }
                    ++pN;
                }
            }
        }
        this.processUpdatedScreen(new Rectangle(x, y, w, h));
    }

    public void pause() {
        this.pause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        this.skipToIndex(this.currentMessageIndex);
        this.firstTime = this.messageList.getTime(this.currentMessageIndex);
        this.pause = false;
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            this.PLAY_LOCK.notify();
        }
    }

    public boolean isDead() {
        return this.die;
    }

    public void die() {
        System.out.println("[AbstractMessageProcessor] Asking for termination");
        this.die = true;
    }

    @Override
    public void run() {
        this.firstTime = this.messageList.getTime(this.currentMessageIndex);
        while (this.currentMessageIndex < this.messageList.size() && !this.die) {
            this.processMessageAtIndex(this.currentMessageIndex++, !this.isRealTime());
        }
        this.die = true;
        System.out.println("[AbstractMessageProcessor] Complete");
    }

    public void skipToIndex(long targetIndex) {
        long start = System.currentTimeMillis();
        this.currentMessageIndex = 0L;
        System.out.println("[VideoPlayer] Skipping to " + targetIndex);
        long iFrameIndex = Math.max(0L, targetIndex - targetIndex % 200L);
        if (iFrameIndex >= 200L) {
            System.out.println("[AbstractMessageProcessor] Found iFrame at " + iFrameIndex);
            byte[] messageBytes = this.messageList.getBytes(iFrameIndex);
            Message iFrameMessage = MessageUtils.bytesToMessage(messageBytes);
            if (iFrameMessage.getType() == 9) {
                IFrame iFrame = new IFrame(iFrameMessage);
                this.processScreenSize(iFrame.getWidthPixels(), iFrame.getHeightPixels());
                ArrayList indices = iFrame.getAllIndices();
                int indicesIndex = 0;
                int lastIndex = -1;
                while (indicesIndex < indices.size()) {
                    int index;
                    if ((index = ((Integer)indices.get(indicesIndex++)).intValue()) == -1 || index == lastIndex) continue;
                    lastIndex = index;
                    this.processMessageAtIndex(index, true);
                }
                this.processRequestRectangle(iFrame.getViewedSection());
                this.currentMessageIndex = iFrameIndex;
            } else {
                System.out.println("[AbstractMessageProcessor] WARNING: Index " + iFrameIndex + " doesn't contain an iFrame?");
            }
        }
        while (this.currentMessageIndex < targetIndex && !this.die) {
            this.processMessageAtIndex(this.currentMessageIndex++, true);
        }
        long end = System.currentTimeMillis();
        System.out.println("[VideoPlayer] Took " + (end - start) + " ms to skip");
    }

    private Rectangle processReformedTranslation(Message m) {
        int x = m.getNextInt();
        int y = m.getNextInt();
        int w = m.getNextInt();
        int h = m.getNextInt();
        int[] rgbadat = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        int imgWidth = this.image.getWidth();
        for (int yOffset = 0; yOffset < h; ++yOffset) {
            int[] row = m.getNextIntArray();
            if (CentralDebugging.VISUALLY_SHOW_TRANSLATIONS) {
                for (int i = yOffset % 2 * 4; i < row.length; i += 8) {
                    row[i] = 0;
                    row[i + 1] = 255;
                    row[i + 2] = 0;
                    row[i + 3] = 0;
                }
            }
            System.arraycopy(row, 0, rgbadat, imgWidth * (y + yOffset) + x, w);
        }
        return new Rectangle(x, y, w, h);
    }

    private void processTranslation(Message m) {
        int xDelta = (Integer)m.get(0);
        int yDelta = (Integer)m.get(1);
        int[] rgbadat = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        int imgWidth = this.image.getWidth();
        int imgHeight = this.image.getHeight();
        NonNativeLogicalArray screenLa = new NonNativeLogicalArray(imgWidth, imgHeight, rgbadat, imgWidth, 0, 0);
        for (int i = 2; i < m.length(); i += 3) {
            int gx = (Integer)m.get(i);
            int gy = (Integer)m.get(i + 1);
            int gwidth = (Integer)m.get(i + 2);
            try {
                LogicalArrayUtil.translate(screenLa, gx, gy, gwidth, 1, xDelta + gx, yDelta + gy);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void setPixel(int x, int y, int rgb) {
        if (x < this.image.getWidth() && y < this.image.getHeight()) {
            this.image.setRGB(x, y, rgb);
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }
}

