/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.utils.FiltersUI;
import com.aem.shelp.tech.utils.MachineTestFiltersDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;

public class MachinePickerPanel
implements FiltersUI.FilterListener,
ActionListener {
    private JPanel rootComponent = new JPanel();
    private JComboBox pickerBox;
    private FiltersUI filtersUI;
    private JButton testButton;
    private MachineTreeModel model;
    private AlertModifyListener modify;
    private boolean initialising;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MachinePickerPanel(AlertModifyListener modify, MachineTreeModel model) {
        this.modify = modify;
        this.model = model;
        this.initUI();
    }

    public void initUI() {
        this.filtersUI = new FiltersUI(this, true){

            @Override
            protected String getHideText() {
                return Language.get("EXCLUDE_COLUMN");
            }

            @Override
            protected String getShowText() {
                return Language.get("INCLUDE_COLUMN");
            }
        };
        this.pickerBox = new JComboBox<String>(new String[]{Language.get("MACHINE_PICKER_ALL_MACHINES"), Language.get("MACHINE_PICKER_FILTER")});
        this.pickerBox.setSelectedIndex(0);
        this.pickerBox.addActionListener(this);
        this.testButton = new JButton(Language.get("MACHINE_TEST_BUTTON"));
        this.testButton.addActionListener(this);
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.rootComponent.setLayout(new BorderLayout(3, 3));
        JPanel contentPanel = new JPanel(new BorderLayout(3, 3));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.pickerBox, "West");
        topPanel.add((Component)this.testButton, "East");
        contentPanel.add((Component)topPanel, "North");
        contentPanel.add(this.filtersUI.getRootComponent(), "Center");
        this.rootComponent.add((Component)contentPanel, "Center");
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.pickerBox.getSelectedIndex() == 0) {
            this.filtersUI.getRootComponent().setVisible(false);
        } else {
            this.filtersUI.getRootComponent().setVisible(true);
        }
    }

    @Override
    public void filterChanged(Filter filter) {
        if (this.modify != null) {
            this.modify.alertModified();
        }
    }

    public void load(Filter[] filters) {
        this.initialising = true;
        try {
            if (filters == null) {
                this.pickerBox.setSelectedIndex(0);
            } else {
                this.pickerBox.setSelectedIndex(1);
                this.filtersUI.setExistingFilters(filters);
            }
        }
        finally {
            this.initialising = false;
        }
    }

    public Filter[] getSpecifiedFilters() {
        if (this.includeAllMachines()) {
            return null;
        }
        return this.filtersUI.getFilters();
    }

    public boolean includeAllMachines() {
        return this.pickerBox.getSelectedIndex() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pickerBox) {
            this.updateEnabled();
            if (!this.initialising) {
                this.modify.alertModified();
            }
        } else if (e.getSource() == this.testButton) {
            Filter[] filters = null;
            if (this.pickerBox.getSelectedIndex() == 1) {
                filters = this.filtersUI.getFilters();
            }
            MachineTestFiltersDialog.showDialog(SwingUtil.getRootPaneContainer(this.rootComponent), this.model, filters);
        }
    }
}

