/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.ScaledImageLabel;
import utils.swing.images.ImageLoader;

public abstract class LanguagePanel {
    private ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel(){

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    };
    private String selectedLanguage;
    private final LanguageIcon[] languages = new LanguageIcon[]{new LanguageIcon(ImageLoader.getImageIcon("images/flags/en.png"), ImageLoader.getImageIconDimmer("images/flags/en.png"), "en"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/gb.png"), ImageLoader.getImageIconDimmer("images/flags/gb.png"), "gb"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/da.png"), ImageLoader.getImageIconDimmer("images/flags/da.png"), "da"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/de.png"), ImageLoader.getImageIconDimmer("images/flags/de.png"), "de"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/es.png"), ImageLoader.getImageIconDimmer("images/flags/es.png"), "es"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/fr.png"), ImageLoader.getImageIconDimmer("images/flags/fr.png"), "fr"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/it.png"), ImageLoader.getImageIconDimmer("images/flags/it.png"), "it"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/nl.png"), ImageLoader.getImageIconDimmer("images/flags/nl.png"), "nl"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/pt.png"), ImageLoader.getImageIconDimmer("images/flags/pt.png"), "pt"), new LanguageIcon(ImageLoader.getImageIcon("images/flags/sv.png"), ImageLoader.getImageIconDimmer("images/flags/sv.png"), "sv")};

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public LanguagePanel() {
        this.initUI();
        this.selectedLanguage = "en";
        if (Language.DEFLANG_ID != null) {
            this.setSelectedLanguage(Language.DEFLANG_ID);
        }
    }

    protected void selectLanguage(String languageCode) {
        this.setSelectedLanguage(languageCode);
    }

    public void setSelectedLanguage(String language) {
        this.selectedLanguage = language;
        this.rootComponent.repaint();
    }

    private void initUI() {
        ColorPropagatingPanel contents = new ColorPropagatingPanel(new FlowLayout());
        for (final LanguageIcon language : this.languages) {
            LanguageLabel label = new LanguageLabel(language);
            label.setSize(32, 32);
            label.setPreferredSize(new Dimension(32, 32));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    LanguagePanel.this.selectLanguage(language.languageFile);
                }
            });
            contents.add(label);
        }
        this.rootComponent.add(contents, 0, 0, 1, 1, 1, 1, 10, 0);
        this.rootComponent.setBackground(Color.white);
    }

    public class LanguageLabel
    extends ScaledImageLabel {
        private final LanguageIcon language;

        public LanguageLabel(LanguageIcon language) {
            super((ImageIcon)language.icon);
            this.language = language;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.language.languageFile.equals(LanguagePanel.this.selectedLanguage)) {
                this.setIcon(this.language.icon);
            } else {
                this.setIcon(this.language.dimIcon);
            }
            super.paintComponent(g);
        }
    }

    private class LanguageIcon {
        public Icon icon;
        public Icon dimIcon;
        public String languageFile;

        public LanguageIcon(Icon icon, Icon dimIcon, String languageFile) {
            this.icon = icon;
            this.dimIcon = dimIcon;
            this.languageFile = languageFile;
        }
    }
}

