/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import utils.swing.components.SHComboBox;
import utils.swing.components.reorderablepanel.ReorderablePanel;
import utils.swing.components.reorderablepanel.ReorderablePanelList;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class FiltersUI {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private Filter[] existingFilters;
    private ReorderablePanelList filterListPanel;
    private JButton newFilterButton;
    private ArrayList<FilterUI> filterUIList = new ArrayList();
    private FilterListener filterListener;
    private boolean isRemoteAccess;
    private String[] detailKeys = new String[0];

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public FiltersUI(FilterListener filterListener, boolean isRemoteAccess) {
        this.isRemoteAccess = isRemoteAccess;
        this.filterListener = filterListener;
        this.initUI();
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle.loadTestBundle("de");
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        FiltersUI ui = new FiltersUI(null, true);
        ui.setDetailKeys(new String[]{"Name", "Doodad"});
        ui.setExistingFilters(null);
        testFrame.getContentPane().add(ui.getRootComponent());
        testFrame.setVisible(true);
    }

    public void setDetailKeys(String[] keys) {
        this.detailKeys = keys;
    }

    public void setExistingFilters(Filter[] existingFilters) {
        this.clearFilters(false);
        this.existingFilters = existingFilters;
        if (existingFilters != null) {
            for (int i = 0; i < existingFilters.length; ++i) {
                Filter filter = existingFilters[i];
                this.addFilterToListPanels(filter, i == existingFilters.length - 1);
            }
        }
        this.filterListPanel.relayout();
    }

    public boolean isComplete() {
        if (this.filterUIList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.filterUIList.size(); ++i) {
            FilterUI ui = this.filterUIList.get(i);
            if (ui.isComplete()) continue;
            return false;
        }
        return true;
    }

    private void initUI() {
        this.filterListPanel = new ReorderablePanelList();
        this.filterListPanel.setBackground(UIManager.getColor("TextField.background"));
        JScrollPane sp = new JScrollPane(this.filterListPanel);
        sp.setBackground(UIManager.getColor("TextField.background"));
        JPanel southPanel = new JPanel(new FlowLayout());
        this.newFilterButton = new JButton(Language.get("LOGGING_ADD_FILTER"));
        this.newFilterButton.setEnabled(false);
        Font smallFont = SHStyle.smallerFont;
        this.newFilterButton.setFont(smallFont);
        this.newFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter filter = FiltersUI.this.isRemoteAccess ? new MachineFilter() : new CustomerFilter();
                FiltersUI.this.addFilterToListPanels(filter, true);
            }
        });
        southPanel.setBackground(Color.white);
        southPanel.add(this.newFilterButton);
        this.rootComponent.add((Component)sp, "Center");
        this.rootComponent.add((Component)southPanel, "South");
        this.rootComponent.setBorder(sp.getBorder());
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        this.newFilterButton.setEnabled(true);
    }

    private void clearFilters(boolean relayout) {
        this.filterUIList.clear();
        this.filterListPanel.getReorderablePanels().clear();
        if (relayout) {
            this.filterListPanel.relayout();
        }
    }

    private void addFilterToListPanels(Filter filter, boolean relayout) {
        FilterUI ui = new FilterUI(filter);
        this.filterUIList.add(ui);
        ui.setDragDropListener(this.filterListPanel.demoPanelDropTargetListener);
        this.filterListPanel.getReorderablePanels().add(ui);
        if (relayout) {
            this.filterListPanel.relayout();
        }
    }

    public void removeFilter(final FilterUI filterUI) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FiltersUI.this.filterUIList.remove(filterUI);
                FiltersUI.this.filterListPanel.getReorderablePanels().remove(filterUI);
                FiltersUI.this.filterListPanel.relayout();
                FiltersUI.this.filterListener.filterChanged(filterUI.getFilter());
            }
        });
    }

    public Filter[] getFilters() {
        Filter[] allFilters = new Filter[this.filterUIList.size()];
        for (int i = 0; i < this.filterUIList.size(); ++i) {
            allFilters[i] = this.filterUIList.get(i).getFilter();
        }
        return allFilters;
    }

    protected String getHideText() {
        return Language.get("HIDE_COLUMN");
    }

    protected String getShowText() {
        return Language.get("SHOW_COLUMN");
    }

    public void setEnabled(boolean b) {
        this.rootComponent.setEnabled(b);
        if (this.filterListPanel != null) {
            this.filterListPanel.setEnabled(b);
            this.newFilterButton.setEnabled(b);
            for (int i = 0; i < this.filterUIList.size(); ++i) {
                this.filterUIList.get(i).setEnabled(b);
            }
        }
    }

    public class FilterUI
    extends ReorderablePanel
    implements KeyListener,
    ActionListener {
        private GbPanel filterRoot = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        private SHComboBox actionBox;
        private SHComboBox fieldBox;
        private SHComboBox showHideBox;
        private JTextField actionTextField = new JTextField();
        private JLabel deleteLabel;
        private boolean loading;

        public FilterUI(Filter filter) {
            this.initUI(filter);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.filterRoot);
        }

        private void selectFieldForKey(String key) {
            if (FiltersUI.this.isRemoteAccess) {
                if (key == null) {
                    this.fieldBox.setSelectedIndex(3);
                } else if (key.equals(MachineFilter.FIELD_NAME)) {
                    this.fieldBox.setSelectedIndex(0);
                } else if (key.equals(MachineFilter.FIELD_GROUP)) {
                    this.fieldBox.setSelectedIndex(1);
                } else if (key.equals(MachineFilter.FIELD_ANCESTOR)) {
                    this.fieldBox.setSelectedIndex(2);
                } else if (key.equals(MachineFilter.FIELD_DETAILS)) {
                    this.fieldBox.setSelectedIndex(3);
                } else {
                    this.fieldBox.setSelectedIndex(3);
                }
            } else if (key == null) {
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 3);
            } else if (key.equals("Filter_Country")) {
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 0);
            } else if (key.equals("Filter_URL")) {
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 1);
            } else if (key.equals("Filter_Domain")) {
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 2);
            } else if (key.equals("Filter_Details")) {
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 3);
            } else {
                for (int i = 0; i < FiltersUI.this.detailKeys.length; ++i) {
                    if (!FiltersUI.this.detailKeys[i].equals(key)) continue;
                    this.fieldBox.setSelectedIndex(i);
                    return;
                }
                this.fieldBox.setSelectedIndex(FiltersUI.this.detailKeys.length + 3);
            }
        }

        private String getFieldKeyForIndex(int index) {
            if (FiltersUI.this.isRemoteAccess) {
                switch (index) {
                    case 0: {
                        return MachineFilter.FIELD_NAME;
                    }
                    case 1: {
                        return MachineFilter.FIELD_GROUP;
                    }
                    case 2: {
                        return MachineFilter.FIELD_ANCESTOR;
                    }
                    case 3: {
                        return MachineFilter.FIELD_DETAILS;
                    }
                }
                return MachineFilter.FIELD_DETAILS;
            }
            if (index >= FiltersUI.this.detailKeys.length) {
                switch (index -= FiltersUI.this.detailKeys.length) {
                    case 0: {
                        return "Filter_Country";
                    }
                    case 1: {
                        return "Filter_URL";
                    }
                    case 2: {
                        return "Filter_Domain";
                    }
                    case 3: {
                        return "Filter_Details";
                    }
                }
                return "Filter_Details";
            }
            return FiltersUI.this.detailKeys[index];
        }

        private void initUI(Filter initFilter) {
            Object[] variablesPlusAll;
            JLabel primaryLabel;
            this.filterRoot.setBackground(Color.WHITE);
            boolean isGerman = Language.DEFLANG_ID.equalsIgnoreCase("de");
            JLabel secondaryLabel = null;
            if (!isGerman) {
                primaryLabel = FiltersUI.this.isRemoteAccess ? new JLabel(Language.get("FILTERS_MACHINE")) : new JLabel(Language.get("FILTERS_CUSTOMER"));
            } else if (FiltersUI.this.isRemoteAccess) {
                primaryLabel = new JLabel(Language.get("FILTERS_MACHINE_1"));
                secondaryLabel = new JLabel(Language.get("FILTERS_MACHINE_2"));
            } else {
                primaryLabel = new JLabel(Language.get("FILTERS_CUSTOMER_1"));
                secondaryLabel = new JLabel(Language.get("FILTERS_CUSTOMER_2"));
            }
            this.actionBox = new SHComboBox(new Object[]{Language.get("EQUALS"), Language.get("NOT_EQUALS"), Language.get("CONTAINS"), Language.get("DOES_NOT_CONTAIN"), Language.get("MATCHES")});
            this.makeNaked(this.actionBox);
            this.showHideBox = isGerman ? new SHComboBox(new Object[]{FiltersUI.this.getShowText().toLowerCase(), FiltersUI.this.getHideText().toLowerCase()}) : new SHComboBox(new Object[]{FiltersUI.this.getShowText(), FiltersUI.this.getHideText()});
            this.makeNaked(this.showHideBox);
            if (FiltersUI.this.isRemoteAccess) {
                variablesPlusAll = new String[]{Language.get("NAME").toLowerCase(), Language.get("GROUP").toLowerCase(), Language.get("ANCESTOR_GROUP").toLowerCase(), Language.get("ANY_DETAILS").toLowerCase()};
            } else {
                int length = 4 + FiltersUI.this.detailKeys.length;
                variablesPlusAll = new String[length];
                for (int i = 0; i < FiltersUI.this.detailKeys.length; ++i) {
                    variablesPlusAll[i] = FiltersUI.this.detailKeys[i].toLowerCase();
                }
                variablesPlusAll[length - 4] = Language.get("COUNTRY").toLowerCase();
                variablesPlusAll[length - 3] = Language.get("CONNECT_URL").toLowerCase();
                variablesPlusAll[length - 2] = Language.get("CONNECT_DOMAIN").toLowerCase();
                variablesPlusAll[length - 1] = Language.get("ANY_DETAILS").toLowerCase();
            }
            this.fieldBox = new SHComboBox(variablesPlusAll);
            this.makeNaked(this.fieldBox);
            this.deleteLabel = new JLabel();
            this.deleteLabel.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/remove.svg,16"));
            this.deleteLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    FilterUI.this.deleteFilter();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            int X = 0;
            if (!isGerman) {
                this.filterRoot.add(this.showHideBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(primaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.fieldBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.actionBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.actionTextField, X++, 0, 1, 1, 1, 1, 10, 1);
                this.filterRoot.add(this.deleteLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            } else {
                this.filterRoot.add(primaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.showHideBox, X++, 0, 1, 1, 0, 1, 10, 1);
                if (secondaryLabel != null) {
                    this.filterRoot.add(secondaryLabel, X++, 0, 1, 1, 0, 1, 10, 1);
                }
                this.filterRoot.add(this.fieldBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.actionTextField, X++, 0, 1, 1, 1, 1, 10, 1);
                this.filterRoot.add(this.actionBox, X++, 0, 1, 1, 0, 1, 10, 1);
                this.filterRoot.add(this.deleteLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            }
            this.loadFromFilter(initFilter);
            this.actionTextField.addKeyListener(this);
            this.showHideBox.addActionListener(this);
            this.fieldBox.addActionListener(this);
            this.actionBox.addActionListener(this);
            Font smallFont = SHStyle.smallerFont;
            primaryLabel.setFont(smallFont);
            if (secondaryLabel != null) {
                secondaryLabel.setFont(smallFont);
            }
            this.fieldBox.setFont(smallFont);
            this.showHideBox.setFont(smallFont);
            this.actionBox.setFont(smallFont);
            this.actionTextField.setFont(smallFont);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.actionBox.setEnabled(enabled);
            this.showHideBox.setEnabled(enabled);
            this.fieldBox.setEnabled(enabled);
            this.actionTextField.setEnabled(enabled);
            this.deleteLabel.setEnabled(enabled);
        }

        public boolean isComplete() {
            return this.actionTextField.getText().trim().length() > 0;
        }

        private void deleteFilter() {
            FiltersUI.this.removeFilter(this);
        }

        private void loadFromFilter(Filter initFilter) {
            try {
                this.loading = true;
                this.actionBox.setSelectedIndex(initFilter.getCheckAction());
                this.selectFieldForKey(initFilter.getFieldNameToFilter());
                this.showHideBox.setSelectedIndex(initFilter.isShow() ? 0 : 1);
                this.actionTextField.setText(initFilter.getCheckActionText());
            }
            finally {
                this.loading = false;
            }
        }

        private void makeNaked(JComboBox box) {
            box.putClientProperty("NAKED", "YES");
        }

        public Filter getFilter() {
            if (FiltersUI.this.isRemoteAccess) {
                return new MachineFilter(this.showHideBox.getSelectedIndex() == 0, this.getFieldKeyForIndex(this.fieldBox.getSelectedIndex()), this.actionBox.getSelectedIndex(), this.actionTextField.getText());
            }
            return new CustomerFilter(this.showHideBox.getSelectedIndex() == 0, this.getFieldKeyForIndex(this.fieldBox.getSelectedIndex()), this.actionBox.getSelectedIndex(), this.actionTextField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.loading && FiltersUI.this.filterListener != null) {
                FiltersUI.this.filterListener.filterChanged(this.getFilter());
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!this.loading && FiltersUI.this.filterListener != null) {
                FiltersUI.this.filterListener.filterChanged(this.getFilter());
            }
        }
    }

    public static interface FilterListener {
        public void filterChanged(Filter var1);
    }
}

