/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.Filter;
import java.util.ArrayList;
import java.util.Iterator;

public class FilterLogicUtil {
    public static ArrayList<Machine> getShownMachines(Filter[] filters, ArrayList<Machine> allMachines) {
        FilterResult result = new FilterResult();
        result.allMachines = new ArrayList();
        boolean allHide = FilterLogicUtil.areAllHide(filters);
        for (Machine m : allMachines) {
            FilterLogicUtil.processFilter(m, filters, result, allHide);
        }
        return result.allMachines;
    }

    public static FilterResult applyFiltersToMachines(Filter[] filters, Iterator<Machine> descendentElements) {
        FilterResult result = new FilterResult();
        result.allMachines = new ArrayList();
        boolean allHide = FilterLogicUtil.areAllHide(filters);
        while (descendentElements.hasNext()) {
            Machine m = descendentElements.next();
            FilterLogicUtil.processFilter(m, filters, result, allHide);
        }
        return result;
    }

    private static boolean areAllHide(Filter[] filters) {
        boolean areAllHide = false;
        if (filters.length > 0) {
            areAllHide = true;
            for (Filter f : filters) {
                if (!f.isShow()) continue;
                areAllHide = false;
            }
        }
        return areAllHide;
    }

    private static void processFilter(Machine m, Filter[] filters, FilterResult result, boolean allHide) {
        if (filters == null || filters.length == 0) {
            result.allMachines.add(m);
            ++result.included;
        } else {
            boolean machineProcessed = false;
            for (Filter f : filters) {
                if (!f.include(m)) continue;
                machineProcessed = true;
                if (f.isShow()) {
                    result.allMachines.add(m);
                    ++result.included;
                    break;
                }
                ++result.excluded;
                break;
            }
            if (!machineProcessed) {
                if (allHide) {
                    result.allMachines.add(m);
                    ++result.included;
                } else {
                    ++result.excluded;
                }
            }
        }
    }

    static class FilterResult {
        ArrayList<Machine> allMachines;
        int included = 0;
        int excluded = 0;

        FilterResult() {
        }
    }
}

