/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.reporting;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.shelp.util.ErrorDialogs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.ostools.OSDirs;
import utils.progtools.StackTracer;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class ReportingClient {
    static String lastSaveLocation = OSDirs.getDesktopDir().getAbsolutePath();

    public static void fetchReport(RootPaneContainer rpc, TechClient client, File targetDir, String filename, long time) {
        try {
            ReportResult result = client.fetchReport(filename, time);
            File reportFile = new File(targetDir, result.getReportRequest().getReportFileName(0));
            if (reportFile.exists()) {
                reportFile.delete();
            }
            result.exportTo(reportFile);
        }
        catch (Throwable t) {
            String reason = StackTracer.getStacktrace(t);
            t.printStackTrace();
            SHGlassOptionPane.showErrorDialog(rpc, Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(rpc, Language.get("REPORT_ERROR_TITLE"), null, true, true);
            String msg = t.getMessage();
            if (msg == null) {
                dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + ")", reason);
            } else {
                dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + "," + msg + ")", reason);
            }
            dialog.setVisible(true);
        }
    }

    public static void showAccessPanelReportDialog(RootPaneContainer rpc, TechClient techClient, boolean all, boolean online, boolean offline, String[] ids) {
        AccessPanelReportDialog requestDialog = new AccessPanelReportDialog();
        requestDialog.showDialog(rpc);
        if (requestDialog.isOK()) {
            ReportRequest config = new ReportRequest();
            if (all) {
                config.reportOnAllMachines();
            } else if (online) {
                config.reportOnOnlinelMachines();
            } else if (offline) {
                config.reportOnOfflinelMachines();
            } else {
                config.machineIDs = ids;
            }
            config.notify = requestDialog.notifyWhenDone.isSelected();
            config.reportType = requestDialog.inventoryReport.isSelected() ? 0 : 1;
            File targetDir = new File(requestDialog.reportSaveDirectory.getText());
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            File reportFile = new File(targetDir, config.getReportFileName(0));
            try {
                int count = 1;
                while (reportFile.exists()) {
                    reportFile = new File(targetDir, config.getReportFileName(++count));
                }
                ReportResult result = techClient.requestReport(config);
                result.exportTo(reportFile);
            }
            catch (Throwable t) {
                String reason = StackTracer.getStacktrace(t);
                t.printStackTrace();
                SHGlassOptionPane.showErrorDialog(rpc, Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(rpc, Language.get("REPORT_ERROR_TITLE"), null, true, true);
                String msg = t.getMessage();
                if (msg == null) {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + ")", reason);
                } else {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + "," + msg + ")", reason);
                }
                dialog.setVisible(true);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        AccessPanelReportDialog dialog = new AccessPanelReportDialog();
        dialog.showDialog(frame);
    }

    static class AccessPanelReportDialog
    extends OKCancelDialogPanel
    implements KeyListener {
        private JTextField reportSaveDirectory;
        private JButton directoryPicker;
        private JRadioButton inventoryReport;
        private JRadioButton usageReport;
        private JCheckBox notifyWhenDone;
        private RootPaneContainer rpc;

        public AccessPanelReportDialog() {
            super(Language.get("REQUEST_REPORT"), Language.get("CANCEL"));
            JPanel contentPanel = this.getContentPanel();
            contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale(new Dimension(500, 300)));
            FixedWidthPanel panel = new FixedWidthPanel(contentPanel);
            this.setContent(panel);
            this.reportSaveDirectory.addKeyListener(this);
        }

        public void showDialog(RootPaneContainer rpc) {
            this.rpc = rpc;
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("ACCESS_REPORT"));
            abstractGlassDialog.showDialog();
        }

        protected JPanel getContentPanel() {
            this.inventoryReport = new JRadioButton();
            this.usageReport = new JRadioButton();
            this.notifyWhenDone = new JCheckBox(Language.get("REPORT_NOTIFY_DONE"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.inventoryReport);
            group.add(this.usageReport);
            this.inventoryReport.setSelected(true);
            JLabel inventoryReportTitle = new JLabel(Language.get("REPORT_INVENTORY_TITLE"));
            JLabel usageReportTitle = new JLabel(Language.get("REPORT_USAGE_TITLE"));
            JWrapLabel inventoryReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_INVENTORY_DESC"));
            JWrapLabel usageReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_USAGE_DESC"));
            MouseAdapter choice1 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AccessPanelReportDialog.this.inventoryReport.setSelected(true);
                }
            };
            MouseAdapter choice2 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AccessPanelReportDialog.this.usageReport.setSelected(true);
                }
            };
            inventoryReportTitle.addMouseListener(choice1);
            inventoryReportDesc.addMouseListener(choice1);
            usageReportTitle.addMouseListener(choice2);
            usageReportDesc.addMouseListener(choice2);
            inventoryReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            usageReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            ColorPropagatingGBPanel main = new ColorPropagatingGBPanel();
            StrippedContentPanel singleWrapper = new StrippedContentPanel(main, false);
            singleWrapper.setTopBottomPadding(2);
            ColorPropagatingGBPanel options = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
            options.setBorder(SHBorderFactory.createEmptyBorder(0, 20, 0, 0));
            int Y = 0;
            options.add(this.inventoryReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(inventoryReportTitle, 1, Y++, 1, 1, 1, 0, 11, 1);
            options.add(inventoryReportDesc, 1, Y++, 1, 1, 1, 0, 11, 1, new Insets(0, 3, 10, 3));
            options.add(this.usageReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(usageReportTitle, 1, Y++, 1, 1, 0, 0, 11, 1);
            options.add(usageReportDesc, 1, Y++, 1, 1, 0, 0, 11, 1, new Insets(0, 3, 10, 3));
            singleWrapper.addContent(options, Language.get("REPORT_TYPE_TITLE"), false);
            ColorPropagatingGBPanel settings = new ColorPropagatingGBPanel(new ScaledInsets(5, 5, 5, 5));
            this.reportSaveDirectory = new JTextField(lastSaveLocation);
            this.directoryPicker = new JButton(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"));
            SHButtonUI.makeButtonSegmentedRight(this.directoryPicker);
            this.directoryPicker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File directory = SafeJFileChooser.saveDirectory((Component)((Object)AccessPanelReportDialog.this.rpc), new File(AccessPanelReportDialog.this.reportSaveDirectory.getText()));
                    if (directory != null) {
                        AccessPanelReportDialog.this.reportSaveDirectory.setText(directory.getAbsolutePath());
                    }
                }
            });
            SwingUtil.setSizesToTallest(new JComponent[]{this.reportSaveDirectory, this.directoryPicker});
            settings.add(new JLabel(Language.get("SAVE_REPORT_TO")), 0, 0, 1, 1, 0, 1, 13, 0);
            settings.add(this.reportSaveDirectory, 1, 0, 1, 1, 1, 1, 17, 2, new Insets(5, 5, 5, 0));
            settings.add(this.directoryPicker, 2, 0, 1, 1, 0, 1, 17, 2, new Insets(5, 0, 5, 5));
            JLabel csv = new JLabel("CSV");
            csv.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            settings.add(new JLabel(Language.get("REPORT_FORMAT")), 0, 1, 1, 1, 0, 1, 13, 0);
            settings.add(csv, 1, 1, 1, 1, 0, 1, 17, 0);
            settings.add(this.notifyWhenDone, 1, 2, 1, 1, 0, 1, 17, 0, new Insets(5, 0, 5, 5));
            StrippedContentPanel.TitledSection section = singleWrapper.addContent(settings, Language.get("REPORT_OPTIONS_TITLE"), false);
            section.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 0, 0));
            singleWrapper.addVerticalFiller();
            singleWrapper.setBackgroundColours();
            JPanel userPanel = new JPanel();
            userPanel.setLayout(new GridLayout(1, 1));
            userPanel.add(main);
            return userPanel;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.setOkEnabled(this.reportSaveDirectory.getText().length() > 0);
        }
    }
}

