/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.reporting;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.history.HistoryDataSource;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;

public class ReportRequest {
    private static SimpleDateFormat REPORT_FILENAME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    public static final int FORMAT_CSV = 0;
    public static final int FORMAT_HTML = 1;
    public static final int FORMAT_PDF = 2;
    public static final int TYPE_ACCESS_HARDWARE = 0;
    public static final int TYPE_ACCESS_USAGE = 1;
    public static final int TYPE_HISTORY_SESSIONS = 2;
    public static final int TYPE_HISTORY_TECH_ACTIVITY = 3;
    public static final byte MACHINES_ALL = 0;
    public static final byte MACHINES_ONLINE = 1;
    public static final byte MACHINES_OFFLINE = 2;
    public int reportFormat;
    public int reportType;
    public boolean notify;
    public byte machineFilter = 0;
    public String[] machineIDs = null;
    public transient TechUser serverSideRequestingUser;
    public transient MergedTechGroup serverSideRequestingContext;
    public SearchConfig historySearchConfig;
    public HistoryDataSource transient_historySource;

    public void reportOnAllMachines() {
        this.machineFilter = 0;
    }

    public void reportOnHistory(SearchConfig historySearchConfig) {
        this.historySearchConfig = historySearchConfig;
    }

    public void reportOnOnlinelMachines() {
        this.machineFilter = 1;
    }

    public void reportOnOfflinelMachines() {
        this.machineFilter = (byte)2;
    }

    public void setCSV() {
        this.reportFormat = 0;
    }

    public void setPDF() {
        this.reportFormat = 2;
    }

    public void setHTML() {
        this.reportFormat = 1;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.reportFormat);
        m.append(this.reportType);
        m.append(this.machineFilter);
        m.append(this.machineIDs);
        m.append(this.notify);
        if (this.historySearchConfig == null) {
            m.append((String)null);
        } else {
            m.append(this.historySearchConfig.toMessage());
        }
        return m;
    }

    public static ReportRequest fromMessage(Message m) {
        ReportRequest request = new ReportRequest();
        request.reportFormat = m.getNextInt();
        request.reportType = m.getNextInt();
        request.machineFilter = m.getNextByte();
        request.machineIDs = m.getNextStringArray();
        request.notify = m.getNextBoolean();
        if (m.getNextType() == 0) {
            m.getNextString();
            request.historySearchConfig = null;
        } else {
            request.historySearchConfig = SearchConfig.fromMessage(m.getNextMessage());
        }
        return request;
    }

    public boolean includeMachine(Machine m) {
        if (this.machineFilter == 0) {
            return true;
        }
        if (this.machineFilter == 1 && m.isAvailable()) {
            return true;
        }
        return this.machineFilter == 2 && !m.isAvailable();
    }

    public boolean userCanViewMachine(Machine m) {
        return this.serverSideRequestingUser.canLoggedInTechUserSeeMachine(m, this.serverSideRequestingContext);
    }

    public String getReportFileName(int index) {
        String name = REPORT_FILENAME.format(new Date(System.currentTimeMillis()));
        if (index > 0) {
            name = name + " " + index;
        }
        if (this.reportFormat == 0) {
            name = name + ".csv";
        } else if (this.reportFormat == 1) {
            name = name + ".html";
        }
        if (this.reportFormat == 2) {
            name = name + ".pdf";
        }
        return Language.get(this.getReportNameTag()) + " - " + name;
    }

    public String getReportNameTag() {
        if (this.reportType == 2) {
            return "REPORT_SESSION_TITLE";
        }
        if (this.reportType == 3) {
            return "REPORT_TECHNICIANS_TITLE";
        }
        if (this.reportType == 0) {
            return "REPORT_INVENTORY_TITLE";
        }
        return "REPORT_USAGE_TITLE";
    }

    public void saveTo(File requestSave) throws IOException {
        Message m = this.toMessage();
        byte[] data = MessageUtils.messageToBytes(m);
        FileUtil.writeFile(requestSave, data);
    }
}

