/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.utils.LanguagePanel;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWSystem;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.avatar.AvatarPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class TechAccountProperties
extends PropertiesPage
implements ActionListener {
    private JButton changePasswordButton;
    private JButton logoutButton;
    private JButton reconnectButton_debug;
    private TransientTechUser techUser;
    private TechClient client;
    private AvatarPanel avatarPanel;
    private TechUi techui;
    private JLabel emailDesc;
    private Object AVATAR_LOCK = new Object();
    private TechAvatarFetchThread avatarFetchThread = null;
    private AvatarPanel.AvatarChangeListener avatarChangeListener = new AvatarPanel.AvatarChangeListener(){

        @Override
        public void avatarChanged(byte[] imageBytes) {
            ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes = imageBytes;
            try {
                TechAccountProperties.this.client.setAvatarImage(((TechAccountProperties)TechAccountProperties.this).techUser.username, imageBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private JLabel emailLabel;
    private JLabel displayNameLabel;
    private JLabel usernameLabel;

    public TechAccountProperties(PageListener listener, TechUi techui) {
        super(listener);
        this.techui = techui;
        this.initUI();
    }

    public void hideLogoutButton() {
        this.logoutButton.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechClient(TechClient client) {
        this.client = client;
        if (client != null) {
            this.techUser = client.getTechUser();
            this.changePasswordButton.setVisible(this.techUser.techUserCanChangePassword());
            this.avatarPanel.setVisible(!this.techUser.isServerAdmin() && !this.techUser.isAnonymousLogin);
            this.usernameLabel.setText(this.techUser.username);
            this.displayNameLabel.setText(this.techUser.displayName);
            boolean showEmail = this.techUser.emailAddress != null && this.techUser.emailAddress.trim().length() != 0;
            this.emailLabel.setVisible(showEmail);
            this.emailDesc.setVisible(showEmail);
            this.emailLabel.setText(this.techUser.emailAddress);
            if (this.techUser != null && !this.techUser.isServerAdmin()) {
                this.avatarPanel.setAvatarLoading();
                Object object = this.AVATAR_LOCK;
                synchronized (object) {
                    if (this.avatarFetchThread != null) {
                        this.avatarFetchThread.die();
                    }
                    this.avatarFetchThread = new TechAvatarFetchThread(this.techUser);
                    this.avatarFetchThread.start();
                }
            }
            this.repaint();
        }
    }

    private void initUI() {
        GbPanel panel = new GbPanel();
        StrippedContentPanel contentsPanel = new StrippedContentPanel(panel);
        GbPanel mainWrapper = new GbPanel();
        mainWrapper.add(panel, 0, 0, 1, 1, 1, 1, 11, 1);
        JScrollPane pane = new JScrollPane(mainWrapper);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        JPanel subPanel = new JPanel();
        GbPanelWrapper availabilityWrapper = new GbPanelWrapper(subPanel, new Insets(3, 3, 3, 3));
        JLabel usernameDesc = new JLabel(Language.get("ADMIN_LOGIN_NAME") + " ");
        usernameDesc.setHorizontalAlignment(4);
        usernameDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.usernameLabel = new JLabel();
        JLabel displayNameDesc = new JLabel(Language.get("ADMIN_TECH_NAME") + " ");
        displayNameDesc.setHorizontalAlignment(4);
        displayNameDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.displayNameLabel = new JLabel();
        this.emailDesc = new JLabel(Language.get("EMAIL_ADDRESS") + " ");
        this.emailDesc.setHorizontalAlignment(4);
        this.emailDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.emailLabel = new JLabel();
        this.changePasswordButton = new JButton(Language.get("ADMIN_PASSWORD"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
        this.changePasswordButton.addActionListener(this);
        this.logoutButton = new JButton(Language.get("LOGOUT"), ImageLoader.getImageIcon("images/svg/computing/power-off.svg,16"));
        this.logoutButton.addActionListener(this);
        this.reconnectButton_debug = new JButton(Language.get("RECONNECT"));
        this.reconnectButton_debug.addActionListener(this);
        this.avatarPanel = new AvatarPanel(60, 60, null, ImageLoader.getAsImage("images/svg/users/technician.svg,48"), this.avatarChangeListener, ImageLoader.getImageIconDisabled("images/svg/general/cancel.svg,16"));
        int Y = 0;
        availabilityWrapper.add(usernameDesc, 1, Y, 1, 1, 0, 1, 13, 0);
        availabilityWrapper.add(this.usernameLabel, 2, Y, 1, 1, 100, 1, 17, 2);
        availabilityWrapper.add(this.logoutButton, 3, Y++, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 0));
        if (CentralDebugging.SHOW_RECONNECT_IN_TECH_UI_DEBUG) {
            availabilityWrapper.add(this.reconnectButton_debug, 3, Y++, 1, 1, 0, 1, 17, 0, new Insets(3, 3, 3, 0));
        }
        availabilityWrapper.add(displayNameDesc, 1, Y, 1, 1, 0, 1, 13, 0);
        availabilityWrapper.add(this.displayNameLabel, 2, Y++, 1, 1, 100, 1, 17, 2);
        availabilityWrapper.add(this.emailDesc, 1, Y, 1, 1, 0, 1, 13, 0);
        availabilityWrapper.add(this.emailLabel, 2, Y++, 1, 1, 100, 1, 17, 2);
        availabilityWrapper.add(this.changePasswordButton, 1, Y++, 1, 1, 1, 1, 17, 0, new Insets(30, 3, 3, 3));
        availabilityWrapper.add(this.avatarPanel, 0, 0, 1, Y, 0, 0, 11, 0, new Insets(0, 30, 0, 30));
        contentsPanel.addContent(subPanel, Language.get("TECH_UI_ACCOUNT_DETAILS"));
        final JButton restartButton = new JButton(Language.get("SWITCH_LANGUAGE"));
        restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWSystem.forkVirtualApp(JWSystem.getMyAppName(), null, null, false, true);
                    Thread.sleep(1000L);
                    System.exit(0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        restartButton.setEnabled(false);
        GbPanel restartButtonPanel = new GbPanel();
        restartButtonPanel.add(restartButton, 0, 0, 1, 1, 1, 1, 10, 0);
        ColorPropagatingPanel languagePanel = new ColorPropagatingPanel(new BorderLayout());
        LanguagePanel languageChangePanel = new LanguagePanel(){

            @Override
            protected void selectLanguage(String languageCode) {
                super.selectLanguage(languageCode);
                try {
                    JWInstallApp.setChosenLanguage(languageCode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                restartButton.setEnabled(true);
            }
        };
        languagePanel.add((Component)languageChangePanel.getRootComponent(), "West");
        languagePanel.add((Component)restartButtonPanel, "East");
        contentsPanel.addContent(languagePanel, Language.get("TECH_UI_LANGUAGE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
    }

    @Override
    public void load(Object loadFromObject) {
    }

    @Override
    public void save(Object saveToObject) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PasswordDialog dialog;
        Object o = e.getSource();
        if (o == this.logoutButton) {
            this.techui.logoutTechnician(true);
        } else if (o == this.reconnectButton_debug) {
            try {
                this.techui.reconnectTechnician();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (o == this.changePasswordButton && (dialog = new PasswordDialog((RootPaneContainer)((Object)this.getRootPane().getParent()), 500, 200, true, true, false, false, this.techUser.username, null)).isOK()) {
            String newPassword = new String(dialog.newPassword);
            try {
                if (this.client.setTechnicianPassword(newPassword)) {
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)((Object)this.getRootPane().getParent()), Language.get("PASSWORD_CHANGED_MESSAGE"), Language.get("PASSWORD_CHANGED_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/ok.svg,48"), Language.get("CLOSE"));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)((Object)this.getRootPane().getParent()), t.getMessage(), Language.get("CONFIG_SAVE_ERROR"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }

    class TechAvatarFetchThread
    extends Thread {
        private TransientTechUser user;
        private boolean die;

        public TechAvatarFetchThread(TransientTechUser user) {
            super("TechAvatarFetchThread");
            this.die = false;
            this.user = user;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            byte[] avatar;
            try {
                avatar = ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes == null ? TechAccountProperties.this.client.getAvatarImage(this.user.username) : ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes;
            }
            catch (Exception e) {
                System.out.println("[TechAvatarFetchThread] Unable to fetch avatar for user " + this.user.username);
                e.printStackTrace();
                byte[] dummy = new byte[]{};
                TechAccountProperties.this.avatarPanel.setAvatarImage(dummy);
                return;
            }
            if (!this.die) {
                this.user.avatarBytes = avatar;
                TechAccountProperties.this.avatarPanel.setAvatarImage(avatar);
            }
        }
    }
}

