/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class LayoutPreferencesPanel
extends PropertiesPage
implements ActionListener {
    private JCheckBox showChat;
    private JCheckBox enableEcho = new JCheckBox(Language.get("ENABLE_TEXT_ECHOING"));
    private JCheckBox showButtonBar;
    private JCheckBox showRecording;
    private JComboBox sizeBox;
    private JComboBox zoomBox;
    private static final boolean REMEMBER_SIZE = true;

    public LayoutPreferencesPanel(PageListener listener) {
        super(listener);
        this.showChat = new JCheckBox(Language.get("SHOW_CHAT_OPTION"));
        this.showButtonBar = new JCheckBox(Language.get("SHOW_BUTTON_OPTION"));
        this.showRecording = new JCheckBox(Language.get("SHOW_RECORDING_SHORTCUTS"));
        this.zoomBox = new JComboBox<String>(new String[]{Language.get("TECH_UI_FIT_NO_ZOOM"), Language.get("TECH_UI_FIT_ALL"), Language.get("TECH_UI_FIT_HEIGHT")});
        this.sizeBox = new JComboBox<String>(new String[]{Language.get("MAXIMIZED"), "80 % " + Language.get("PERCENT_OF_THE_SCREEN"), "70 % " + Language.get("PERCENT_OF_THE_SCREEN"), "60 % " + Language.get("PERCENT_OF_THE_SCREEN"), "50 % " + Language.get("PERCENT_OF_THE_SCREEN"), Language.get("SAME_AS_LAST_SIZE"), Language.get("SAME_AS_LAST_SIZE_LOCATION")});
        this.sizeBox.setSelectedIndex(3);
        JLabel sizeLabel = new JLabel(Language.get("TECH_PROPERTIES_SIZE"));
        JLabel zoomLabel = new JLabel(Language.get("TECH_PROPERTIES_ZOOM"));
        JWrapLabel descLabel = new JWrapLabel("<html>" + Language.get("VISUAL_NEW_SESSION_DESC") + "</html>");
        this.showChat.addActionListener(this);
        this.showButtonBar.addActionListener(this);
        this.showRecording.addActionListener(this);
        this.sizeBox.addActionListener(this);
        this.zoomBox.addActionListener(this);
        this.enableEcho.addActionListener(this);
        GbPanel panel = new GbPanel();
        StrippedContentPanel contentsPanel = new StrippedContentPanel(panel);
        GbPanel mainWrapper = new GbPanel();
        mainWrapper.add(panel, 0, 0, 1, 1, 1, 1, 11, 1);
        JScrollPane pane = new JScrollPane(mainWrapper);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        ColorPropagatingPanel visualLayout = new ColorPropagatingPanel();
        GridBagLayout gbl = new GridBagLayout();
        visualLayout.setLayout(gbl);
        visualLayout.add(descLabel);
        visualLayout.add(this.showChat);
        visualLayout.add(this.showButtonBar);
        visualLayout.add(this.enableEcho);
        visualLayout.add(this.showRecording);
        visualLayout.add(this.sizeBox);
        visualLayout.add(sizeLabel);
        visualLayout.add(zoomLabel);
        visualLayout.add(this.zoomBox);
        int Y = 0;
        gbl.setConstraints(descLabel, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, new ScaledInsets(5, 0, 5, 0), 0, 0));
        gbl.setConstraints(this.showChat, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, new ScaledInsets(0, 10, 0, 0), 0, 0));
        gbl.setConstraints(this.showButtonBar, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, new ScaledInsets(0, 10, 0, 0), 0, 0));
        gbl.setConstraints(this.enableEcho, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, new ScaledInsets(0, 10, 0, 0), 0, 0));
        gbl.setConstraints(this.showRecording, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, new ScaledInsets(0, 10, 5, 0), 0, 0));
        gbl.setConstraints(sizeLabel, new GridBagConstraints(0, Y, 1, 1, 0.0, 1.0, 17, 2, new ScaledInsets(0, 0, 5, 0), 0, 0));
        gbl.setConstraints(this.sizeBox, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, new ScaledInsets(0, 10, 5, 0), 0, 0));
        gbl.setConstraints(zoomLabel, new GridBagConstraints(0, Y, 1, 1, 0.0, 1.0, 17, 2, new ScaledInsets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(this.zoomBox, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, new ScaledInsets(0, 10, 0, 0), 0, 0));
        contentsPanel.addContent(visualLayout, Language.get("LAYOUT_PREFERENCE_TITLE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
    }

    @Override
    public void load(Object loadFromObject) {
        Properties props = (Properties)loadFromObject;
        this.showChat.setSelected(props.getProperty(TechProperties.PROP_SHOW_CHAT, "on").equalsIgnoreCase("on"));
        this.showButtonBar.setSelected(props.getProperty(TechProperties.PROP_SHOW_MENU, "on").equalsIgnoreCase("on"));
        this.enableEcho.setSelected(props.getProperty(TechProperties.PROP_ENABLE_TEXT_ECHO, "on").equalsIgnoreCase("on"));
        this.showRecording.setSelected(props.getProperty(TechProperties.PROP_SHOW_RECORDING, "on").equalsIgnoreCase("on"));
        try {
            System.out.println("[LayoutPreferencesPanel] Loading windows size option: " + props.getProperty(TechProperties.PROP_WINDOW_SIZE));
            this.sizeBox.setSelectedIndex(Integer.parseInt(props.getProperty(TechProperties.PROP_WINDOW_SIZE, "3")));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sizeBox.setSelectedIndex(3);
        }
        try {
            this.zoomBox.setSelectedIndex(Integer.parseInt(props.getProperty(TechProperties.PROP_ZOOM, "0")));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.zoomBox.setSelectedIndex(0);
        }
    }

    @Override
    public void save(Object saveToObject) {
        Properties props = (Properties)saveToObject;
        if (this.showChat.isSelected()) {
            props.setProperty(TechProperties.PROP_SHOW_CHAT, "on");
        } else {
            props.setProperty(TechProperties.PROP_SHOW_CHAT, "off");
        }
        if (this.showButtonBar.isSelected()) {
            props.setProperty(TechProperties.PROP_SHOW_MENU, "on");
        } else {
            props.setProperty(TechProperties.PROP_SHOW_MENU, "off");
        }
        if (this.enableEcho.isSelected()) {
            props.setProperty(TechProperties.PROP_ENABLE_TEXT_ECHO, "on");
        } else {
            props.setProperty(TechProperties.PROP_ENABLE_TEXT_ECHO, "off");
        }
        if (this.showRecording.isSelected()) {
            props.setProperty(TechProperties.PROP_SHOW_RECORDING, "on");
        } else {
            props.setProperty(TechProperties.PROP_SHOW_RECORDING, "off");
        }
        System.out.println("[LayoutPreferencesPanel] Saving windows size option: " + this.sizeBox.getSelectedIndex());
        props.setProperty(TechProperties.PROP_WINDOW_SIZE, Integer.toString(this.sizeBox.getSelectedIndex()));
        props.setProperty(TechProperties.PROP_ZOOM, Integer.toString(this.zoomBox.getSelectedIndex()));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.contentChanged(true);
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }
}

