/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.portforward;

public class CommonTCPPorts {
    public static TCPPort[] PORTS = new TCPPort[]{new TCPPort(22, "Secure Shell", "SSH"), new TCPPort(23, "Telnet", null), new TCPPort(25, "Simple Mail Transfer Protocol", "SMTP"), new TCPPort(53, "Domain Name Server", "DNS"), new TCPPort(80, "Hyper Text Transfer Protocol", "HTTP"), new TCPPort(110, "Post Office Protocol v3", "POP3"), new TCPPort(139, "NetBIOS", null), new TCPPort(143, "Internet Message Access Protocol", "IMAP4"), new TCPPort(389, "Lightweight Directory Access Protocol", "LDAP"), new TCPPort(443, "Hyper Text Transfer Protocol (SSL)", "HTTPS"), new TCPPort(631, "Common Unix Printing System", "CUPS"), new TCPPort(636, "Lightweight Directory Access Protocol (SSL)", "LDAPS"), new TCPPort(993, "Internet Message Access Protocol (SSL)", "LDAPS"), new TCPPort(995, "Post Office Protocol v3 (SSL)", "LDAPS"), new TCPPort(1080, "TCP SOCKS Proxy", "SOCKS"), new TCPPort(3389, "Terminal Server (RDP)", "RDP"), new TCPPort(5800, "VNC over HTTP", "VNC")};

    public TCPPort getPort(int port) {
        for (TCPPort tcpPort : PORTS) {
            if (tcpPort.port != port) continue;
            return tcpPort;
        }
        return null;
    }

    public static class TCPPort {
        public int port;
        public String name;
        public String abbreviation;

        public TCPPort(int port, String name, String abbreviation) {
            this.port = port;
            this.name = name;
            this.abbreviation = abbreviation;
        }

        public String getPortAsString() {
            return Integer.toString(this.port);
        }

        public String toString() {
            return "TCP " + this.port + " " + this.name + " " + this.abbreviation;
        }
    }
}

