/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.portforward;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelTarget;
import com.aem.shelp.tech.portforward.AppTunnelUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JEditableLabel;
import utils.swing.components.animated.arrow.ArrowAnimatedIcon;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;

public class AppTunnelItem
implements ActionListener {
    private final AppTunnelUI appTunnelUI;
    public ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel();
    private ColorPropagatingGBPanel targetListPanel = new ColorPropagatingGBPanel();
    private ColorPropagatingGBPanel targetsPanel = new ColorPropagatingGBPanel();
    private GbPanel addNewPanel = new ColorPropagatingGBPanel();
    private JButton newPortTargetButton = new JButton(Language.get("PF_NEW_TARGET"), ImageLoader.getImageIcon(Icons.overlay("images/svg/computing/app-connection.svg,16", "images/svg/general/add.svg,12")));
    private JToggleButton configureButton = new JToggleButton(Language.get("EDIT"), ImageLoader.getImageIcon("images/svg/general/pencil.svg,16"));
    private JButton deleteAllButton = new JButton(Language.get("PF_REMOVE_ALL"));
    private JCheckBox pinToMachine = new JCheckBox(Language.get("PF_PIN_MACHINE"));
    private JCheckBox runCommandCheckBox = new JCheckBox(Language.get("PF_RUN_COMMAND_BOX"));
    private ColorPropagatingGBPanel commandConfigPanel;
    private JButton pickBinary = new JButton(Language.get("PF_PICK_EXE"), ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"));
    private JButton addHostname = new JButton(Language.get("PF_ADD_HOST"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private JButton addPort = new JButton(Language.get("PF_ADD_PORT"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
    private JTextArea commandArea;
    private ArrowAnimatedIcon arrowAnimatedIcon = new ArrowAnimatedIcon();
    private final AppTunnelSpecification spec;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public AppTunnelItem(AppTunnelUI appTunnelUI, AppTunnelSpecification spec, AppTunnelUI.AppTunnelMessageListener[] existingSessions) {
        this.appTunnelUI = appTunnelUI;
        this.spec = spec;
        this.initUI(existingSessions);
    }

    public void showDeleteButton(boolean showDelete) {
        this.deleteAllButton.setVisible(showDelete);
        for (Component c : this.targetsPanel.getComponents()) {
            if (!(c instanceof TargetPanel)) continue;
            ((TargetPanel)c).setShowDeleteButton(showDelete);
        }
    }

    private void initUI(AppTunnelUI.AppTunnelMessageListener[] existingSessions) {
        SHButtonUI.makeButtonRed(this.deleteAllButton);
        this.deleteAllButton.setVisible(false);
        this.deleteAllButton.addActionListener(this);
        JLabel title = new JLabel();
        title.setFont(SHStyle.mediumFont);
        title.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 0, 10));
        JLabel portLabel = new JLabel();
        portLabel.setFont(SHStyle.smallerFont);
        portLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        portLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 0, 3));
        int Y = 0;
        this.rootComponent.add(title, 0, Y, 1, 1, 0, 0, 17, 1);
        this.rootComponent.add(portLabel, 1, Y, 1, 1, 1, 0, 17, 1);
        this.rootComponent.add(this.deleteAllButton, 2, Y, 1, 1, 0, 0, 10, 1);
        this.rootComponent.add(this.configureButton, 3, Y++, 1, 1, 0, 0, 10, 1, new Insets(0, 5, 0, 0));
        this.rootComponent.add(this.targetListPanel, 0, Y++, 4, 1, 1, 1, 10, 1);
        title.setText(this.spec.getTitle());
        portLabel.setText(Language.get("PORT") + ": " + this.spec.getRemotePort());
        this.configureButton.addActionListener(this);
        Y = 0;
        ArrayList<AppTunnelTarget> targets = this.spec.getTargets();
        for (AppTunnelTarget target : targets) {
            TargetPanel panel = new TargetPanel(target, existingSessions);
            this.targetsPanel.add(panel, 0, Y++, 1, 1, 1, 0, 10, 1);
        }
        this.addNewPanel.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addNewPanel.add(this.newPortTargetButton, 0, 0, 1, 1, 1, 0, 17, 0);
        this.runCommandCheckBox.addActionListener(this);
        this.pinToMachine.addActionListener(this);
        this.pickBinary.addActionListener(this);
        this.addHostname.addActionListener(this);
        this.addPort.addActionListener(this);
        this.pickBinary.setHorizontalAlignment(2);
        this.addHostname.setHorizontalAlignment(2);
        this.addPort.setHorizontalAlignment(2);
        GbPanel rightPanel = new GbPanel();
        rightPanel.setBorder(SHBorderFactory.createEmptyBorder(0, 10, 0, 0));
        rightPanel.add(this.pickBinary, 1, 0, 1, 1, 0, 0, 11, 2);
        rightPanel.add(this.addHostname, 1, 1, 1, 1, 0, 0, 11, 2, new Insets(3, 0, 3, 0));
        rightPanel.add(this.addPort, 1, 2, 1, 1, 0, 1, 11, 2);
        this.commandConfigPanel = new ColorPropagatingGBPanel();
        this.commandArea = new JTextArea();
        JScrollPane commandPane = new JScrollPane(this.commandArea);
        SwingUtil.setHeight(commandPane, SimpleHelpLookAndFeel.scale(50));
        this.commandConfigPanel.add(commandPane, 0, 0, 1, 1, 1, 0, 10, 1);
        this.commandConfigPanel.add(rightPanel, 1, 0, 1, 1, 0, 0, 11, 1);
        this.addNewPanel.add(this.pinToMachine, 0, 1, 1, 1, 1, 0, 17, 1, new Insets(10, 0, 0, 0));
        this.addNewPanel.add(this.runCommandCheckBox, 0, 2, 1, 1, 1, 0, 17, 1);
        this.addNewPanel.add(this.commandConfigPanel, 0, 3, 1, 1, 1, 0, 17, 1);
        this.newPortTargetButton.addActionListener(this);
        this.addNewPanel.setVisible(false);
        this.updateVisible();
        this.targetListPanel.add(this.targetsPanel, 0, 0, 1, 1, 1, 0, 10, 1);
        this.targetListPanel.add(this.addNewPanel, 0, 1, 1, 1, 1, 0, 10, 1);
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(2, 2, 5, 1));
    }

    private void loadFromSpec() {
        this.runCommandCheckBox.setSelected(this.spec.useCommand());
        this.pinToMachine.setSelected(this.spec.isPinned());
        this.commandArea.setText(this.spec.getCommand());
        this.updateVisible();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pickBinary) {
            Document d = this.commandArea.getDocument();
            File file = SafeJFileChooser.pickFile(this.rootComponent);
            if (file != null) {
                try {
                    d.remove(0, d.getLength());
                    d.insertString(0, file.getAbsolutePath(), null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getSource() == this.pinToMachine) {
            this.spec.setIsPinned(this.pinToMachine.isSelected());
        } else if (e.getSource() == this.addPort) {
            Document d = this.commandArea.getDocument();
            try {
                d.insertString(this.commandArea.getCaretPosition(), "${PORT}", null);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.addHostname) {
            Document d = this.commandArea.getDocument();
            try {
                d.insertString(this.commandArea.getCaretPosition(), "localhost", null);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.runCommandCheckBox) {
            this.spec.setUseCommand(this.runCommandCheckBox.isSelected());
            this.updateVisible();
        } else if (e.getSource() == this.configureButton) {
            if (this.configureButton.isSelected()) {
                this.loadFromSpec();
                this.configureButton.setIcon(ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
                this.configureButton.setText(Language.get("DONE"));
            } else {
                this.configureButton.setIcon(ImageLoader.getImageIcon("images/svg/general/pencil.svg,16"));
                this.configureButton.setText(Language.get("EDIT"));
            }
            this.addNewPanel.setVisible(this.configureButton.isSelected());
            this.configureButton.repaint();
            this.showDeleteButton(this.configureButton.isSelected());
        } else if (e.getSource() == this.newPortTargetButton) {
            AppTunnelTarget target = new AppTunnelTarget(this.spec, "");
            this.spec.addTarget(target);
            TargetPanel panel = new TargetPanel(target, null);
            panel.setShowDeleteButton(true);
            panel.setBackground(this.targetsPanel.getBackground());
            this.targetsPanel.add(panel, 0, this.targetsPanel.getComponentCount(), 1, 1, 1, 0, 10, 1);
            this.targetsPanel.revalidate();
            this.targetsPanel.repaint();
            panel.startEditingTargetLabel();
        } else if (e.getSource() == this.deleteAllButton && SHGlassOptionPane.showOkCancelDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("PF_CONFIRM_DELETE_MSG", new Object[]{this.spec.getTitle()}), Language.get("PF_CONFIRM_DELETE"), ImageLoader.getImageIcon("images/svg/dialogs/question.svg,48"), Language.get("DELETE"))) {
            this.appTunnelUI.deleteSpecification(this.spec);
            this.spec.setIsPinned(false);
            this.save();
        }
    }

    private void updateVisible() {
        this.commandConfigPanel.setVisible(this.runCommandCheckBox.isSelected());
        this.commandConfigPanel.repaint();
    }

    public boolean isForSpec(AppTunnelSpecification spec) {
        return this.spec.equals(spec);
    }

    private TargetPanel getPanelFor(AppTunnelTarget target) {
        for (Component c : this.targetsPanel.getComponents()) {
            TargetPanel targetPanel;
            if (!(c instanceof TargetPanel) || !(targetPanel = (TargetPanel)c).isForTarget(target)) continue;
            return targetPanel;
        }
        return null;
    }

    public void updateMessage(AppTunnelUI.AppTunnelMessageListener appTunnelMessageListener, AppTunnelTarget target) {
        TargetPanel panel = this.getPanelFor(target);
        if (panel != null) {
            panel.updateMessage(appTunnelMessageListener);
        }
    }

    public void sessionClosed(AppTunnelUI.AppTunnelMessageListener appTunnelMessageListener, AppTunnelTarget target) {
        TargetPanel panel = this.getPanelFor(target);
        if (panel != null) {
            panel.sessionClosed(appTunnelMessageListener);
        }
    }

    public void addSession(AppTunnelTarget target, AppTunnelUI.AppTunnelMessageListener session) {
        TargetPanel panel = this.getPanelFor(target);
        if (panel != null) {
            panel.addNewSession(session);
        }
    }

    public void save() {
        this.spec.setUseCommand(this.runCommandCheckBox.isSelected());
        this.spec.setCommand(this.commandArea.getText());
        this.appTunnelUI.save(this.spec);
    }

    public class ConnectedSessionRow
    extends JPanel
    implements MouseListener {
        private final AppTunnelUI.AppTunnelMessageListener newSession;
        private JLabel label = new JLabel();
        private JButton disconnect = new JButton(Language.get("CLOSE_SESSION"));

        public ConnectedSessionRow(AppTunnelUI.AppTunnelMessageListener newSession) {
            this.newSession = newSession;
            this.setLayout(new BorderLayout());
            this.label.setFont(SHStyle.smallerFont);
            this.add((Component)this.label, "Center");
            SHButtonUI.makeButtonRed(this.disconnect);
            GbPanel buttonPanel = new GbPanel();
            buttonPanel.add(this.disconnect, 0, 0, 1, 1, 1, 1, 10, 0);
            this.add((Component)buttonPanel, "East");
            this.disconnect.addMouseListener(this);
            this.disconnect.setEnabled(false);
            System.out.println("[ConnectedSessionRow] Adding row for " + newSession);
            this.updateMessage(newSession);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.newSession.terminate();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.disconnect.setEnabled(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.disconnect.setEnabled(false);
        }

        public void updateMessage(AppTunnelUI.AppTunnelMessageListener messageListener) {
            if (messageListener == null) {
                return;
            }
            if (messageListener.isConnected()) {
                this.label.setIcon(ImageLoader.getImageIcon("images/svg/general/world.svg,16"));
            } else {
                this.label.setIcon(AppTunnelItem.this.arrowAnimatedIcon);
            }
            this.label.setText(messageListener.getMessage());
            this.repaint();
        }
    }

    private class TargetPanel
    extends ColorPropagatingGBPanel
    implements ActionListener,
    JEditableLabel.EditListener {
        private final AppTunnelTarget target;
        private final ColorPropagatingGBPanel leftPanel;
        private JEditableLabel targetInfoLabel = new JEditableLabel(false);
        private JButton connectButton = new JButton();
        private JButton deleteButton = new JButton();
        private JPanel existingSessionsList = new ColorPropagatingPanel();
        private SimpleList<AppTunnelUI.AppTunnelMessageListener> sessions = new SimpleList();

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.existingSessionsList != null) {
                this.existingSessionsList.setBackground(c);
            }
        }

        public TargetPanel(AppTunnelTarget target, AppTunnelUI.AppTunnelMessageListener[] existingSessions) {
            this.target = target;
            SwingUtil.setWidth(this.targetInfoLabel, 200);
            this.connectButton.setText(Language.get("CONNECT"));
            this.deleteButton.setText(Language.get("REMOVE"));
            this.deleteButton.setVisible(false);
            SwingUtil.setSizesToWidest(this.connectButton, this.deleteButton);
            JLabel icon = new JLabel(ImageLoader.getImageIcon("images/svg/computing/app-connection.svg,16"));
            int X = 0;
            this.leftPanel = new ColorPropagatingGBPanel();
            this.leftPanel.add(icon, X++, 0, 1, 1, 0, 1, 13, 1);
            this.leftPanel.add(this.targetInfoLabel, X++, 0, 1, 1, 0, 1, 17, 1);
            this.leftPanel.add(this.connectButton, X++, 0, 1, 1, 0, 1, 17, 2);
            this.leftPanel.add(this.deleteButton, X++, 0, 1, 1, 0, 1, 17, 2);
            this.add(this.leftPanel, 0, 0, 1, 1, 0, 1, 18, 2, new Insets(0, 10, 0, 0));
            this.add(this.existingSessionsList, 1, 0, 1, 1, 1, 1, 17, 1, new Insets(0, 10, 0, 0));
            this.existingSessionsList.setBorder(SHBorderFactory.createEmptyBorder(0, 30, 0, 0));
            this.targetInfoLabel.setText(target.getRemoteHost());
            this.targetInfoLabel.setIsEditable(false);
            SHButtonUI.makeButtonRed(this.deleteButton);
            this.deleteButton.addActionListener(this);
            this.connectButton.addActionListener(this);
            this.setBorder(SHBorderFactory.createEmptyBorder(3, 10, 0, 0));
            this.targetInfoLabel.addListener(this);
            this.existingSessionsList.setLayout(new GridLayout(0, 1));
            if (existingSessions != null) {
                for (AppTunnelUI.AppTunnelMessageListener existingSession : existingSessions) {
                    this.addNewSession(existingSession);
                }
            }
        }

        public void addNewSession(AppTunnelUI.AppTunnelMessageListener newSession) {
            this.sessions.add(newSession);
            ConnectedSessionRow row = new ConnectedSessionRow(newSession);
            row.setBorder(SHBorderFactory.createEmptyBorder(2, 0, 2, 0));
            row.setBackground(this.existingSessionsList.getBackground());
            this.existingSessionsList.add(row);
            this.existingSessionsList.revalidate();
            this.existingSessionsList.repaint();
        }

        public void setShowDeleteButton(boolean showDelete) {
            if (!showDelete) {
                AppTunnelItem.this.save();
            }
            this.connectButton.setVisible(!showDelete);
            this.deleteButton.setVisible(showDelete);
            this.targetInfoLabel.setIsEditable(showDelete);
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.connectButton) {
                AppTunnelItem.this.appTunnelUI.requestServiceConnection(this.target);
            } else if (e.getSource() == this.deleteButton) {
                AppTunnelItem.this.spec.removeTarget(this.target);
                AppTunnelItem.this.targetsPanel.remove(this);
                AppTunnelItem.this.targetsPanel.revalidate();
                AppTunnelItem.this.targetsPanel.repaint();
            }
        }

        public void startEditingTargetLabel() {
            this.targetInfoLabel.startEdit();
        }

        @Override
        public void editableLabelStartEdit() {
        }

        @Override
        public void editableLabelValueSet(String newValue) {
            this.target.setRemoteHost(newValue);
            AppTunnelItem.this.save();
        }

        private ConnectedSessionRow getRowFor(AppTunnelUI.AppTunnelMessageListener messageListener) {
            for (Component componentRow : this.existingSessionsList.getComponents()) {
                ConnectedSessionRow row;
                if (!(componentRow instanceof ConnectedSessionRow) || (row = (ConnectedSessionRow)componentRow).newSession != messageListener) continue;
                return row;
            }
            return null;
        }

        public void updateMessage(AppTunnelUI.AppTunnelMessageListener messageListener) {
            ConnectedSessionRow row = this.getRowFor(messageListener);
            if (row != null) {
                row.updateMessage(messageListener);
            }
        }

        public void sessionClosed(AppTunnelUI.AppTunnelMessageListener appTunnelMessageListener) {
            ConnectedSessionRow row = this.getRowFor(appTunnelMessageListener);
            if (row != null) {
                this.existingSessionsList.remove(row);
                this.existingSessionsList.revalidate();
                this.existingSessionsList.repaint();
            }
        }

        public boolean isForTarget(AppTunnelTarget target) {
            return this.target.equals(target);
        }
    }
}

