/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.invitations;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.jw.SHJWUtil;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import utils.swing.JFixedWidthTextField;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class InvitationURLPanel
implements ActionListener {
    private JPanel urlPanel;
    private JTextField urlLabel;
    private JButton copyToClipboard;
    private String hostName;

    public InvitationURLPanel(String hostName, boolean drawBorder) {
        this.initUI(drawBorder);
        this.hostName = hostName;
    }

    public static String getURL(String hostname, String invitationID) {
        if (!hostname.startsWith("http://") && !hostname.startsWith("https://")) {
            hostname = SHJWUtil.getUpdateURLProtocol() + "://" + hostname;
        }
        if (invitationID == null) {
            return hostname + "/customer";
        }
        return hostname + "/customer?invite=" + invitationID;
    }

    public void updateInviteURL(String invitationID) {
        this.setURL(InvitationURLPanel.getURL(this.hostName, invitationID));
    }

    private void initUI(boolean drawBorder) {
        JLabel desc = new JLabel(Language.get("INVITE_URL_LABEL") + " ");
        this.urlLabel = new JFixedWidthTextField();
        this.urlLabel.setEditable(false);
        this.copyToClipboard = new JButton(Language.get("COPY"));
        this.copyToClipboard.addActionListener(this);
        this.urlPanel = drawBorder ? new RoundBorderPanel() : new JPanel();
        this.urlPanel.setLayout(new GridLayout(1, 1));
        GbPanel contentPanel = new GbPanel();
        contentPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        contentPanel.add(desc, 0, 0, 1, 1, 1, 1, 13, 0);
        contentPanel.add(this.urlLabel, 1, 0, 1, 1, 100, 1, 17, 2);
        contentPanel.add(this.copyToClipboard, 2, 0, 1, 1, 1, 1, 13, 0);
        this.urlPanel.add(contentPanel);
    }

    public JPanel getRootComponent() {
        return this.urlPanel;
    }

    private void setURL(String url) {
        this.urlLabel.setText(url);
        this.urlLabel.setToolTipText(url);
    }

    public void setEnabled(boolean enabled) {
        this.urlPanel.setEnabled(enabled);
        this.urlLabel.setEnabled(enabled);
        this.copyToClipboard.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.copyToClipboard)) {
            String url = this.urlLabel.getText();
            ClipboardUtil.setClipboardAsText(url);
        }
    }
}

