/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.summarypanels;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class MachineSummaryPanel {
    private GbPanel machinePanel = new ColorPropagatingGBPanel(new ScaledInsets(2, 2, 2, 2)){};
    private MachineName machineName;
    private JPanel groupPanel;
    private JLabel hostname;
    private JLabel osValue;
    private JLabel tunnel;
    private JLabel groupLabel;

    public JComponent getRootComponent() {
        return this.machinePanel;
    }

    public MachineSummaryPanel() {
        this.initUI();
    }

    private void initUI() {
        this.machinePanel.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.hostname = new JLabel();
        this.tunnel = new JLabel();
        this.groupPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel hostnameLabel = new JLabel();
        hostnameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        hostnameLabel.setText(Language.get("HOSTNAME") + " ");
        this.groupLabel = new JLabel();
        this.groupLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.groupLabel.setText(Language.get("GROUP") + " ");
        JLabel osLabel = new JLabel();
        osLabel.setText(Language.get("OPERATING_SYSTEM") + " ");
        osLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        CompoundLabel compoundLabel = new CompoundLabel(this.hostname, this.tunnel);
        this.osValue = new JLabel();
        this.machinePanel.add(this.groupLabel, 0, 1, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add(this.groupPanel, 1, 1, 1, 1, 1, 0, 17, 2);
        this.machinePanel.add(hostnameLabel, 0, 0, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add(compoundLabel, 1, 0, 1, 1, 0, 0, 17, 2);
        this.machinePanel.add(osLabel, 0, 2, 1, 1, 0, 0, 13, 0);
        this.machinePanel.add(this.osValue, 1, 2, 1, 1, 1, 0, 17, 2);
    }

    public void initWith(Machine remoteMachine, AccessSession session) {
        MachineInfo info = remoteMachine.getMachineInfo();
        this.machineName = remoteMachine.getMachineName();
        String appTunnelPostfix = "";
        if (session.isAppTunnelSession()) {
            appTunnelPostfix = session.getAppTunnelSummaryString();
            this.tunnel.setText(" (" + Language.get("TUNNEL_TO") + " " + appTunnelPostfix + ")");
            this.tunnel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        }
        if (info != null && info.getHostname() != null && info.getHostname().length() > 0) {
            this.hostname.setText(info.getHostname());
        } else {
            this.hostname.setText("-");
        }
        this.osValue.setText(remoteMachine.getOsSummary());
        this.groupPanel.removeAll();
        boolean isInGroup = this.machineName.isInGroup();
        this.groupPanel.setVisible(isInGroup);
        this.groupLabel.setVisible(isInGroup);
        if (isInGroup) {
            Border border = SHBorderFactory.createEmptyBorder(0, 0, 0, 5);
            for (int i = 0; i < this.machineName.getGroup().length; ++i) {
                JLabel groupLabel = new JLabel(this.machineName.getGroup()[i]);
                groupLabel.setBorder(border);
                if (i > 0) {
                    groupLabel.setIcon(ImageLoader.getImageIcon("images/glyph/glyph_rightarrow.png"));
                }
                this.groupPanel.add(groupLabel);
            }
        }
    }

    public class CompoundLabel
    extends JPanel {
        public CompoundLabel(JLabel left, JLabel right) {
            this.setLayout(new BorderLayout());
            this.add((Component)left, "West");
            this.add((Component)right, "Center");
        }
    }
}

