/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.reports;

import com.aem.shelp.proxy.types.AbstractMachine;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.PresentationMachine;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.history.HistoryDataSource;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class SessionReport {
    private static DecimalFormat df1 = new DecimalFormat("#############0.#");
    private static SimpleDateFormat REPORT_FILENAME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");

    public static void generate(OutputStream out, HistoryDataSource source) {
        PrintStream pout = new PrintStream(out);
        pout.println("Session Type,Remote Entity,Group,Technician Username,Technician Name,Start Time,Duration (mins),OS");
        ArrayList<AbstractSession> list = source.getLoadedSessionData();
        int total = 0;
        do {
            for (AbstractSession session : list) {
                String type = "";
                if (session instanceof SupportSession) {
                    type = "Support";
                }
                if (session instanceof AccessSession) {
                    type = "Access";
                }
                if (session instanceof DemoSession) {
                    type = "Presentation";
                }
                String entity = "";
                String group = "";
                String os = "";
                AbstractMachine machine = session.getRemoteMachine();
                if (machine instanceof PresentationMachine) {
                    os = machine.getOsSummary();
                } else if (machine instanceof Machine) {
                    entity = ((Machine)machine).getMachineName().getName();
                    group = ((Machine)machine).getMachineName().getGroupString();
                    if (group == null) {
                        group = "";
                    }
                    os = machine.getOsSummary();
                } else if (machine instanceof Customer) {
                    entity = "" + machine;
                    os = machine.getOsSummary();
                }
                String techuser = session.getTechnicianUsername();
                String techdisplay = session.getTechnicianDisplayName();
                String startTime = REPORT_FILENAME.format(new Date(session.getStartTime()));
                double durationMins = session.getDuration();
                entity = entity != null ? entity.replaceAll(",", "") : "";
                group = group != null ? group.replaceAll(",", "") : "";
                os = os != null ? os.replaceAll(",", "") : "";
                pout.println(type + "," + entity + "," + group + "," + techuser + "," + techdisplay + "," + startTime + "," + df1.format(durationMins /= 60000.0) + "," + os);
            }
            System.out.println(list.size() + " sessions in this block, total " + (total += list.size()) + "...");
        } while ((list = source.getNextSessionDataBlock()) != null);
        System.out.println("No more sessions, total " + total);
    }
}

