/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.metrics;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.tech.history.metrics.SessionCountPanel;
import java.awt.Color;
import javax.swing.JPanel;
import utils.swing.MiniLineStatGraph;
import utils.swing.MiniStatGraphPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class MetricsHeader {
    public static final Color BLUE_LINE = new Color(100, 116, 200);
    public static final Color GREEN_LINE = new Color(70, 170, 60);
    public static final Color YELLOW_LINE = new Color(186, 160, 60);
    public static final Color BLUE_FILL = new Color(160, 180, 255);
    public static final Color GREEN_FILL = new Color(167, 239, 167);
    public static final Color YELLOW_FILL = new Color(230, 220, 120);
    private GbPanel rootComponent = new GbPanel();
    private MiniStatGraphPanel graphPanel = new MiniStatGraphPanel();
    private SessionCountPanel supportSessionPanel = new SessionCountPanel(Language.get("SUPPORT"));
    private SessionCountPanel accessSessionPanel = new SessionCountPanel(Language.get("ACCESS"));
    private SessionCountPanel presentationsSessionPanel = new SessionCountPanel(Language.get("PRESENTATIONS"));

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MetricsHeader() {
        this.rootComponent.add(this.graphPanel, 0, 0, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add(this.supportSessionPanel.getRootComponent(), 1, 0, 1, 1, 0, 1, 10, 1, new ScaledInsets(0, 10, 0, 0));
        this.rootComponent.add(this.accessSessionPanel.getRootComponent(), 2, 0, 1, 1, 0, 1, 10, 1, new ScaledInsets(0, 10, 0, 0));
        this.rootComponent.add(this.presentationsSessionPanel.getRootComponent(), 3, 0, 1, 1, 0, 1, 10, 1, new ScaledInsets(0, 10, 0, 0));
        int maxWidth = Math.max(this.supportSessionPanel.getWidth(), Math.max(this.accessSessionPanel.getWidth(), this.presentationsSessionPanel.getWidth()));
        this.supportSessionPanel.setColorForeground(BLUE_LINE);
        this.accessSessionPanel.setColorForeground(GREEN_LINE);
        this.presentationsSessionPanel.setColorForeground(YELLOW_LINE);
        this.supportSessionPanel.setWidth(maxWidth);
        this.accessSessionPanel.setWidth(maxWidth);
        this.presentationsSessionPanel.setWidth(maxWidth);
    }

    private double getMax(long[] data) {
        long max = 0L;
        for (long l : data) {
            max = Math.max(max, l);
        }
        return (double)max * 1.1;
    }

    private double[] asDoubleArray(long[] array) {
        double[] data = new double[array.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = array[i];
        }
        return data;
    }

    private long sum(long[] array) {
        long result = 0L;
        for (long l : array) {
            result += l;
        }
        return result;
    }

    public void initWith(HistoryMetrics metrics) {
        long[] supportSessionsStacked = metrics.getAllSupportSessionCounts();
        long[] accessSessionsStacked = metrics.getAllAccessSessionCounts();
        long[] presentationSessionsStacked = metrics.getAllPresentationSessionCounts();
        long[] supportSessions = metrics.getAllSupportSessionCounts();
        long[] accessSessions = metrics.getAllAccessSessionCounts();
        long[] presentationSessions = metrics.getAllPresentationSessionCounts();
        for (int i = 0; i < supportSessionsStacked.length; ++i) {
            int n = i;
            supportSessionsStacked[n] = supportSessionsStacked[n] + (accessSessionsStacked[i] + presentationSessionsStacked[i]);
            int n2 = i;
            accessSessionsStacked[n2] = accessSessionsStacked[n2] + presentationSessionsStacked[i];
        }
        double max = this.getMax(accessSessionsStacked);
        max = Math.max(max, this.getMax(supportSessionsStacked));
        max = Math.max(max, this.getMax(presentationSessionsStacked));
        this.graphPanel.addGraph(new MiniLineStatGraph(Color.WHITE, new Color[]{BLUE_FILL, BLUE_LINE}, max), this.asDoubleArray(metrics.getAllSupportSessionCounts()));
        this.graphPanel.addGraph(new MiniLineStatGraph(Color.WHITE, new Color[]{GREEN_FILL, GREEN_LINE}, max), this.asDoubleArray(metrics.getAllAccessSessionCounts()));
        this.graphPanel.addGraph(new MiniLineStatGraph(Color.WHITE, new Color[]{YELLOW_FILL, YELLOW_LINE}, max), this.asDoubleArray(metrics.getAllPresentationSessionCounts()));
        this.supportSessionPanel.initWith((int)this.sum(supportSessions), metrics.getTotalSupportDuration());
        this.accessSessionPanel.initWith((int)this.sum(accessSessions), metrics.getTotalAccessDuration());
        this.presentationsSessionPanel.initWith((int)this.sum(presentationSessions), metrics.getTotalPresentationDuration());
    }

    public void setBackground(Color c) {
        this.rootComponent.setBackground(c);
        this.graphPanel.setBackground(c);
    }
}

