/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.Insets;
import java.text.DateFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import utils.progtools.TimeUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;

public class TitlePanel
extends ColorPropagatingGBPanel {
    private JLabel osIconLabel = new JLabel();
    private JLabel title = new JWrapLabel();
    private DateFormat dateFormatter = DateFormat.getDateTimeInstance(1, 2);
    private ElapsedTimeFormatter timeFormatter = new ElapsedTimeFormatter();
    private JLabel typeLabel;
    private JLabel durationLabel;
    private JLabel dateLabel;

    public TitlePanel() {
        super(new Insets(3, 3, 3, 3));
        this.initUI();
        this.title.setFont(SHStyle.largeFont);
    }

    private void initUI() {
        this.title.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 3, 3));
        this.durationLabel = new JLabel();
        this.durationLabel.setHorizontalAlignment(4);
        this.durationLabel.setFont(SHStyle.smallerFont);
        this.durationLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.dateLabel = new JLabel();
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setFont(SHStyle.smallerFont);
        this.dateLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.typeLabel = new JLabel();
        this.typeLabel.setFont(SHStyle.smallerFont);
        this.typeLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        int Y = 0;
        this.add(this.osIconLabel, 0, Y, 1, 1, 0, 0, 11, 2);
        this.add(this.title, 1, Y, 1, 1, 1, 0, 11, 2);
        this.add(this.durationLabel, 2, Y++, 1, 1, 0, 0, 13, 0);
        this.add(this.typeLabel, 0, Y, 2, 1, 1, 0, 17, 2, new Insets(0, 3, 3, 3));
        this.add(this.dateLabel, 2, Y++, 1, 1, 0, 0, 13, 0, new Insets(0, 3, 3, 3));
    }

    private void initFor(AbstractSession session) {
        long duration = Math.max(session.getDuration(), 1000L);
        this.durationLabel.setText(this.timeFormatter.getCompleteFormattedTime(TimeUtil.stripMS(duration)));
        this.dateLabel.setText(this.dateFormatter.format(session.getStartTime()));
    }

    public void initFor(DemoSession session) {
        this.initFor((AbstractSession)session);
        Icon customerIcon = ImageLoader.getImageIcon("images/svg/general/bullhorn.svg,24");
        this.title.setText("<html>" + session.getName());
        this.osIconLabel.setIcon(customerIcon);
        this.typeLabel.setText(Language.get("HISTORY_SESSION_TYPE_DEMO"));
    }

    public void initFor(SupportSession session) {
        this.initFor((AbstractSession)session);
        Icon customerIcon = ImageLoader.getImageIcon("images/svg/general/help.svg,24");
        this.title.setText("<html>" + session.getCustomer().getUsefulHumanReadableName());
        this.osIconLabel.setIcon(customerIcon);
        this.typeLabel.setText(Language.get("HISTORY_SESSION_TYPE_SUPPORT"));
    }

    public void initFor(AccessSession session) {
        Machine machine = session.getMachine();
        MachineInfo info = machine.getMachineInfo();
        this.initFor((AbstractSession)session);
        Icon osIcon = OSIconLoader.getOSIcon(machine.getOsBaseType(), machine.getOsVariant(), machine.getOsSummary());
        this.title.setText("<html>" + machine.getMachineName().getName());
        this.osIconLabel.setIcon(osIcon);
        if (session.isAppTunnelSession()) {
            this.typeLabel.setText(Language.get("HISTORY_SESSION_TYPE_APP_TUNNEL"));
        } else {
            this.typeLabel.setText(Language.get("HISTORY_SESSION_TYPE_ACCESS"));
        }
        this.revalidate();
        this.repaint();
    }
}

