/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.history.TimelineModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class TimelineSlider {
    private JPanel rootComponent;
    private TimeSliderPanel sliderPanel;
    private JLabel rightLabel;
    private JLabel leftLabel;
    private int minDurationInMonths = 1;
    private TimelineModel model;
    private static final int BALL_HEIGHT = SimpleHelpLookAndFeel.scale(16);
    private static final int BALL_WIDTH = SimpleHelpLookAndFeel.scale(16);
    private static final int TRACK_HEIGHT = SimpleHelpLookAndFeel.scale(3);
    private SimpleDateFormat sdf = new SimpleDateFormat("MMM yyyy");

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public TimelineSlider(TimelineModel model) {
        this.initUI();
        this.setModel(model);
    }

    public TimelineSlider() {
        this.initUI();
    }

    public void setModel(TimelineModel model) {
        this.model = model;
        this.modelChanged();
    }

    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
        this.leftLabel.setEnabled(enabled);
        this.rightLabel.setEnabled(enabled);
        this.sliderPanel.setEnabled(enabled);
    }

    private void modelChanged() {
        if (!this.model.hasNoTimePeriods()) {
            String left = this.sdf.format(this.model.getStartTime()).replace(" ", "<BR>");
            String right = this.sdf.format(this.model.getEndTime()).replace(" ", "<BR>");
            this.leftLabel.setText("<html><center>" + left);
            this.rightLabel.setText("<html><center>" + right);
            this.setEnabled(true);
        } else {
            String label = Language.get("ALLTIME");
            this.leftLabel.setText("<html><center>" + label.replace(" ", "<BR>"));
            this.rightLabel.setText("<html><center>" + label.replace(" ", "<BR>"));
            this.setEnabled(false);
        }
    }

    public void setMinDurationInMonths(int minDurationInMonths) {
        this.minDurationInMonths = minDurationInMonths;
    }

    private void initUI() {
        this.rootComponent = new JPanel(new BorderLayout());
        this.sliderPanel = new TimeSliderPanel();
        this.leftLabel = new JLabel();
        this.rightLabel = new JLabel();
        this.leftLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, SimpleHelpLookAndFeel.scale(3)));
        this.rightLabel.setBorder(SHBorderFactory.createEmptyBorder(0, SimpleHelpLookAndFeel.scale(3), 0, 0));
        this.leftLabel.setFont(SHStyle.smallerFont);
        this.rightLabel.setFont(SHStyle.smallerFont);
        this.rootComponent.add((Component)this.leftLabel, "West");
        this.rootComponent.add((Component)this.rightLabel, "East");
        this.rootComponent.add((Component)this.sliderPanel, "Center");
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        TimelineModel model = new TimelineModel(System.currentTimeMillis() - 20736000000L, System.currentTimeMillis());
        TimelineSlider slider = new TimelineSlider(model);
        testFrame.getContentPane().add(slider.getRootComponent());
        testFrame.setVisible(true);
    }

    public TimelineModel getModel() {
        return this.model;
    }

    class TimeSliderPanel
    extends JComponent
    implements MouseMotionListener,
    MouseListener {
        private boolean draggingLeft = false;
        private boolean draggingRight = false;
        private boolean draggingMiddle = false;
        private int middleDragStartX;

        public TimeSliderPanel() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int leftBallX = this.getXForBallAtIndex(TimelineSlider.this.model.getLeftIndex());
            int rightBallX = this.getXForBallAtIndex(TimelineSlider.this.model.getRightIndex());
            float yTrack = (float)(this.getHeight() - TRACK_HEIGHT) / 2.0f + 1.0f;
            float yBall = (float)(this.getHeight() - BALL_HEIGHT) / 2.0f;
            g2d.setPaint(SHUI.BUTTON_NORMAL.getDisabledBorder());
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.draw(new Line2D.Float(0.0f, yTrack, leftBallX + BALL_WIDTH / 2, yTrack));
            g2d.draw(new Line2D.Float(rightBallX + BALL_WIDTH / 2, yTrack, this.getWidth(), yTrack));
            g2d.setColor(new Color(128, 168, 200));
            g2d.draw(new Line2D.Float(leftBallX + BALL_WIDTH / 2, yTrack, rightBallX + BALL_WIDTH / 2, yTrack));
            g2d.setStroke(oldStroke);
            Arc2D.Float leftBall = new Arc2D.Float(leftBallX, yBall, BALL_WIDTH - 1, BALL_HEIGHT - 1, 0.0f, 360.0f, 0);
            Arc2D.Float rightBall = new Arc2D.Float(rightBallX, yBall, BALL_WIDTH - 1, BALL_HEIGHT - 1, 0.0f, 360.0f, 0);
            g2d.setPaint(SHUI.BUTTON_BLUE.getGradient(this.isEnabled(), BALL_HEIGHT, false));
            g2d.fill(leftBall);
            g2d.fill(rightBall);
            g2d.setPaint(SHUI.BUTTON_BLUE.border);
            g2d.draw(leftBall);
            g2d.draw(rightBall);
            int middleX = leftBallX + (rightBallX - leftBallX) / 2;
            if (!TimelineSlider.this.model.hasNoTimePeriods()) {
                long leftDate = TimelineSlider.this.model.getDateFor(TimelineSlider.this.model.getLeftIndex());
                long rightDate = TimelineSlider.this.model.getDateFor(TimelineSlider.this.model.getRightIndex());
                String dateString = TimelineSlider.this.sdf.format(leftDate) + " - " + TimelineSlider.this.sdf.format(rightDate);
                if (this.isEnabled()) {
                    g2d.setColor(TimelineSlider.this.leftLabel.getForeground());
                } else {
                    g2d.setColor(UIManager.getColor("Label.disabledShadow"));
                }
                TextLayout tl = new TextLayout(dateString, SHStyle.smallerFont, g2d.getFontRenderContext());
                int textY = (int)(yTrack + (float)TRACK_HEIGHT + tl.getAscent()) + 6;
                float textX = (float)((double)middleX - tl.getBounds().getWidth() / 2.0);
                textX = Math.max(0.0f, textX);
                textX = (float)Math.min((double)this.getWidth() - tl.getBounds().getWidth() - 1.0, (double)textX);
                tl.draw(g2d, textX, textY);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.possibleDrag(e.getPoint());
        }

        private int getXForBallAtIndex(int index) {
            int componentWidth = this.getWidth() - BALL_WIDTH;
            int totalSteps = TimelineSlider.this.model.getDurationInMonths();
            float stepWidth = (float)componentWidth / (float)totalSteps;
            return (int)((float)index * stepWidth);
        }

        private void possibleDrag(Point point) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.draggingLeft || this.draggingRight) {
                int componentWidth = this.getWidth() - BALL_WIDTH;
                int x = Math.min(componentWidth, Math.max(0, point.x));
                int totalSteps = TimelineSlider.this.model.getDurationInMonths();
                float stepWidth = (float)componentWidth / (float)totalSteps;
                int leftStep = (int)((float)x / stepWidth);
                int rightStep = Math.min(leftStep + 1, totalSteps);
                int leftX = (int)((float)leftStep * stepWidth) + BALL_WIDTH / 2;
                int rightX = (int)((float)rightStep * stepWidth) + BALL_WIDTH / 2;
                int targetIndex = leftStep;
                targetIndex = x - leftX < rightX - x ? leftStep : rightStep;
                if (this.draggingLeft) {
                    if (targetIndex + TimelineSlider.this.minDurationInMonths <= TimelineSlider.this.model.getRightIndex()) {
                        TimelineSlider.this.model.setLeftIndex(targetIndex);
                    }
                } else if (targetIndex >= TimelineSlider.this.model.getLeftIndex() + TimelineSlider.this.minDurationInMonths) {
                    TimelineSlider.this.model.setRightIndex(targetIndex);
                }
                this.repaint();
            } else if (this.draggingMiddle) {
                int componentWidth = this.getWidth() - BALL_WIDTH;
                int x = Math.min(componentWidth, Math.max(0, point.x));
                int totalSteps = TimelineSlider.this.model.getDurationInMonths();
                float stepWidth = (float)componentWidth / (float)totalSteps;
                int diffX = x - this.middleDragStartX;
                int steps = (int)((float)diffX / stepWidth);
                int proposedLeftIndex = TimelineSlider.this.model.getLeftIndex() + steps;
                int proposedRightIndex = TimelineSlider.this.model.getRightIndex() + steps;
                if (proposedLeftIndex < 0) {
                    steps = -TimelineSlider.this.model.getLeftIndex();
                } else if (proposedRightIndex > TimelineSlider.this.model.getDurationInMonths()) {
                    steps = TimelineSlider.this.model.getDurationInMonths() - TimelineSlider.this.model.getRightIndex();
                }
                proposedLeftIndex = TimelineSlider.this.model.getLeftIndex() + steps;
                proposedRightIndex = TimelineSlider.this.model.getRightIndex() + steps;
                if (steps != 0) {
                    this.middleDragStartX = (int)((float)this.middleDragStartX + (float)steps * stepWidth);
                    TimelineSlider.this.model.setLeftIndex(proposedLeftIndex);
                    TimelineSlider.this.model.setRightIndex(proposedRightIndex);
                }
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.possibleDrag(e.getPoint());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.draggingLeft = this.ballIsClicked(e.getPoint(), true);
            if (!this.draggingLeft) {
                this.draggingRight = this.ballIsClicked(e.getPoint(), false);
            }
            if (!this.draggingRight) {
                this.draggingMiddle = this.middleIsClicked(e.getPoint());
                if (this.draggingMiddle) {
                    this.middleDragStartX = e.getPoint().x;
                }
            }
        }

        private boolean ballIsClicked(Point clickLocation, boolean left) {
            int ballY = this.getHeight() / 2;
            if (left) {
                return new Rectangle(this.getXForBallAtIndex(TimelineSlider.this.model.getLeftIndex()), ballY - BALL_HEIGHT / 2, BALL_WIDTH, BALL_HEIGHT).contains(clickLocation);
            }
            return new Rectangle(this.getXForBallAtIndex(TimelineSlider.this.model.getRightIndex()), ballY - BALL_HEIGHT / 2, BALL_WIDTH, BALL_HEIGHT).contains(clickLocation);
        }

        private boolean middleIsClicked(Point clickLocation) {
            int ballY = this.getHeight() / 2;
            int leftX = this.getXForBallAtIndex(TimelineSlider.this.model.getLeftIndex()) + BALL_HEIGHT / 2;
            int rightX = this.getXForBallAtIndex(TimelineSlider.this.model.getRightIndex()) - BALL_HEIGHT / 2;
            return new Rectangle(leftX, ballY - BALL_HEIGHT / 2, rightX - leftX, BALL_HEIGHT).contains(clickLocation);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.draggingMiddle = false;
            this.draggingRight = false;
            this.draggingLeft = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

