/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import utils.progtools.TimeUtil;

public class TimelineModel {
    private Date startTime;
    private Date endTime;
    private int noMonthsInDuration;
    private int leftIndex;
    private int rightIndex;
    private ArrayList listeners = new ArrayList();

    public static void main(String[] args) {
        TimelineModel model = new TimelineModel(System.currentTimeMillis() - 864000000L, System.currentTimeMillis());
        System.out.println(model.getLeftTime());
        System.out.println(model.getRightTime());
    }

    public TimelineModel(long start, long end) {
        this.setDuration(start, end);
        this.leftIndex = 0;
        this.rightIndex = this.noMonthsInDuration;
    }

    public void setDuration(long startTime, long endTime) {
        this.startTime = new Date(TimeUtil.roundTimeDownToStartOfMonth(startTime));
        this.endTime = new Date(TimeUtil.roundTimeUpToEndOfMonth(endTime));
        this.noMonthsInDuration = this.calculateDurationInMonths();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getLeftTime() {
        return this.getDateFor(this.getLeftIndex());
    }

    public long getRightTime() {
        if (this.getLeftIndex() == this.getRightIndex()) {
            return this.endTime.getTime();
        }
        return this.getDateFor(this.getRightIndex());
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public void setLeftIndex(int leftIndex) {
        this.leftIndex = leftIndex;
        this.notifyDurationChanged();
    }

    public void setRightIndex(int rightIndex) {
        this.rightIndex = rightIndex;
        this.notifyDurationChanged();
    }

    public long getDateFor(int monthIndex) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startTime);
        cal.add(2, monthIndex);
        return cal.getTimeInMillis();
    }

    public int getDurationInMonths() {
        return this.noMonthsInDuration;
    }

    private int calculateDurationInMonths() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.endTime);
        int endYear = cal.get(1);
        int endMonth = cal.get(2);
        cal.setTime(this.startTime);
        int startYear = cal.get(1);
        int startMonth = cal.get(2);
        return (endYear - startYear) * (cal.getMaximum(2) + 1) + (endMonth - startMonth);
    }

    public void addTimelineListener(TimelineListener listener) {
        this.listeners.add(listener);
    }

    public void notifyDurationChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimelineListener listener = (TimelineListener)this.listeners.get(i);
            listener.timelineChanged(this.getDateFor(this.leftIndex), this.getDateFor(this.rightIndex));
        }
    }

    public boolean hasNoTimePeriods() {
        return this.getLeftIndex() == this.getRightIndex();
    }

    public static interface TimelineListener {
        public void timelineChanged(long var1, long var3);
    }
}

