/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.video.VideoUtils;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.history.MultiSessionPanel;
import com.aem.shelp.tech.history.SessionUploader;
import com.aem.shelp.tech.history.TitlePanel;
import com.aem.shelp.tech.history.VideoPanel;
import com.aem.shelp.tech.history.summarypanels.CustomerSummaryPanel;
import com.aem.shelp.tech.history.summarypanels.DemoSummaryPanel;
import com.aem.shelp.tech.history.summarypanels.MachineSummaryPanel;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.shelp.tech.video.TechVideoRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import utils.progtools.OnDemandThreadPool;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class SessionPanel
implements ActionListener {
    private TechClient tc;
    private final JPanel buttonBar = new JPanel();
    private final JPanel viewsPanel = new JPanel();
    private final JToggleButton infoViewButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/dialogs/information-square.svg,16"));
    private final JToggleButton chatViewButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/chat/chat.svg,16"));
    private final JToggleButton commentsViewButton = new JToggleButton(ImageLoader.getImageIcon(Icons.HISTORY_COMMENTS));
    private final JToggleButton advancedButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/general/gear.svg,16"));
    private final JPanel rootComponent = new JPanel(new GridLayout(1, 1));
    private final JPanel containerSingle = new JPanel();
    private final SLPanel containerSliding = new SLPanel();
    private final GbPanel infoPanel = new GbPanel();
    private final StrippedContentPanel infoPanelWrapper = new StrippedContentPanel(this.infoPanel, false);
    private TitlePanel titlePanel;
    private JPanel summaryPanel;
    private CustomerSummaryPanel customerSummaryPanel;
    private MachineSummaryPanel machineSummaryPanel;
    private DemoSummaryPanel demoSummaryPanel;
    private JPanel videoSection;
    private VideoPanel videoPanel;
    private final GbPanel chatPanel = new GbPanel();
    private final JTextArea chatArea = new JTextArea();
    private final GbPanel commentsPanel = new GbPanel();
    private final JTextArea commentsArea = new JTextArea();
    private final JPanel advancedPanel = new JPanel();
    private MultiSessionPanel actionsPanel = new MultiSessionPanel();
    private MultiSessionPanel multiSessionPanel;
    private AbstractSession selectedSession;
    private AbstractSession[] selectedSessions;
    private OnDemandThreadPool serverQuerier = new OnDemandThreadPool("SessionPanelQuery", 5, 5, 5);
    private SLConfig contentConfig;
    private SLConfig chatConfig;
    private SLConfig commentsConfig;
    private SLConfig advancedConfig;
    private JScrollPane contentScroll;
    private JScrollPane advancedScroll;
    private final int mode_CONTENT = 0;
    private final int mode_CHAT = 1;
    private final int mode_COMMENTS = 2;
    private final int mode_ADVANCED = 3;
    float modeTime = 0.5f;
    private int modeCurrent = 0;
    private int modeAvailable = 0;
    static boolean first = true;

    private void setCoreComponent(JPanel newComponent) {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != newComponent) {
            this.rootComponent.removeAll();
            this.rootComponent.add(newComponent);
            this.rootComponent.revalidate();
        }
    }

    private void initSlidingConfigs() {
        this.contentScroll = new JScrollPane(this.infoPanel);
        this.contentScroll.setBorder(SHBorderFactory.createEmptyBorder());
        this.contentScroll.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.contentScroll.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.contentScroll.setHorizontalScrollBarPolicy(31);
        this.advancedScroll = new JScrollPane(this.advancedPanel);
        this.advancedScroll.setBorder(SHBorderFactory.createEmptyBorder());
        this.advancedScroll.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.advancedScroll.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.advancedScroll.setHorizontalScrollBarPolicy(31);
        this.contentConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.contentScroll);
        this.chatConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.chatPanel);
        this.commentsConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.commentsPanel);
        this.advancedConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.advancedScroll);
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.contentConfig);
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    private void switchToInfoView() {
        this.switchToNewView(this.contentConfig, 0, this.contentScroll);
    }

    private void switchToChatView() {
        this.switchToNewView(this.chatConfig, 1, this.chatPanel);
    }

    private void switchToCommentsView() {
        this.switchToNewView(this.commentsConfig, 2, this.commentsPanel);
    }

    private void switchToAdvancedView() {
        this.switchToNewView(this.advancedConfig, 3, this.advancedScroll);
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public SessionPanel() {
        this.initUI();
        this.serverQuerier.setDumpOldJobsOnBufferMaxed(true);
    }

    public void setTechClient(TechClient tc, SessionUploader uploader) {
        this.tc = tc;
        this.videoPanel.setTechClient(tc, uploader);
    }

    private void initButtonBar() {
        this.buttonBar.setLayout(new BorderLayout());
        this.buttonBar.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.DETAILS_CONTENT_BORDER));
        this.buttonBar.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.infoViewButton.setToolTipText(Language.get("ACCESS_INFO_TOOLTIP"));
        this.chatViewButton.setToolTipText(Language.get("ACCESS_FILES_TOOLTIP"));
        this.commentsViewButton.setToolTipText(Language.get("ACCESS_NOTES_TOOLTIP"));
        this.advancedButton.setToolTipText(Language.get("ACCESS_ADVANCED_TOOLTIP"));
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new AbstractButton[]{this.infoViewButton, this.chatViewButton, this.commentsViewButton, this.advancedButton});
        this.viewsPanel.setLayout(new GridLayout(1, 4));
        this.viewsPanel.add(this.infoViewButton);
        this.viewsPanel.add(this.chatViewButton);
        this.viewsPanel.add(this.commentsViewButton);
        this.viewsPanel.add(this.advancedButton);
        this.infoViewButton.setSelected(true);
        this.viewsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.infoViewButton);
        bg.add(this.chatViewButton);
        bg.add(this.commentsViewButton);
        bg.add(this.advancedButton);
        JPanel middlePanel = new JPanel(new FlowLayout());
        middlePanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        middlePanel.add(this.viewsPanel);
        JPanel smallButtonsPanel = new JPanel(new FlowLayout(2, 5, 0));
        smallButtonsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        smallButtonsPanel.setBorder(SHBorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.buttonBar.add((Component)middlePanel, "West");
        this.infoViewButton.addActionListener(this);
        this.chatViewButton.addActionListener(this);
        this.commentsViewButton.addActionListener(this);
        this.advancedButton.addActionListener(this);
    }

    private void initUI() {
        this.actionsPanel = new MultiSessionPanel();
        this.initButtonBar();
        this.containerSingle.setLayout(new BorderLayout());
        this.containerSingle.add("North", this.buttonBar);
        this.containerSingle.add("Center", this.containerSliding);
        this.containerSingle.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.containerSliding.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.initSlidingConfigs();
        this.titlePanel = new TitlePanel();
        this.summaryPanel = new ColorPropagatingPanel(new GridLayout(1, 1));
        ColorPropagatingPanel topBit = new ColorPropagatingPanel(new BorderLayout());
        topBit.add((Component)this.titlePanel, "North");
        topBit.add((Component)this.summaryPanel, "Center");
        StrippedContentPanel.TitledSection summarySection = this.infoPanelWrapper.addContent(topBit, null);
        this.videoPanel = new VideoPanel(this);
        this.videoSection = this.infoPanelWrapper.addContent(this.videoPanel, Language.get("HISTORY_SESSION_VIDEOS"));
        this.infoPanelWrapper.addVerticalFiller();
        this.infoPanelWrapper.setBackgroundColours();
        this.customerSummaryPanel = new CustomerSummaryPanel();
        this.machineSummaryPanel = new MachineSummaryPanel();
        this.demoSummaryPanel = new DemoSummaryPanel();
        this.multiSessionPanel = new MultiSessionPanel();
        this.chatArea.setEditable(false);
        this.chatArea.setLineWrap(true);
        JScrollPane chatScroll = new JScrollPane(this.chatArea);
        chatScroll.setBorder(SHBorderFactory.createEmptyBorder());
        chatScroll.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        chatScroll.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        JPanel titledChatSection = StrippedContentPanel.createTitledSection(chatScroll, Language.get("HISTORY_SESSION_CHAT"));
        this.chatPanel.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.chatPanel.setLayout(new GridLayout(1, 1));
        this.chatPanel.add(titledChatSection);
        this.commentsArea.setEditable(false);
        this.commentsArea.setLineWrap(true);
        chatScroll = new JScrollPane(this.commentsArea);
        chatScroll.setBorder(SHBorderFactory.createEmptyBorder());
        chatScroll.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        chatScroll.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        JPanel titledCommentsSection = StrippedContentPanel.createTitledSection(chatScroll, Language.get("HISTORY_SESSION_COMMENTS"));
        this.commentsPanel.setBorder(SHBorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.commentsPanel.setLayout(new GridLayout(1, 1));
        this.commentsPanel.add(titledCommentsSection);
        this.advancedPanel.setLayout(new GridLayout(1, 1));
        this.advancedPanel.add(this.actionsPanel);
    }

    public void setSelectedSessions(AbstractSession[] sessions) {
        this.setCoreComponent(this.containerSingle);
        this.selectedSessions = sessions;
        if (sessions == null) {
            return;
        }
        this.titlePanel.setVisible(false);
        this.summaryPanel.removeAll();
        this.multiSessionPanel.setSelectedSessions(sessions);
        this.summaryPanel.add(this.multiSessionPanel);
        this.infoPanelWrapper.setBackgroundColours();
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void setSelectedSession(AbstractSession session) {
        this.setCoreComponent(this.containerSingle);
        this.selectedSession = session;
        this.selectedSessions = null;
        if (session == null) {
            return;
        }
        this.titlePanel.setVisible(true);
        long duration = Math.max(1000L, session.getDuration());
        this.summaryPanel.removeAll();
        if (session instanceof SupportSession) {
            this.titlePanel.initFor((SupportSession)session);
            this.summaryPanel.add(this.customerSummaryPanel.getRootComponent());
            this.customerSummaryPanel.initWith((Customer)session.getRemoteMachine());
        } else if (session instanceof AccessSession) {
            this.summaryPanel.add(this.machineSummaryPanel.getRootComponent());
            this.titlePanel.initFor((AccessSession)session);
            this.machineSummaryPanel.initWith((Machine)session.getRemoteMachine(), (AccessSession)session);
        } else if (session instanceof DemoSession) {
            this.summaryPanel.add(this.demoSummaryPanel.getRootComponent());
            this.titlePanel.initFor((DemoSession)session);
            this.demoSummaryPanel.initWith((DemoSession)session);
        }
        int addIndex = 1;
        String chat = session.getPostSessionChat();
        if (chat != null && chat.length() > 0) {
            this.chatArea.setText(chat);
            if (!this.chatViewButton.isVisible()) {
                this.chatViewButton.setVisible(true);
                this.viewsPanel.add((Component)this.chatViewButton, addIndex);
            }
            ++addIndex;
        } else {
            this.chatArea.setText("");
            if (this.chatViewButton.isVisible()) {
                this.chatViewButton.setVisible(false);
                this.viewsPanel.remove(this.chatViewButton);
            }
        }
        String comments = session.getPostSessionComments();
        if (comments != null && comments.length() > 0) {
            this.commentsArea.setText(comments);
            if (!this.commentsViewButton.isVisible()) {
                this.commentsViewButton.setVisible(true);
                this.viewsPanel.add((Component)this.commentsViewButton, addIndex);
            }
        } else {
            this.commentsArea.setText("");
            if (this.commentsViewButton.isVisible()) {
                this.commentsViewButton.setVisible(false);
                this.viewsPanel.remove(this.commentsViewButton);
            }
        }
        this.viewsPanel.revalidate();
        this.viewsPanel.repaint();
        File videoFile = TechVideoRepository.getVideoFileFor(session);
        if (!videoFile.exists() && session.getSessionID().equals("DUMMY_SESSION")) {
            try {
                FileOutputStream fout = new FileOutputStream(videoFile);
                Random r = new Random();
                byte[] data = new byte[50000];
                r.nextBytes(data);
                for (int i = 0; i < 10; ++i) {
                    fout.write(data);
                }
                fout.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        boolean hasLocalVideo = videoFile.exists();
        long videoDuration = 0L;
        try {
            if (hasLocalVideo) {
                videoDuration = VideoUtils.getVideoDuration(videoFile);
            }
        }
        catch (Throwable ex) {
            if (session.getSessionID().equals("DUMMY_SESSION")) {
                videoDuration = 100000L;
            }
            ex.printStackTrace();
            hasLocalVideo = false;
        }
        if (hasLocalVideo) {
            this.videoPanel.setVideoDetails(VideoUtils.getTotalSize(videoFile), videoDuration);
            this.videoSection.setVisible(true);
        } else {
            this.videoSection.setVisible(false);
        }
        this.queryServer(hasLocalVideo);
        this.infoPanelWrapper.setBackgroundColours();
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.infoViewButton) {
            this.switchToInfoView();
        } else if (e.getSource() == this.chatViewButton) {
            this.switchToChatView();
        } else if (e.getSource() == this.commentsViewButton) {
            this.switchToCommentsView();
        } else if (e.getSource() == this.advancedButton) {
            this.switchToAdvancedView();
        }
    }

    public AbstractSession getSelectedSession() {
        return this.selectedSession;
    }

    public void queryServer(boolean hasLocalVideo) {
        this.serverQuerier.runAsync(new ServerQueryRunner(hasLocalVideo));
    }

    public void setVideoSectionVisible(boolean videoSectionVisible) {
        this.videoSection.setVisible(videoSectionVisible);
        this.infoPanelWrapper.setBackgroundColours();
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        SessionPanel sp = new SessionPanel();
        frame.getContentPane().add(sp.getRootComponent());
        frame.setVisible(true);
        SupportSession createTestSession = SupportSession.createTestSession();
        createTestSession.setSessionID("DUMMY_SESSION");
        sp.setSelectedSession(createTestSession);
    }

    class ServerQueryRunner
    implements Runnable {
        private boolean die;
        private boolean isLocal;

        public ServerQueryRunner(boolean isLocal) {
            this.isLocal = isLocal;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            TechClient.VideoDetails selectedSessionVideoDetails = null;
            AbstractSession session = SessionPanel.this.selectedSession;
            try {
                if (SessionPanel.this.tc != null) {
                    selectedSessionVideoDetails = SessionPanel.this.tc.getVideoDetailsForSession(session);
                } else if (session.getSessionID().equals("DUMMY_SESSION")) {
                    TechClient.VideoDetails dummyDetails = new TechClient.VideoDetails();
                    dummyDetails.duration = 900000L;
                    if (first) {
                        first = false;
                        dummyDetails.existsOnServer = false;
                    } else {
                        dummyDetails.existsOnServer = true;
                    }
                    dummyDetails.htmlExistsOnServer = false;
                    dummyDetails.lengthInBytes = 123123123L;
                    dummyDetails.videoID = "DUMMY_ID";
                    dummyDetails.passwordUTF8 = new String("Test!").getBytes("UTF8");
                    selectedSessionVideoDetails = dummyDetails;
                }
            }
            catch (Exception e) {
                selectedSessionVideoDetails = null;
                e.printStackTrace();
            }
            if (this.die) {
                return;
            }
            if (session == SessionPanel.this.selectedSession) {
                SessionPanel.this.videoPanel.loadSelectedSessionVideo(selectedSessionVideoDetails, this.isLocal);
            }
        }
    }
}

