/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.history.HistoryListener;
import com.aem.shelp.util.EasyDateTimeFormatter;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import utils.progtools.OnDemandThreadPool;
import utils.swing.SwingUtil;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.truncatedarea.TruncatedTextArea;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class HistorySubPanel
implements HistoryListener,
MouseListener {
    private final AccessPanelListener accessPanelListener;
    private NoContentsInfoPanel rootComponent;
    private JScrollPane pane;
    private GbPanel contentsPanel = new GbPanel();
    private TechClient techClient;
    private String technicianUsernameFilter;
    private int[] technicianGroupFilters;
    private LockableViewPort viewPort;
    private HistoryListRenderer selectedSession = null;
    private OnDemandThreadPool threadPool = new OnDemandThreadPool("HistoryDetailsPanel", 2, 0, 5);

    public HistorySubPanel(AccessPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    private void initUI() {
        this.rootComponent = new NoContentsInfoPanel(Language.get("LOADING") + "...", null, false);
        this.pane = new JScrollPane();
        this.viewPort = new LockableViewPort();
        this.viewPort.setView(this.contentsPanel);
        this.pane.setViewport(this.viewPort);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.rootComponent.setContentsPanel(this.pane);
        this.rootComponent.setTitle(Language.get("ACCESS_HISTORY_NONE"));
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
        techClient.addHistoryListener(this);
        if (techClient.getTechUser().isServerAdmin()) {
            this.technicianUsernameFilter = null;
            this.technicianGroupFilters = null;
        } else {
            this.technicianUsernameFilter = techClient.getTechUser().username;
            this.technicianGroupFilters = techClient.getTechUser().loggedInGroupIDs;
        }
    }

    @Override
    public void searchResults(final ArrayList<AbstractSession> results, boolean isFinished) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HistorySubPanel.this.contentsPanel.getComponentCount() + results.size() == 0) {
                    HistorySubPanel.this.rootComponent.setHasContents(false);
                } else {
                    HistorySubPanel.this.rootComponent.setHasContents(true);
                }
                for (AbstractSession session : results) {
                    HistoryListRenderer renderer = new HistoryListRenderer();
                    renderer.setSize(HistorySubPanel.this.contentsPanel.getWidth(), -1);
                    renderer.doLayout();
                    renderer.initFor(session, HistorySubPanel.this.contentsPanel.getComponentCount());
                    HistorySubPanel.this.contentsPanel.add(renderer, 0, HistorySubPanel.this.contentsPanel.getComponentCount(), 1, 1, 1, 0, 10, 1);
                }
                HistorySubPanel.this.contentsPanel.add(new JPanel(), 0, HistorySubPanel.this.contentsPanel.getComponentCount(), 1, 1, 1, 1000, 10, 1);
                HistorySubPanel.this.contentsPanel.revalidate();
                HistorySubPanel.this.contentsPanel.repaint();
            }
        });
    }

    @Override
    public void metricResults(HistoryMetrics metrics) {
    }

    @Override
    public byte getHistoryID() {
        return 1;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void showMachineSessions(final String machineID) throws Exception {
        final long oldestTime = this.techClient.getOldestHistoricalSession();
        this.threadPool.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    HistorySubPanel.this.contentsPanel.removeAll();
                    HistorySubPanel.this.rootComponent.setHasContents(false);
                    SearchConfig config = new SearchConfig();
                    config.setStartTime(oldestTime);
                    config.setEndTime(System.currentTimeMillis());
                    config.setMachineIDs(new String[]{machineID});
                    config.setMaxReturnedResults(50);
                    HistorySubPanel.this.techClient.requestNewHistorySearch(HistorySubPanel.this.getHistoryID(), config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 2) {
            // empty if block
        }
    }

    private final class LockableViewPort
    extends JViewport {
        private boolean locked = false;

        private LockableViewPort() {
        }

        @Override
        public void setViewPosition(Point p) {
            if (this.locked) {
                return;
            }
            super.setViewPosition(p);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }
    }

    class MorePanel
    extends JPanel {
        private int blobSize = SimpleHelpLookAndFeel.scale(5);
        private boolean drawCircles;

        public MorePanel(int height) {
            SwingUtil.setHeight(this, height);
        }

        public void drawCircles(boolean drawCircles) {
            this.drawCircles = drawCircles;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.drawCircles) {
                int width = this.getWidth();
                int height = this.getHeight();
                g.setColor(this.getForeground());
                g.fillArc((width - this.blobSize) / 2, (height - this.blobSize) / 2, this.blobSize, this.blobSize, 0, 360);
            }
        }
    }

    class HistoryListRenderer
    extends GbPanel
    implements MouseListener {
        private JLabel dateLabel;
        private JLabel durationLabel;
        private JLabel technicianLabel;
        private JPanel commentsPanel;
        private JPanel iconPanel;
        private TruncatedTextArea commentsArea;
        private JLabel recordingLabel;
        private JLabel chatLabel;
        private EasyDateTimeFormatter dateTimeFormatter = new EasyDateTimeFormatter();
        private ElapsedTimeFormatter elapsedTimeFormatter = new ElapsedTimeFormatter();
        private JPanel title;
        private JPanel technicianIconPanel;
        private Color background;
        private Color backgroundSelected;
        private Color backgroundDarker;
        private Color foreground;
        private Color foregroundSelected;
        private MorePanel morePanel;
        private int twoLineTextAreaHeight;
        private boolean isSelectedSession;
        private int index;
        private AbstractSession session;
        Dimension cachedSize;

        public HistoryListRenderer() {
            this.initRendererUI();
        }

        private void initRendererUI() {
            int outerPadding = 10;
            int innerPadding = 5;
            this.dateLabel = new JLabel();
            this.durationLabel = new JLabel();
            this.technicianLabel = new JLabel();
            this.recordingLabel = new JLabel(ImageLoader.getImageIcon("images/svg/av/record.svg,16"));
            this.chatLabel = new JLabel(ImageLoader.getImageIcon("images/svg/chat/chat.svg,16"));
            this.iconPanel = new JPanel(new FlowLayout());
            this.iconPanel.add(this.recordingLabel);
            this.iconPanel.add(this.chatLabel);
            this.durationLabel.setHorizontalAlignment(4);
            this.commentsArea = new TruncatedTextArea(2){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    if (!HistoryListRenderer.this.isSelectedSession) {
                        d.height = Math.min(d.height, HistoryListRenderer.this.twoLineTextAreaHeight);
                    }
                    d.width = 0;
                    return d;
                }

                @Override
                public Dimension getMaximumSize() {
                    Dimension d = super.getMaximumSize();
                    if (!HistoryListRenderer.this.isSelectedSession) {
                        d.height = HistoryListRenderer.this.twoLineTextAreaHeight;
                    }
                    d.width = 0;
                    return d;
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension d = super.getMinimumSize();
                    d.width = 0;
                    d.height = 0;
                    return d;
                }
            };
            DefaultCaret caret = (DefaultCaret)this.commentsArea.getCaret();
            caret.setUpdatePolicy(1);
            this.commentsArea.setLineWrap(true);
            this.commentsArea.setEditable(false);
            this.commentsPanel = new JPanel(new GridLayout(1, 1));
            this.commentsPanel.add(this.commentsArea);
            SwingUtil.setWidth(this.dateLabel, SimpleHelpLookAndFeel.scale(100));
            SwingUtil.setWidth(this.durationLabel, SimpleHelpLookAndFeel.scale(80));
            this.dateLabel.setFont(SHStyle.smallerFont);
            this.durationLabel.setFont(SHStyle.smallerFont);
            this.technicianIconPanel = new JPanel(new BorderLayout());
            this.technicianIconPanel.add((Component)this.technicianLabel, "Center");
            this.technicianIconPanel.add((Component)this.iconPanel, "East");
            this.title = new JPanel(new BorderLayout());
            this.title.add((Component)this.dateLabel, "West");
            this.title.add((Component)this.technicianIconPanel, "Center");
            this.title.add((Component)this.durationLabel, "East");
            this.morePanel = new MorePanel(outerPadding);
            this.add(this.title, 0, 0, 1, 1, 1, 0, 10, 2);
            this.add(this.commentsPanel, 0, 1, 1, 1, 0, 1, 10, 1);
            this.add(this.morePanel, 0, 2, 1, 1, 1, 0, 10, 2);
            this.title.setBorder(SHBorderFactory.createEmptyBorder(outerPadding, outerPadding, 0, outerPadding));
            this.technicianLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 2 * innerPadding, 0, innerPadding));
            this.commentsPanel.setBorder(SHBorderFactory.createEmptyBorder(innerPadding, outerPadding, 0, outerPadding));
            this.background = UIManager.getColor("List.background");
            this.backgroundSelected = UIManager.getColor("List.selectionBackground");
            this.backgroundDarker = SHStyle.PANEL_BACKGROUND_MEDIUM;
            this.foreground = UIManager.getColor("List.foreground");
            this.foregroundSelected = UIManager.getColor("List.selectionForeground");
            JTextArea area = new JTextArea();
            area.setSize(1000, 100);
            area.setText("1y\n1y");
            this.twoLineTextAreaHeight = area.getPreferredSize().height - 1;
            this.addMouseListener(this);
            this.commentsArea.addMouseListener(this);
        }

        private void initFor(AbstractSession session, int index) {
            this.session = session;
            this.index = index;
            this.dateLabel.setText(this.dateTimeFormatter.formatDateTime(session.getStartTime()));
            this.durationLabel.setText(this.elapsedTimeFormatter.getFormattedTime(session.getDuration()));
            this.technicianLabel.setText(session.getTechnicianDisplayName());
            if (session.isAppTunnelSession()) {
                this.technicianLabel.setIcon(ImageLoader.getImageIcon("images/svg/computing/app-connection.svg,16"));
            } else if (session.isMobile()) {
                this.technicianLabel.setIcon(ImageLoader.getImageIcon("images/svg/computing/tablet.svg,16"));
            } else if (session instanceof AccessSession && ((AccessSession)session).isTerminalSession()) {
                this.technicianLabel.setIcon(ImageLoader.getImageIcon("images/svg/computing/terminal.svg,16"));
            } else {
                this.technicianLabel.setIcon(ImageLoader.getImageIcon("images/svg/technology/screen.svg,16"));
            }
            this.morePanel.drawCircles(false);
            if (session.hasComments()) {
                this.commentsArea.setText(session.getPostSessionComments());
                this.commentsPanel.setVisible(true);
            } else {
                this.commentsPanel.setVisible(false);
            }
            this.recordingLabel.setVisible(session.hasSessionRecording());
            this.chatLabel.setVisible(session.hasChat());
            this.updateColours();
        }

        private void updateColours() {
            Color fg = this.foreground;
            Color bg = this.background;
            if (this.isSelectedSession) {
                fg = this.foregroundSelected;
                bg = this.backgroundSelected;
            } else if (this.index % 2 == 1) {
                bg = this.backgroundDarker;
            }
            this.setBackground(bg);
            this.title.setBackground(bg);
            this.technicianIconPanel.setBackground(bg);
            this.iconPanel.setBackground(bg);
            this.commentsArea.setBackground(bg);
            this.commentsPanel.setBackground(bg);
            this.morePanel.setBackground(bg);
            if (this.isSelectedSession) {
                this.dateLabel.setForeground(fg);
                this.durationLabel.setForeground(fg);
            } else {
                this.dateLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                this.durationLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            }
            this.technicianLabel.setForeground(fg);
            this.commentsArea.setForeground(fg);
            this.commentsPanel.setForeground(fg);
            if (this.isSelectedSession) {
                this.morePanel.setForeground(fg);
            } else {
                this.morePanel.setForeground(new Color(140, 140, 140));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (HistorySubPanel.this.selectedSession != null) {
                ((HistorySubPanel)HistorySubPanel.this).selectedSession.isSelectedSession = false;
                ((HistorySubPanel)HistorySubPanel.this).selectedSession.commentsArea.setLineLimit(2);
                HistorySubPanel.this.selectedSession.minimise();
                HistorySubPanel.this.selectedSession.updateColours();
            }
            HistorySubPanel.this.selectedSession = this;
            this.isSelectedSession = !this.isSelectedSession;
            this.commentsArea.setLineLimit(200);
            this.maximise();
            this.updateColours();
            HistorySubPanel.this.contentsPanel.revalidate();
            HistorySubPanel.this.contentsPanel.repaint();
        }

        private void minimise() {
            this.commentsArea.setSize(this.cachedSize);
        }

        private void maximise() {
            this.cachedSize = this.getSize();
            this.commentsArea.setSize(this.commentsArea.getPreferredSize());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

