/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.techclient.TechClientSource;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.history.TimelineModel;
import com.aem.shelp.tech.history.TimelineSlider;
import com.aem.shelp.tech.history.metrics.MetricsHeader;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import com.aem.shelp.tech.utils.MachinesPickerPanel;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.shelp.tech.utils.TechnicianPickerPanel;
import com.aem.shelp.util.ErrorDialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import utils.ostools.OSDirs;
import utils.progtools.SaverUtil;
import utils.progtools.StackTracer;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.FixedSizePanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.components.JWrapLabel;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class HistorySearchPanel
implements ActionListener,
TimelineModel.TimelineListener,
MessageFieldHandler.FilterListener,
SaverUtil.SaveListener {
    private final HistoryFilterChangeListener listener;
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private JToggleButton searchButton;
    private JToggleButton metricsButton;
    private JButton addFilterButton;
    private JButton reportButton;
    private MetricsHeader metricsHeader;
    private GbPanel filtersPanel;
    private ColorPropagatingGBPanel typeFilter;
    private JCheckBox supportBox;
    private JCheckBox accessBox;
    private JCheckBox presentationBox;
    private ColorPropagatingGBPanel textFilter;
    private JSearchTextField messageTextField;
    private ColorPropagatingGBPanel technicianFilter;
    private TechnicianPickerPanel technicianPickerPanel;
    private ColorPropagatingGBPanel machineFilter;
    private MachinesPickerPanel machinesPickerPanel;
    private ColorPropagatingGBPanel timePanel;
    private TimelineSlider slider;
    private JPanel centrePanel;
    private SaverUtil changeNotifier = new SaverUtil("HistorySearchPanel", 500, this, false);
    TechClientSource tcsource;
    private static DecimalFormat df1 = new DecimalFormat("#############0.#");
    private static SimpleDateFormat REPORT_FILENAME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    static String lastSaveLocation = OSDirs.getDesktopDir().getAbsolutePath();

    public HistorySearchPanel(HistoryFilterChangeListener listener, TechClientSource tcsource) {
        this.listener = listener;
        this.tcsource = tcsource;
        this.initUI();
    }

    public SearchConfig getSearchConfig() {
        SearchConfig config = new SearchConfig();
        config.setStartTime(this.slider.getModel().getLeftTime());
        config.setEndTime(this.slider.getModel().getRightTime());
        if (this.textFilter.isVisible()) {
            config.setTextFilter(this.messageTextField.getText());
        }
        if (this.machineFilter.isVisible()) {
            config.setMachineIDs(this.machinesPickerPanel.getSelectedMachinesIDs());
        }
        if (this.technicianFilter.isVisible()) {
            config.setTechnicianGroups(this.technicianPickerPanel.getSelectedGroupIDs());
            config.setTechnicianNameFilters(this.technicianPickerPanel.getSelectedTechnicianNames());
        }
        if (this.typeFilter.isVisible()) {
            config.setSessionTypes(this.supportBox.isSelected(), this.accessBox.isSelected(), this.presentationBox.isSelected());
        }
        return config;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.machinesPickerPanel.setMachineTreeModel(model);
    }

    public void initUI() {
        this.rootComponent.setBorder(SHStyle.BUTTON_BAR_BORDER);
        ColorPropagatingPanel leftPanel = new ColorPropagatingPanel(new BorderLayout());
        JPanel leftButtonsPanel = new JPanel(new GridLayout(1, 2));
        this.searchButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,28"));
        this.metricsButton = new JToggleButton(ImageLoader.getImageIcon("images/svg/charts/chart-bars.svg,28"));
        SHButtonUI.makeButtonSegmentedLeft(this.searchButton);
        SHButtonUI.makeButtonSegmentedRight(this.metricsButton);
        this.searchButton.addActionListener(this);
        this.metricsButton.addActionListener(this);
        this.searchButton.setSelected(true);
        leftButtonsPanel.add(this.searchButton);
        leftButtonsPanel.add(this.metricsButton);
        leftPanel.add((Component)leftButtonsPanel, "North");
        this.centrePanel = new ColorPropagatingPanel(new GridLayout(1, 1));
        this.filtersPanel = new ColorPropagatingGBPanel();
        this.timePanel = new ColorPropagatingGBPanel();
        this.timePanel.setBorder(SHBorderFactory.createEmptyBorder(0, 8, 0, 8));
        TimelineModel model = new TimelineModel(System.currentTimeMillis() - 77760000000L, System.currentTimeMillis());
        this.slider = new TimelineSlider(model);
        model.addTimelineListener(this);
        this.timePanel.add(this.slider.getRootComponent(), 0, 0, 1, 1, 1, 1, 11, 1);
        SwingUtil.setHeight(this.timePanel, this.searchButton.getPreferredSize().height);
        this.machineFilter = new ColorPropagatingGBPanel();
        this.machineFilter.setBorder(SHBorderFactory.createEmptyBorder(5, 8, 0, 5));
        this.machinesPickerPanel = new MachinesPickerPanel(true, "", Language.get("HISTORY_FILTER_MACHINES_NONE"), this);
        this.machinesPickerPanel.setTitleIcon(ImageLoader.getImageIconLighter("images/svg/technology/screen.svg,16"));
        this.machineFilter.add(this.machinesPickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.machineFilter.setVisible(false);
        this.technicianFilter = new ColorPropagatingGBPanel();
        this.technicianFilter.setBorder(SHBorderFactory.createEmptyBorder(5, 8, 0, 5));
        this.technicianPickerPanel = new TechnicianPickerPanel(true, Language.get("HISTORY_FILTER_TECHNICIAN2"), Language.get("NOTIFY_TECH_NONE"), this);
        this.technicianPickerPanel.setTitleIcon(ImageLoader.getImageIconLighter("images/svg/users/technician.svg,16"));
        this.technicianFilter.add(this.technicianPickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.technicianFilter.setVisible(false);
        int buttonWidth = Math.max(this.machinesPickerPanel.getButtonWidth(), this.technicianPickerPanel.getButtonWidth());
        this.machinesPickerPanel.setButtonWidth(buttonWidth);
        this.technicianPickerPanel.setButtonWidth(buttonWidth);
        this.textFilter = new ColorPropagatingGBPanel();
        this.textFilter.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.messageTextField = new JSearchTextField(Language.get("FILTER") + "...");
        this.messageTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.messageTextField.setFilterListener(this);
        this.textFilter.add(this.messageTextField, 0, 0, 1, 1, 1, 1, 10, 1);
        this.textFilter.setVisible(false);
        this.typeFilter = new ColorPropagatingGBPanel();
        this.typeFilter.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.supportBox = new JCheckBox(Language.get("SUPPORTSESSION"));
        this.supportBox.setIconTextGap(SimpleHelpLookAndFeel.scale(10));
        this.accessBox = new JCheckBox(Language.get("ACCESSSESSION"));
        this.accessBox.setIconTextGap(SimpleHelpLookAndFeel.scale(10));
        this.presentationBox = new JCheckBox(Language.get("PRESENTATIONSESSION"));
        this.presentationBox.setIconTextGap(SimpleHelpLookAndFeel.scale(10));
        this.supportBox.setSelected(true);
        this.accessBox.setSelected(true);
        this.presentationBox.setSelected(true);
        this.typeFilter.add(this.supportBox, 0, 0, 1, 1, 1, 1, 17, 1);
        this.typeFilter.add(this.accessBox, 1, 0, 1, 1, 1, 1, 17, 1);
        this.typeFilter.add(this.presentationBox, 2, 0, 1, 1, 1, 1, 17, 1);
        this.supportBox.addActionListener(this);
        this.accessBox.addActionListener(this);
        this.presentationBox.addActionListener(this);
        this.typeFilter.setVisible(false);
        SwingUtil.setSizesToTallest(new JComponent[]{this.typeFilter, this.textFilter, this.technicianFilter, this.machineFilter});
        int Y = 0;
        this.filtersPanel.add(this.timePanel, 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add(this.typeFilter, 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add(this.machineFilter, 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add(this.technicianFilter, 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add(this.textFilter, 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add(new FixedSizePanel(0, 0), 0, Y++, 0, 1, 1, 1, 10, 1);
        this.metricsHeader = new MetricsHeader();
        this.metricsHeader.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder(0, 5, 0, 5));
        SwingUtil.setHeight(this.metricsHeader.getRootComponent(), SimpleHelpLookAndFeel.scale(100));
        this.centrePanel.add(this.filtersPanel);
        ColorPropagatingPanel rightPanel = new ColorPropagatingPanel(new BorderLayout());
        JPanel rightButtonsPanel = new JPanel(new GridLayout(1, 2));
        this.addFilterButton = new JButton(ImageLoader.getImageIcon("images/svg/general/funnel.svg,28"));
        this.reportButton = new JButton(ImageLoader.getImageIcon("images/svg/arrows/share.svg,28"));
        SHButtonUI.makeButtonSegmentedLeft(this.addFilterButton);
        SHButtonUI.makeButtonSegmentedRight(this.reportButton);
        this.addFilterButton.addActionListener(this);
        this.reportButton.addActionListener(this);
        rightButtonsPanel.add(this.addFilterButton);
        rightButtonsPanel.add(this.reportButton);
        rightPanel.add((Component)rightButtonsPanel, "North");
        this.rootComponent.add(leftPanel, 0, 0, 1, 1, 0, 1, 10, 1);
        this.rootComponent.add(this.centrePanel, 1, 0, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add(rightPanel, 2, 0, 1, 1, 0, 1, 10, 1);
        this.rootComponent.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.metricsHeader.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.switchToSearchButton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            this.changeNotifier.queueSave();
        } else if (e.getSource() == this.searchButton) {
            this.switchToSearchButton();
        } else if (e.getSource() == this.metricsButton) {
            this.switchToMetricsButton();
        } else if (e.getSource() == this.addFilterButton) {
            this.configureFilters();
        } else if (e.getSource() == this.reportButton) {
            new Thread(){

                @Override
                public void run() {
                    HistorySearchPanel.this.showHistoryPanelReportDialog(SwingUtil.getRootPaneContainer(HistorySearchPanel.this.rootComponent));
                }
            }.start();
        } else {
            this.changeNotifier.queueSave();
        }
    }

    private void configureFilters() {
        FilterListPanel filterListPanel = new FilterListPanel(this.machineFilter.isVisible(), this.technicianFilter.isVisible(), this.textFilter.isVisible(), this.typeFilter.isVisible());
        JSmartPopupMenu menu = new JSmartPopupMenu();
        menu.setBackground(Color.white);
        menu.add(filterListPanel);
        menu.show(this.addFilterButton, this.addFilterButton.getPreferredSize().width - filterListPanel.getPreferredSize().width - 1, this.addFilterButton.getPreferredSize().height + 1);
    }

    private void switchToMetricsButton() {
        this.centrePanel.removeAll();
        this.centrePanel.add(this.metricsHeader.getRootComponent());
        this.centrePanel.revalidate();
        this.centrePanel.repaint();
        this.searchButton.setSelected(false);
        this.metricsButton.setSelected(true);
    }

    private void switchToSearchButton() {
        this.centrePanel.removeAll();
        this.centrePanel.add(this.filtersPanel);
        this.centrePanel.revalidate();
        this.centrePanel.repaint();
        this.searchButton.setSelected(true);
        this.metricsButton.setSelected(false);
    }

    @Override
    public void timelineChanged(long startTime, long endTime) {
        this.changeNotifier.queueSave();
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void setFilter(String filter, boolean immediately) {
        this.changeNotifier.queueSave();
    }

    @Override
    public void performSave() {
        this.listener.historyFilterChanged();
    }

    public void setMetrics(HistoryMetrics metrics) {
        this.metricsHeader.initWith(metrics);
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        MachineTreeModel model = new MachineTreeModel();
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (int i = 0; i < 10000; ++i) {
            machines.add(Machine.createTestMachine());
        }
        model.addElements(machines.toArray(new Machine[0]));
        HistorySearchPanel searchPanel = new HistorySearchPanel(new HistoryFilterChangeListener(){

            @Override
            public void historyFilterChanged() {
                System.out.println("HISTORY CHANGED");
            }
        }, null);
        searchPanel.setMachineTreeModel(model);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)searchPanel.getRootComponent(), "North");
        frame.getContentPane().add(panel);
        frame.setVisible(true);
    }

    public void showHistoryPanelReportDialog(RootPaneContainer rpc) {
        HistoryPanelReportDialog requestDialog = new HistoryPanelReportDialog();
        requestDialog.showDialog(rpc);
        if (requestDialog.isOK()) {
            ReportRequest config = new ReportRequest();
            SearchConfig search = this.getSearchConfig();
            search.roundStartAndEndTimesToStartAndEndOfMonth();
            search.setDescendingOrder();
            config.reportOnHistory(search);
            config.notify = requestDialog.notifyWhenDone.isSelected();
            if (requestDialog.sessionReport.isSelected()) {
                config.reportType = 2;
            } else if (requestDialog.techniciansReport.isSelected()) {
                config.reportType = 3;
                if (requestDialog.type.getSelectedIndex() == 1) {
                    config.setPDF();
                }
            }
            File targetDir = new File(requestDialog.reportSaveDirectory.getText());
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            File reportFile = new File(targetDir, config.getReportFileName(0));
            try {
                int count = 1;
                while (reportFile.exists()) {
                    reportFile = new File(targetDir, config.getReportFileName(++count));
                }
                ReportResult result = this.tcsource.getTechClient().requestReport(config);
                result.exportTo(reportFile);
            }
            catch (Throwable t) {
                String reason = StackTracer.getStacktrace(t);
                t.printStackTrace();
                SHGlassOptionPane.showErrorDialog(rpc, Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(rpc, Language.get("REPORT_ERROR_TITLE"), null, true, true);
                String msg = t.getMessage();
                if (msg == null) {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + ")", reason);
                } else {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + "," + msg + ")", reason);
                }
                dialog.setVisible(true);
            }
        }
    }

    static class HistoryPanelReportDialog
    extends OKCancelDialogPanel
    implements KeyListener {
        private JTextField reportSaveDirectory;
        private JButton directoryPicker;
        private JRadioButton sessionReport;
        private JRadioButton techniciansReport;
        private JCheckBox notifyWhenDone;
        private RootPaneContainer rpc;
        private JComboBox type;

        public HistoryPanelReportDialog() {
            super(Language.get("REQUEST_REPORT"), Language.get("CANCEL"));
            JPanel contentPanel = this.getContentPanel();
            contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale(new Dimension(500, 300)));
            FixedWidthPanel panel = new FixedWidthPanel(contentPanel);
            this.setContent(panel);
            this.reportSaveDirectory.addKeyListener(this);
        }

        public void showDialog(RootPaneContainer rpc) {
            this.rpc = rpc;
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("HISTORY_REPORT"));
            abstractGlassDialog.showDialog();
        }

        protected JPanel getContentPanel() {
            this.sessionReport = new JRadioButton();
            this.techniciansReport = new JRadioButton();
            this.notifyWhenDone = new JCheckBox(Language.get("REPORT_NOTIFY_DONE"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.sessionReport);
            group.add(this.techniciansReport);
            this.sessionReport.setSelected(true);
            JLabel inventoryReportTitle = new JLabel(Language.get("REPORT_SESSION_TITLE"));
            JLabel usageReportTitle = new JLabel(Language.get("REPORT_TECHNICIANS_TITLE"));
            JWrapLabel inventoryReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_SESSION_DESC"));
            JWrapLabel usageReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_TECHNICIANS_DESC"));
            MouseAdapter choice1 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HistoryPanelReportDialog.this.sessionReport.setSelected(true);
                }
            };
            MouseAdapter choice2 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HistoryPanelReportDialog.this.techniciansReport.setSelected(true);
                }
            };
            inventoryReportTitle.addMouseListener(choice1);
            inventoryReportDesc.addMouseListener(choice1);
            usageReportTitle.addMouseListener(choice2);
            usageReportDesc.addMouseListener(choice2);
            inventoryReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            usageReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            ColorPropagatingGBPanel main = new ColorPropagatingGBPanel();
            StrippedContentPanel singleWrapper = new StrippedContentPanel(main, false);
            singleWrapper.setTopBottomPadding(2);
            ColorPropagatingGBPanel options = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
            options.setBorder(SHBorderFactory.createEmptyBorder(0, 20, 0, 0));
            int Y = 0;
            options.add(this.sessionReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(inventoryReportTitle, 1, Y++, 1, 1, 1, 0, 11, 1);
            options.add(inventoryReportDesc, 1, Y++, 1, 1, 1, 0, 11, 1, new Insets(0, 3, 10, 3));
            options.add(this.techniciansReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(usageReportTitle, 1, Y++, 1, 1, 0, 0, 11, 1);
            options.add(usageReportDesc, 1, Y++, 1, 1, 0, 0, 11, 1, new Insets(0, 3, 10, 3));
            singleWrapper.addContent(options, Language.get("HISTORY_REPORT_TYPE_TITLE"), false);
            ColorPropagatingGBPanel settings = new ColorPropagatingGBPanel(new ScaledInsets(5, 5, 5, 5));
            this.reportSaveDirectory = new JTextField(lastSaveLocation);
            this.directoryPicker = new JButton(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"));
            SHButtonUI.makeButtonSegmentedRight(this.directoryPicker);
            this.directoryPicker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File directory = SafeJFileChooser.saveDirectory((Component)((Object)HistoryPanelReportDialog.this.rpc), new File(HistoryPanelReportDialog.this.reportSaveDirectory.getText()));
                    if (directory != null) {
                        HistoryPanelReportDialog.this.reportSaveDirectory.setText(directory.getAbsolutePath());
                    }
                }
            });
            SwingUtil.setSizesToTallest(new JComponent[]{this.reportSaveDirectory, this.directoryPicker});
            settings.add(new JLabel(Language.get("SAVE_REPORT_TO")), 0, 0, 1, 1, 0, 1, 13, 0);
            settings.add(this.reportSaveDirectory, 1, 0, 1, 1, 1, 1, 17, 2, new Insets(5, 5, 5, 0));
            settings.add(this.directoryPicker, 2, 0, 1, 1, 0, 1, 17, 2, new Insets(5, 0, 5, 5));
            this.type = new JComboBox<String>(new String[]{"CSV", "PDF"});
            this.type.setEnabled(false);
            this.type.setPreferredSize(new Dimension(this.type.getPreferredSize().width, this.reportSaveDirectory.getPreferredSize().height));
            settings.add(new JLabel(Language.get("REPORT_FORMAT")), 0, 1, 1, 1, 0, 1, 13, 0);
            settings.add(this.type, 1, 1, 1, 1, 0, 1, 17, 0);
            settings.add(this.notifyWhenDone, 1, 2, 1, 1, 0, 1, 17, 0, new Insets(5, 0, 5, 5));
            StrippedContentPanel.TitledSection section = singleWrapper.addContent(settings, Language.get("REPORT_OPTIONS_TITLE"), false);
            section.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 0, 0));
            singleWrapper.addVerticalFiller();
            singleWrapper.setBackgroundColours();
            TypeListener listener = new TypeListener();
            this.sessionReport.addActionListener(listener);
            this.techniciansReport.addActionListener(listener);
            JPanel userPanel = new JPanel();
            userPanel.setLayout(new GridLayout(1, 1));
            userPanel.add(main);
            return userPanel;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.setOkEnabled(this.reportSaveDirectory.getText().length() > 0);
        }

        class TypeListener
        implements ActionListener {
            TypeListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                HistoryPanelReportDialog.this.type.setEnabled(true);
                if (o != HistoryPanelReportDialog.this.techniciansReport) {
                    HistoryPanelReportDialog.this.type.setSelectedIndex(0);
                    HistoryPanelReportDialog.this.type.setEnabled(false);
                }
                HistoryPanelReportDialog.this.type.invalidate();
                HistoryPanelReportDialog.this.type.revalidate();
                HistoryPanelReportDialog.this.type.repaint();
            }
        }
    }

    public static interface HistoryFilterChangeListener {
        public void historyFilterChanged();
    }

    class FilterListPanel
    extends ColorPropagatingPanel
    implements ActionListener {
        private JCheckBox machineFilterBox;
        private JCheckBox technicianFilterBox;
        private JCheckBox textFieldBox;
        private JCheckBox typeFilterBox;

        public FilterListPanel(boolean showMachines, boolean showTechnicians, boolean showText, boolean showType) {
            super(new GridLayout(0, 1, SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10)));
            this.initUI(showMachines, showTechnicians, showText, showType);
            this.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        private void initUI(boolean showMachines, boolean showTechnicians, boolean showText, boolean showType) {
            this.machineFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_MACHINE"));
            this.technicianFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_TECHNICIAN"));
            this.textFieldBox = new JCheckBox(Language.get("HISTORY_FILTER_TEXT"));
            this.typeFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_TYPE"));
            this.machineFilterBox.setSelected(showMachines);
            this.technicianFilterBox.setSelected(showTechnicians);
            this.textFieldBox.setSelected(showText);
            this.typeFilterBox.setSelected(showType);
            this.machineFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale(15));
            this.technicianFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale(15));
            this.textFieldBox.setIconTextGap(SimpleHelpLookAndFeel.scale(15));
            this.typeFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale(15));
            this.machineFilterBox.addActionListener(this);
            this.technicianFilterBox.addActionListener(this);
            this.textFieldBox.addActionListener(this);
            this.typeFilterBox.addActionListener(this);
            this.add(this.typeFilterBox);
            this.add(this.machineFilterBox);
            this.add(this.technicianFilterBox);
            this.add(this.textFieldBox);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.machineFilterBox) {
                HistorySearchPanel.this.machineFilter.setVisible(this.machineFilterBox.isSelected());
            } else if (e.getSource() == this.technicianFilterBox) {
                HistorySearchPanel.this.technicianFilter.setVisible(this.technicianFilterBox.isSelected());
            } else if (e.getSource() == this.textFieldBox) {
                HistorySearchPanel.this.textFilter.setVisible(this.textFieldBox.isSelected());
            } else if (e.getSource() == this.typeFilterBox) {
                HistorySearchPanel.this.typeFilter.setVisible(this.typeFilterBox.isSelected());
            }
            HistorySearchPanel.this.filtersPanel.repaint();
        }
    }
}

