/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.ui;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class AbstractDetailsPanel {
    private HierarchyPanelListener panelListener;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private AbstractButton[] viewButtons;
    private JComponent[] viewPanels;
    private ViewButtonListener viewButtonListener = new ViewButtonListener();
    protected final JPanel rootComponent = new JPanel(new GridLayout(1, 1));
    protected final JPanel containerSingle = new JPanel();
    protected final SLPanel containerSliding = new SLPanel();
    protected JPanel buttonBar = new JPanel();
    protected JPanel buttonBarMiddle;
    private final JPanel viewsButtonPanel = new JPanel();
    protected JPanel buttonBarRight;
    private final MinMaxListener minMaxListener = new MinMaxListener();
    private final JToggleButton maxButton = new JToggleButton(ImageLoader.getImageIconDisabled("images/svg/technology/window-top.svg,12"));
    private final JToggleButton minButton = new JToggleButton(ImageLoader.getImageIconDisabled("images/svg/technology/window-bottom.svg,12"));
    private AbstractButton selectedView = null;
    private SLConfig[] viewConfigs;
    private SLConfig currentConfig;

    public AbstractDetailsPanel(HierarchyPanelListener panelListener) {
        this.panelListener = panelListener;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public AbstractButton[] getViewButtons() {
        return this.viewButtons;
    }

    public void setViewButtons(AbstractButton[] viewButtons, JComponent[] viewPanels) {
        if (this.viewButtons != null && this.viewButtons.length == viewButtons.length && Arrays.equals(viewButtons, this.viewButtons)) {
            return;
        }
        if (this.viewButtons != null) {
            for (AbstractButton b : this.viewButtons) {
                b.setSelected(false);
            }
        }
        int selectedIndex = this.getSelectedSLConfigIndex();
        AbstractButton selectedButton = null;
        if (selectedIndex >= 0) {
            selectedButton = this.viewButtons[selectedIndex];
        }
        this.viewButtons = viewButtons;
        this.viewPanels = viewPanels;
        this.initViewButtons(selectedButton);
    }

    private void addToButtonGroup(AbstractButton button) {
        Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            if (elements.nextElement() != button) continue;
            return;
        }
        this.buttonGroup.add(button);
    }

    protected void initViewButtons(AbstractButton selectedButton) {
        this.recreateViewConfigs();
        boolean first = this.viewsButtonPanel.getComponentCount() == 0;
        this.viewsButtonPanel.removeAll();
        AbstractButton[] buttons = this.getViewButtons();
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(buttons);
        this.currentConfig = this.viewConfigs[0];
        for (AbstractButton button : buttons) {
            this.addToButtonGroup(button);
            button.removeActionListener(this.viewButtonListener);
            button.addActionListener(this.viewButtonListener);
            this.viewsButtonPanel.add(button);
            SwingUtil.setHeight(button, this.getButtonHeight());
        }
        boolean selectionFound = false;
        for (int i = 0; i < buttons.length; ++i) {
            AbstractButton button = buttons[i];
            if (selectedButton == null || selectedButton != button) continue;
            this.currentConfig = this.viewConfigs[i];
            button.setSelected(true);
            selectionFound = true;
        }
        if (!selectionFound) {
            buttons[0].setSelected(true);
        }
        this.containerSliding.initialize(this.currentConfig);
        this.viewsButtonPanel.revalidate();
        this.viewsButtonPanel.repaint();
    }

    protected int getButtonHeight() {
        return SimpleHelpLookAndFeel.scale(23);
    }

    protected void initUI() {
        this.initButtonBar();
        this.containerSingle.setLayout(new BorderLayout());
        this.containerSingle.add("North", this.buttonBar);
        this.containerSingle.add("Center", this.containerSliding);
        this.containerSingle.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.containerSliding.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.initSlidingConfigs();
        this.rootComponent.setMinimumSize(new Dimension(-1, this.buttonBar.getPreferredSize().height + 100));
    }

    protected void initButtonBar() {
        this.buttonBar.setLayout(new BorderLayout());
        this.buttonBar.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, AccessStyle.DETAILS_CONTENT_BORDER));
        this.buttonBar.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.viewsButtonPanel.setLayout(new GridLayout(1, 0));
        this.viewsButtonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.buttonBarMiddle = new JPanel(new FlowLayout());
        this.buttonBarMiddle.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.buttonBarMiddle.add(this.viewsButtonPanel);
        this.buttonBarRight = new JPanel(new FlowLayout());
        this.buttonBarRight.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        GbPanel maxMinPanel = new GbPanel();
        maxMinPanel.add(this.maxButton, 0, 0, 1, 1, 1, 1, 10, 1);
        maxMinPanel.add(this.minButton, 0, 1, 1, 1, 1, 1, 10, 1);
        this.minButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.maxButton.setMinimumSize(new Dimension(15, -1));
        this.minButton.setMinimumSize(new Dimension(15, -1));
        this.maxButton.setPreferredSize(new Dimension(15, -1));
        this.minButton.setPreferredSize(new Dimension(15, -1));
        this.maxButton.addActionListener(this.minMaxListener);
        this.minButton.addActionListener(this.minMaxListener);
        JPanel rightWrapper = new JPanel(new BorderLayout());
        rightWrapper.add((Component)this.buttonBarRight, "West");
        if (Switches.SH_detailsPanelMinMaxSupport) {
            rightWrapper.add((Component)maxMinPanel, "East");
        }
        this.buttonBarRight.setBorder(SHBorderFactory.createMatteBorder(0, 0, 0, 1, SHUI.TRACK_LINE));
        this.buttonBar.add((Component)this.buttonBarMiddle, "West");
        this.buttonBar.add((Component)rightWrapper, "East");
    }

    public int getButtonBarHeight() {
        return this.buttonBar.getPreferredSize().height;
    }

    public void userResizing() {
        this.setMinMax(false, false);
    }

    private void initSlidingConfigs() {
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.currentConfig = this.viewConfigs[0];
        this.recreateViewConfigs();
        this.containerSliding.initialize(this.currentConfig);
    }

    private void recreateViewConfigs() {
        JComponent[] panels = this.viewPanels;
        this.viewConfigs = new SLConfig[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            this.viewConfigs[i] = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, panels[i]);
        }
    }

    protected void handleViewSwitch(int slConfigIndex) {
        if (slConfigIndex == -1) {
            slConfigIndex = 0;
        }
        this.switchToNewView(this.viewConfigs[slConfigIndex], this.viewPanels[slConfigIndex]);
    }

    protected void handleViewSwitch(AbstractButton source) {
        AbstractButton[] buttons = this.getViewButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (source != buttons[i]) continue;
            this.switchToNewView(this.viewConfigs[i], this.viewPanels[i]);
        }
    }

    public void setShowOnlyButtonBar(boolean showOnlyButtonBar) {
        this.containerSliding.setVisible(!showOnlyButtonBar);
    }

    private int getSLConfigIndex(SLConfig config) {
        if (this.viewConfigs != null) {
            for (int i = 0; i < this.viewConfigs.length; ++i) {
                if (this.viewConfigs[i] != config) continue;
                return i;
            }
        }
        return -1;
    }

    protected int getSelectedSLConfigIndex() {
        return this.getSLConfigIndex(this.currentConfig);
    }

    private void switchToNewView(SLConfig newConfig, Component myComponent) {
        if (this.currentConfig != newConfig) {
            SLSide mySide = this.getSLConfigIndex(newConfig) > this.getSLConfigIndex(this.currentConfig) ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(newConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.currentConfig = newConfig;
        }
    }

    public void setMinMax(boolean min, boolean max) {
        this.minButton.setSelected(min);
        this.maxButton.setSelected(max);
        this.setMinMaxIcon();
        this.panelListener.setDetailsPanelState(this.minButton.isSelected(), this.maxButton.isSelected());
    }

    private void setMinMaxIcon() {
        if (this.minButton.isSelected()) {
            this.minButton.setIcon(ImageLoader.getImageIcon("images/svg/technology/window-bottom.svg,12"));
        } else {
            this.minButton.setIcon(ImageLoader.getImageIconDisabled("images/svg/technology/window-bottom.svg,12"));
        }
        if (this.maxButton.isSelected()) {
            this.maxButton.setIcon(ImageLoader.getImageIcon("images/svg/technology/window-top.svg,12"));
        } else {
            this.maxButton.setIcon(ImageLoader.getImageIconDisabled("images/svg/technology/window-top.svg,12"));
        }
    }

    class MinMaxListener
    implements ActionListener {
        MinMaxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AbstractDetailsPanel.this.maxButton) {
                AbstractDetailsPanel.this.setMinMax(false, AbstractDetailsPanel.this.maxButton.isSelected());
            } else if (e.getSource() == AbstractDetailsPanel.this.minButton) {
                AbstractDetailsPanel.this.setMinMax(AbstractDetailsPanel.this.minButton.isSelected(), false);
            }
        }
    }

    class ViewButtonListener
    implements ActionListener {
        ViewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof AbstractButton) {
                AbstractDetailsPanel.this.handleViewSwitch((AbstractButton)e.getSource());
            }
        }
    }
}

