/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.customer.AdditionalCustomerInfoPanel;
import com.aem.shelp.tech.customer.CustomerListListener;
import com.aem.shelp.tech.customer.CustomerTypePanelList;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import utils.swing.ExponentialSlider;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class CustomerTypePanel
extends GbPanel
implements ActionListener,
CustomerListListener {
    private static final ElapsedTimeFormatter timeFormatter = new ElapsedTimeFormatter();
    private static final Color TERMINATING = new Color(202, 76, 74);
    private JLabel os;
    private JLabel waitingFor;
    private CompoundBorder unselectedBorder;
    private CompoundBorder selectedBorder;
    private JLabel[] detailsLabels;
    private int height = 30;
    private int nameWidth = 250;
    private JButton actionButton;
    private boolean isSelected;
    private Color selectedBackground = new Color(230, 235, 245);
    private Customer customer;
    private ArrayList<String> detailsToShow;
    private JPanel actionPanel;
    private Color unselectedBackground = new Color(251, 251, 251);
    private boolean isSession;
    private SupportSession session;
    private CustomerTypePanelList list;
    private static final boolean DEBUG = false;
    private static AdditionalCustomerInfoPanel infoPanel = new AdditionalCustomerInfoPanel();
    boolean isHovered = false;
    private boolean terminate = false;
    private boolean viewOnly;
    private int mode;
    int drawX = 0;
    BufferedImage drawImage = null;
    private CustomerListListener customerListListener;

    public CustomerTypePanel(CustomerTypePanelList list, Customer customer, SupportSession session, ArrayList<String> detailsToShow, CustomerListListener customerListListener, boolean isSession) {
        super(new Insets(2, 2, 2, 2));
        this.customerListListener = customerListListener;
        this.list = list;
        this.setFocusable(true);
        this.customer = customer;
        this.isSession = isSession;
        this.session = session;
        this.detailsToShow = detailsToShow;
        this.setOpaque(true);
        this.unselectedBorder = SHBorderFactory.createCompoundBorder(SHStyle.lightTopBorder, SHStyle.darkBottomBorder);
        this.selectedBorder = SHBorderFactory.createCompoundBorder(SHStyle.darkTopBorder, SHStyle.darkBottomBorder);
        if (!isSession) {
            this.actionButton = new JButton(Language.get("CONNECT"));
        } else {
            this.actionButton = new JButton(Language.get("KILL_SESSION"));
            SHButtonUI.makeButtonRed(this.actionButton);
        }
        this.os = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 24;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        JLabel primaryLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = CustomerTypePanel.this.nameWidth;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.actionButton.addActionListener(this);
        this.waitingFor = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.waitingFor.setFont(SHStyle.smallerFont);
        this.waitingFor.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.waitingFor.setHorizontalTextPosition(4);
        this.waitingFor.setHorizontalAlignment(4);
        int labelCount = Math.max(detailsToShow.size(), 1);
        this.detailsLabels = new JLabel[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            if (i == 0) {
                this.detailsLabels[i] = primaryLabel;
                continue;
            }
            this.detailsLabels[i] = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width = 20;
                    return dim;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.detailsLabels[i].setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        }
        int X = 0;
        this.add(this.os, X++, 0, 1, 1, 0, 0, 10, 0);
        for (int i = 0; i < this.detailsLabels.length; ++i) {
            int widthWeight = 1;
            if (i == 0 && this.detailsLabels.length != 1) {
                widthWeight = 0;
            }
            this.add(this.detailsLabels[i], X++, 0, 1, 1, widthWeight, 0, 17, 2);
        }
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BorderLayout());
        this.actionPanel.add((Component)this.actionButton, "East");
        this.actionPanel.setVisible(false);
        SwingUtil.setWidth(this.actionPanel, 100);
        this.add(this.waitingFor, X++, 0, 1, 1, 0, 0, 13, 2);
        this.add(this.actionPanel, X++, 0, 1, 1, 0, 0, 13, 2);
        this.initWith(customer);
        this.isSelected = false;
        this.setBackground(this.unselectedBackground);
        this.setBorder(this.unselectedBorder);
        this.actionPanel.setBackground(this.unselectedBackground);
        this.height = 30;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = this.height;
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.height;
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        dim.height = this.height;
        return dim;
    }

    public void initWith(Customer customer) {
        this.os.setIcon(OSIconLoader.getOSIcon(customer.getOsBaseType(), customer.getOsVariant(), customer.getOsSummary()));
        if (this.detailsToShow.size() == 0) {
            this.detailsLabels[0].setText(customer.getRemoteUsername());
        } else {
            for (int i = 0; i < this.detailsToShow.size(); ++i) {
                String detail = this.detailsToShow.get(i);
                if (this.session != null && detail.equals(Language.get("TECHNICIAN"))) {
                    this.detailsLabels[i].setText(this.session.getTechnicianDisplayName());
                    continue;
                }
                this.detailsLabels[i].setText(customer.getValue(this.detailsToShow.get(i), true));
            }
        }
        if (this.session != null) {
            this.setWaitingForRounded(this.session.getIncrementedElapsedTime());
        } else {
            this.setWaitingForRounded(customer.getWaitingFor());
        }
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        if (b) {
            infoPanel.setBackground(this.selectedBackground);
            this.actionPanel.setBackground(this.selectedBackground);
            this.setBackground(this.selectedBackground);
            this.setBorder(this.selectedBorder);
            this.height = CustomerTypePanel.infoPanel.getRootComponent().getPreferredSize().height + 34;
            this.actionPanel.setVisible(false);
            this.waitingFor.setVisible(true);
            infoPanel.removeFromParent();
            infoPanel.initWith(this.customer, this.isSession, this.customerListListener.getTechGroupPermissions());
            infoPanel.setCustomerListListener(this);
            infoPanel.getRootComponent().setVisible(b);
            this.add(infoPanel.getRootComponent(), 0, 1, this.getComponentCount(), 1, 1, 1, 10, 2);
        } else {
            infoPanel.getRootComponent().setVisible(b);
            this.setBackground(this.unselectedBackground);
            this.setBorder(this.unselectedBorder);
            this.actionPanel.setBackground(this.unselectedBackground);
            this.height = 30;
        }
        this.revalidate();
        this.repaint();
    }

    public void setHover(final boolean isHovered) {
        if (this.isHovered == isHovered) {
            return;
        }
        this.isHovered = isHovered;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isSession = CustomerTypePanel.this.isSession;
                if (!CustomerTypePanel.this.isSelected) {
                    if (isSession) {
                        if (CustomerTypePanel.this.session != null && CustomerTypePanel.this.list.getTech().canTerminateSession(CustomerTypePanel.this.session)) {
                            CustomerTypePanel.this.actionPanel.setVisible(isHovered);
                            CustomerTypePanel.this.waitingFor.setVisible(!isHovered);
                        } else {
                            CustomerTypePanel.this.actionPanel.setVisible(false);
                            CustomerTypePanel.this.waitingFor.setVisible(true);
                        }
                    } else {
                        CustomerTypePanel.this.actionPanel.setVisible(isHovered);
                        CustomerTypePanel.this.waitingFor.setVisible(!isHovered);
                    }
                } else {
                    CustomerTypePanel.this.actionPanel.setVisible(false);
                    CustomerTypePanel.this.waitingFor.setVisible(true);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.actionButton) {
            if (!this.isSession) {
                this.doConnect(0, false);
            } else {
                this.doTerminate();
            }
        }
    }

    public void doTerminate() {
        this.terminate = true;
        Dimension size = this.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = image.createGraphics();
        this.paint(g);
        g.dispose();
        this.actionPanel.setEnabled(false);
        new SlideThread(image, true).start();
    }

    public void doConnect(int mode, boolean viewOnly) {
        this.mode = mode;
        this.viewOnly = viewOnly;
        Dimension size = this.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = image.createGraphics();
        this.paint(g);
        g.dispose();
        this.actionPanel.setEnabled(false);
        new SlideThread(image).start();
    }

    @Override
    public void paint(Graphics g) {
        if (this.drawImage == null) {
            super.paint(g);
        } else {
            if (this.terminate) {
                g.setColor(TERMINATING);
            } else {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.drawImage, this.drawX, 0, null);
        }
    }

    public Customer getCustomer() {
        return this.customer;
    }

    private void setWaitingForRounded(long ms) {
        ms = Math.max(1000L, ms);
        this.waitingFor.setText(timeFormatter.getFormattedTime(ms));
    }

    public void updateCustomerInfo() {
        if (this.session != null) {
            this.setWaitingForRounded(this.session.getIncrementedElapsedTime());
        } else {
            this.setWaitingForRounded(this.customer.getWaitingFor());
        }
        this.waitingFor.repaint();
    }

    @Override
    public void connectToCustomer(Customer customer, int mode, boolean viewOnly) {
        this.doConnect(mode, viewOnly);
    }

    @Override
    public void terminateCustomerOrSession(Customer customer) {
        this.doTerminate();
    }

    public void terminateSession(SupportSession customer) {
        this.doTerminate();
    }

    @Override
    public TechGroupPermissions getTechGroupPermissions() {
        return this.customerListListener.getTechGroupPermissions();
    }

    class SlideThread
    extends Thread {
        private boolean slideLeft;

        public SlideThread(BufferedImage image) {
            this(image, false);
        }

        public SlideThread(BufferedImage image, boolean slideLeft) {
            CustomerTypePanel.this.drawImage = image;
            this.slideLeft = slideLeft;
        }

        @Override
        public void run() {
            int width = CustomerTypePanel.this.getWidth();
            ExponentialSlider es = new ExponentialSlider((double)width, 300L, 1.0, false);
            for (int i = 0; i < es.getPositionCount(); ++i) {
                CustomerTypePanel.this.drawX = !this.slideLeft ? es.getPositionForStepRounded(i) : -es.getPositionForStepRounded(i);
                if (CustomerTypePanel.this.getParent() != null) {
                    CustomerTypePanel.this.getParent().repaint();
                }
                try {
                    Thread.sleep(es.get25fpsSleep());
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            new SquishThread().run();
        }
    }

    class SquishThread
    extends Thread {
        @Override
        public void run() {
            ExponentialSlider es = new ExponentialSlider((double)CustomerTypePanel.this.height, 1000L, 10.0, true);
            int originalHeight = CustomerTypePanel.this.height;
            for (int i = 0; i < es.getPositionCount(); ++i) {
                CustomerTypePanel.this.height = originalHeight - es.getPositionForStepRounded(i);
                if (CustomerTypePanel.this.height <= 0) {
                    CustomerTypePanel.this.height = 0;
                }
                ((JComponent)CustomerTypePanel.this.getParent()).revalidate();
                CustomerTypePanel.this.getParent().repaint();
                try {
                    Thread.sleep(es.get25fpsSleep());
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (CustomerTypePanel.this.terminate) {
                CustomerTypePanel.this.customerListListener.terminateCustomerOrSession(CustomerTypePanel.this.customer);
            } else {
                CustomerTypePanel.this.customerListListener.connectToCustomer(CustomerTypePanel.this.customer, CustomerTypePanel.this.mode, CustomerTypePanel.this.viewOnly);
            }
            CustomerTypePanel.this.getParent().remove(CustomerTypePanel.this);
        }
    }
}

