/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.WindowBoundsUtil;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.techclient.MonitoringOnlyException;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.customer.ColumnSelector;
import com.aem.shelp.tech.customer.CustomerListListener;
import com.aem.shelp.tech.customer.CustomerModel;
import com.aem.shelp.tech.customer.CustomerTypePanelList;
import com.aem.shelp.tech.customer.HeaderPanel;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.util.swing.ShSearchTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.progtools.collections.MaxAgeLinkedList;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class CustomerQueuePanel
implements MessageFieldHandler.FilterListener {
    private JPanel rootComponent = new JPanel();
    private CustomerTypePanelList customerList;
    private NoContentsInfoPanel infoPanel;
    private JButton configureButton;
    private ButtonListener buttonListener = new ButtonListener();
    private CustomerModel customerModel;
    private boolean isWaitingList;
    private TechClient client;
    CustomerActionListener listener = new CustomerActionListener();
    private HeaderPanel headerPanel;
    private MaxAgeLinkedList<String> customerIgnoreList = new MaxAgeLinkedList(10000L);
    private Dimension buttonSizeNarrower = new Dimension(SimpleHelpLookAndFeel.scale(30), SimpleHelpLookAndFeel.scale(22));
    private JSearchTextField messageTextField;
    private JPanel leftButtonsPanel;
    private ColumnSelector columnSelector = null;
    static long time = 0L;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public void setTechClient(TechClient client) {
        this.client = client;
        this.customerList.setTechClient(client);
    }

    public CustomerQueuePanel(boolean isWaitingList) {
        this.isWaitingList = isWaitingList;
        this.customerModel = new CustomerModel(!isWaitingList);
        this.initUI(isWaitingList);
        this.customerModel.addCustomerModelListener(new CustomerModel.CustomerModelListener(){

            @Override
            public void customerModelSizeChanged() {
                CustomerQueuePanel.this.infoPanel.setHasContents(CustomerQueuePanel.this.customerModel.getUnfilteredSize() != 0);
                CustomerQueuePanel.this.updateEnabled();
            }
        });
    }

    private void doConnect(Customer customer, int mode, boolean viewOnly) {
        if (customer != null) {
            try {
                this.customerIgnoreList.put(customer.getCustomerID());
                System.out.println("[CustomerQueuePanel] Requesting connect to " + customer.getCustomerID());
                this.client.startClient(customer.getCustomerID(), false, true, mode, false, 0L, viewOnly, WindowBoundsUtil.getDesiredWindowBounds(), null, null);
            }
            catch (MonitoringOnlyException x) {
                MonitoringOnlyUtil.disallowedPopup(SwingUtil.getRootPaneContainer(this.rootComponent), this.getRootComponent());
            }
            catch (Exception x) {
                x.printStackTrace();
                SHGlassOptionPane.showMessageDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("CONNECTION_FAILED") + ": " + x, Language.get("CONNECTION_FAILED"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }

    private void terminateCustomer(Customer customer) {
        System.out.println("[CustomerQueuePanel] [Customer] Asked to terminate " + customer);
        try {
            this.customerIgnoreList.put(customer.getCustomerID());
            this.client.kickUser(customer);
        }
        catch (Exception x) {
            System.out.println("[CustomerQueuePanel] Failed to kick user " + customer + ": " + x);
            x.printStackTrace();
        }
    }

    private void terminateSession(SupportSession session) {
        System.out.println("[CustomerQueuePanel] [Session] Asked to terminate " + session);
        if (session != null) {
            try {
                this.client.killSession(session);
            }
            catch (Exception x) {
                System.out.println("[CustomerQueuePanel] Failed to kill live connection " + session + ": " + x);
                x.printStackTrace();
            }
        }
    }

    public void testLaunchOneSession() {
        if (this.customerModel.getSize() == 0) {
            System.out.println("[Testing] Unable to launch customer session - no customers in queue");
        } else {
            Customer customer = this.customerModel.getCustomer(0);
            System.out.println("[Testing] Launching customer session to " + customer);
            this.testLaunchOneSession(customer);
        }
    }

    public void testLaunchOneSession(Customer customer) {
        new CustomerActionListener().connectToCustomer(customer, 0, false);
    }

    private void initUI(boolean isWaitingList) {
        GbPanel buttonsBar = new GbPanel();
        buttonsBar.setBorder(SHStyle.BUTTON_BAR_BORDER);
        this.initButtonsBar(buttonsBar);
        this.infoPanel = isWaitingList ? new NoContentsInfoPanel(Language.get("CUSTOMER_PANEL_NO_CUSTOMERS"), ImageLoader.getImageIconDisabled("images/svg/users/customers.svg,48"), false) : new NoContentsInfoPanel(Language.get("CUSTOMER_PANEL_NO_SESSIONS"), ImageLoader.getImageIconDisabled("images/svg/general/help.svg,48"), false);
        this.infoPanel.setFont(SHStyle.largeFont, SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.infoPanel.setNoContentsBorder(SHStyle.darkTopBorder);
        this.customerList = new CustomerTypePanelList(this.customerModel, this.listener, !isWaitingList);
        final JScrollPane sp = new JScrollPane(this.customerList.getRootComponent());
        sp.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        sp.getHorizontalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        sp.setBorder(null);
        sp.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JScrollBar verticalScrollBar = sp.getVerticalScrollBar();
                if (verticalScrollBar.isVisible()) {
                    CustomerQueuePanel.this.headerPanel.setScrollBarWidth(sp.getVerticalScrollBar().getWidth());
                } else {
                    CustomerQueuePanel.this.headerPanel.setScrollBarWidth(0);
                }
            }
        });
        this.infoPanel.setContentsPanel(sp);
        sp.setBorder(SHStyle.darkTopBorder);
        this.headerPanel = new HeaderPanel(isWaitingList);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)buttonsBar, "Center");
        topPanel.add((Component)this.headerPanel, "South");
        this.rootComponent.setLayout(new BorderLayout());
        this.rootComponent.add((Component)this.infoPanel, "Center");
        this.rootComponent.add((Component)topPanel, "North");
        this.headerPanel.setBackground(buttonsBar.getBackground());
    }

    public JPanel getLeftButtonsPanel() {
        return this.leftButtonsPanel;
    }

    private void initButtonsBar(GbPanel buttonsBar) {
        this.configureButton = new JButton(ImageLoader.getImageIcon("images/svg/general/gear.svg,16"));
        this.configureButton.addActionListener(this.buttonListener);
        this.configureButton.setEnabled(false);
        this.leftButtonsPanel = new JPanel();
        this.messageTextField = new ShSearchTextField();
        this.messageTextField.setFilterListener(this);
        this.messageTextField.setEnabled(false);
        int X = 0;
        this.configureButton.setPreferredSize(this.buttonSizeNarrower);
        Dimension dim = this.messageTextField.getPreferredSize();
        dim.width = SimpleHelpLookAndFeel.scale(200);
        dim.height = SimpleHelpLookAndFeel.scale(26);
        this.messageTextField.setMaximumSize(dim);
        this.messageTextField.setMinimumSize(dim);
        this.messageTextField.setPreferredSize(dim);
        SwingUtil.setHeight(this.configureButton, dim.height);
        buttonsBar.add(this.leftButtonsPanel, X++, 0, 1, 1, 1, 0, 13, 1, new Insets(0, 0, 2, 0));
        buttonsBar.add(this.messageTextField, X++, 0, 1, 1, 1, 0, 13, 0, new Insets(0, 0, 2, 0));
        buttonsBar.add(this.configureButton, X++, 0, 1, 1, 0, 0, 13, 0, new Insets(0, 2, 2, 0));
        buttonsBar.setBackground(SHStyle.BUTTON_BAR_BACKGROUND_LARGE);
        this.leftButtonsPanel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND_LARGE);
    }

    private void selectedDetailsChanged() {
        this.customerList.recreateUI();
        this.headerPanel.setDetailsToShow(this.customerModel.getSelectedDetailsToShow());
    }

    private void updateEnabled() {
        int count = this.customerModel.getUnfilteredSize();
        this.messageTextField.setEnabled(count > 0);
        this.configureButton.setEnabled(count > 0);
    }

    public void setCustomers(Customer[] customers) {
        ArrayList<Customer> filteredCustomers = new ArrayList<Customer>();
        for (Customer c : customers) {
            if (this.customerIgnoreList.contains(c.getCustomerID())) continue;
            filteredCustomers.add(c);
        }
        Customer[] testCustomers = filteredCustomers.toArray(new Customer[0]);
        this.customerModel.setCustomers(testCustomers);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomerQueuePanel.this.headerPanel.setDetailsToShow(CustomerQueuePanel.this.customerModel.getSelectedDetailsToShow());
                CustomerQueuePanel.this.customerList.updateFromModel();
            }
        });
    }

    public void setSessions(SupportSession[] sessions) {
        this.customerModel.setSessions(sessions);
        this.headerPanel.setDetailsToShow(this.customerModel.getSelectedDetailsToShow());
        this.customerList.updateFromModel();
    }

    public void update() {
        this.customerList.updateFromModel();
    }

    public static long time() {
        long newTime = System.currentTimeMillis();
        long diff = newTime - time;
        time = newTime;
        return diff;
    }

    @Override
    public void setFilter(String filter, boolean immediate) {
        this.customerModel.setFilter(filter);
        this.customerList.recreateUI();
    }

    public void setCoreDetails(String[] detals) {
        this.customerModel.setCoreDetails(detals);
    }

    public static void main(String[] args) throws Exception {
        SafeResourceBundle.loadTestBundle();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        CustomerQueuePanel customerPanel = new CustomerQueuePanel(System.currentTimeMillis() % 2L == 0L);
        customerPanel.customerModel.setCoreDetails(new String[]{"Name", "Company"});
        frame.getContentPane().add(customerPanel.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(2000L);
        Customer[] testCustomers = new Customer[3];
        for (int i = 0; i < 3; ++i) {
            testCustomers[i] = Customer.createTestCustomer();
            CustomerQueuePanel.time();
            customerPanel.setCustomers(testCustomers);
            System.out.println("Time to reset the customer list was " + CustomerQueuePanel.time());
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CustomerQueuePanel.this.configureButton) {
                JPopupMenu menu = new JPopupMenu();
                if (CustomerQueuePanel.this.columnSelector == null) {
                    CustomerQueuePanel.this.columnSelector = new ColumnSelector(CustomerQueuePanel.this.customerModel.getAllDetails(), CustomerQueuePanel.this.customerModel.getSelectedDetailsToShow()){

                        @Override
                        public void modelChanged() {
                            CustomerQueuePanel.this.customerModel.setSelectedDetailsToShow(this.getSelectedColumns());
                            CustomerQueuePanel.this.selectedDetailsChanged();
                        }
                    };
                } else {
                    CustomerQueuePanel.this.columnSelector.initWith(CustomerQueuePanel.this.customerModel.getAllDetails(), CustomerQueuePanel.this.customerModel.getSelectedDetailsToShow());
                }
                menu.add(CustomerQueuePanel.this.columnSelector);
                Dimension preferredSize = CustomerQueuePanel.this.columnSelector.getPreferredSize();
                menu.setSize(preferredSize.width, preferredSize.height);
                int width = menu.getPreferredSize().width;
                Rectangle bounds = CustomerQueuePanel.this.configureButton.getBounds();
                int x = -width + ((CustomerQueuePanel)CustomerQueuePanel.this).configureButton.getBounds().width;
                menu.show(CustomerQueuePanel.this.configureButton, x, 1 + bounds.height);
            }
        }
    }

    public class CustomerActionListener
    implements CustomerListListener {
        @Override
        public void connectToCustomer(Customer customer, int mode, boolean viewOnly) {
            CustomerQueuePanel.this.customerModel.removeCustomer(customer);
            CustomerQueuePanel.this.doConnect(customer, mode, viewOnly);
        }

        @Override
        public void terminateCustomerOrSession(Customer customer) {
            SupportSession session = CustomerQueuePanel.this.customerModel.getSessionFor(customer);
            CustomerQueuePanel.this.customerModel.removeCustomer(customer);
            if (session != null) {
                CustomerQueuePanel.this.terminateSession(session);
            } else {
                CustomerQueuePanel.this.terminateCustomer(customer);
            }
        }

        @Override
        public TechGroupPermissions getTechGroupPermissions() {
            return CustomerQueuePanel.this.client.getPermissions();
        }
    }
}

