/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile.ui;

import com.aem.profiles.model.AppProfile;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.sgateway.config.panels.SGProxyPanel;
import com.aem.sgateway.config.panels.SGSecurityPanel;
import com.aem.sgateway.config.panels.SGServersPanel;
import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.SGParameters;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import com.aem.shelp.tech.appprofile.ui.AbstractProfileUI;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.RootPaneContainer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.images.ImageLoader;

public class RemoteAccessProfileUI
extends AbstractProfileUI {
    SGServersPanel serverTab;
    SGProxyPanel proxyTab;
    SGSecurityPanel securityTab;

    public RemoteAccessProfileUI(AppProfile appProfile, ProfileUIListener uiListener, RootPaneContainer rpc, TechClient client) {
        super(appProfile, uiListener, rpc, client);
    }

    private static String getServerList(String[] urls) {
        if (urls == null || urls.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(urls[i]);
        }
        return result.toString();
    }

    private boolean parseBoolean(String bool, boolean def) {
        if (bool == null) {
            return def;
        }
        if (Boolean.parseBoolean(bool) || bool.equals("yes") || bool.equals("on")) {
            return Boolean.TRUE;
        }
        if (!Boolean.parseBoolean(bool) || bool.equals("no") || bool.equals("off")) {
            return Boolean.FALSE;
        }
        return def;
    }

    @Override
    public void loadFromProfile(AppProfile appProfile) {
        this.resetTabs();
        this.appProfile = appProfile;
        SimpleGatewayConfig config = new SimpleGatewayConfig();
        Properties properties = appProfile.getLaunchProperties();
        if (properties == null) {
            return;
        }
        SGParameters.updateSGConfigWithLaunchProperties(config, properties);
        boolean silentInstall = this.parseBoolean(properties.getProperty("sg_silent_install"), false);
        boolean installShortcuts = this.parseBoolean(properties.getProperty("sg_install_shortcuts"), true);
        String pword = properties.getProperty("sg_password");
        if (pword.length() == 0) {
            config.setPassword(null);
        } else {
            config.setPassword(pword);
        }
        boolean requestPermission = this.parseBoolean(properties.getProperty("sg_confirm"), false);
        long permissionTimeout = 0L;
        try {
            permissionTimeout = Long.parseLong(properties.getProperty("sg_confirm_timeout"));
            System.out.println("Restoring timeout " + permissionTimeout);
        }
        catch (Exception x) {
            System.out.println("Error restoring timeout " + x);
            x.printStackTrace();
        }
        config.setRequireSessionConfirmation(requestPermission, permissionTimeout);
        this.serverTab.loadFrom(config, silentInstall, installShortcuts);
        this.proxyTab.loadFrom(config);
        this.securityTab.loadFrom(config);
    }

    protected void saveToProfile() {
        SimpleGatewayConfig config = new SimpleGatewayConfig();
        this.serverTab.saveTo(config);
        this.proxyTab.saveTo(config);
        this.securityTab.saveTo(config);
        String name = config.getName();
        String[] urls = config.getSafeURLs();
        String password = config.getPassword();
        boolean canMonitor = config.getAllowMonitoring();
        boolean canScript = config.getAllowScripting();
        boolean mustConfirm = config.getRequireSessionConfirmation();
        long timeout = config.getRequirePermissionTimeoutMS();
        System.out.println("Saving timeout " + timeout);
        boolean isSilent = this.serverTab.mustSilentInstall();
        boolean installShortcuts = this.serverTab.canInstallShortcuts();
        String proxyHostname = config.getProxyHost();
        if (proxyHostname != null && proxyHostname.length() > 0) {
            int proxyPort = config.getProxyPort();
            String proxyUsername = config.getProxyUser();
            String proxyPassword = config.getProxyPass();
            proxyHostname = proxyUsername == null || proxyUsername.length() == 0 ? proxyHostname + ":" + proxyPort : (proxyPassword == null || proxyPassword.length() == 0 ? proxyUsername + "@" + proxyHostname + ":" + proxyPort : proxyUsername + ":" + proxyPassword + "@" + proxyHostname + ":" + proxyPort);
        } else {
            proxyHostname = "";
        }
        Properties launchProperties = new Properties();
        SGParameters.setLaunchProperty(launchProperties, "sg_name", name);
        SGParameters.setLaunchProperty(launchProperties, "sg_servers", RemoteAccessProfileUI.getServerList(urls));
        if (password != null) {
            SGParameters.setLaunchProperty(launchProperties, "sg_password", password);
        }
        SGParameters.setLaunchProperty(launchProperties, "sg_monitor", Boolean.toString(canMonitor));
        SGParameters.setLaunchProperty(launchProperties, "sg_script", Boolean.toString(canScript));
        SGParameters.setLaunchProperty(launchProperties, "sg_confirm", Boolean.toString(mustConfirm));
        SGParameters.setLaunchProperty(launchProperties, "sg_confirm_timeout", Long.toString(timeout));
        SGParameters.setLaunchProperty(launchProperties, "sg_silent_install", Boolean.toString(isSilent));
        SGParameters.setLaunchProperty(launchProperties, "sg_install_shortcuts", Boolean.toString(installShortcuts));
        SGParameters.setLaunchProperty(launchProperties, "sg_proxy", proxyHostname);
        this.appProfile.setLaunchProperties(launchProperties);
    }

    @Override
    public AbstractProfileUI.AppProfileTab[] getTabs() {
        boolean fileAccess = false;
        boolean useTabs = true;
        boolean supportsUDP = true;
        SaveListener changeListener = new SaveListener();
        this.serverTab = new SGServersPanel(changeListener, useTabs, fileAccess, supportsUDP, true);
        this.proxyTab = new SGProxyPanel(changeListener, useTabs);
        this.securityTab = new SGSecurityPanel(changeListener, useTabs);
        AbstractProfileUI.AppProfileTab[] tabs = new AbstractProfileUI.AppProfileTab[]{new AbstractProfileUI.AppProfileTab(Language.get("PREFERENCES"), ImageLoader.getImageIcon("images/svg/computing/sliders.svg,16"), this.serverTab.getRootComponent()), new AbstractProfileUI.AppProfileTab(Language.get("SECURITY"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"), this.securityTab.getRootComponent()), new AbstractProfileUI.AppProfileTab(Language.get("PROXY"), ImageLoader.getImageIcon("images/svg/computing/network.svg,16"), this.proxyTab.getRootComponent())};
        return tabs;
    }

    class SaveListener
    implements SGChangeListener {
        boolean ignoreEvents = false;

        SaveListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.ignoreEvents) {
                return;
            }
            RemoteAccessProfileUI.this.saveToProfile();
            RemoteAccessProfileUI.this.uiListener.save(RemoteAccessProfileUI.this.appProfile);
        }

        @Override
        public void setDirty(boolean dirty) {
            if (this.ignoreEvents) {
                return;
            }
            RemoteAccessProfileUI.this.saveToProfile();
            RemoteAccessProfileUI.this.uiListener.save(RemoteAccessProfileUI.this.appProfile);
        }

        @Override
        public void machineListChanged() {
            if (this.ignoreEvents) {
                return;
            }
            RemoteAccessProfileUI.this.saveToProfile();
            RemoteAccessProfileUI.this.uiListener.save(RemoteAccessProfileUI.this.appProfile);
        }

        @Override
        public void switchServiceState() {
        }

        @Override
        public void setProxySettings() {
        }

        @Override
        public void pickGroup() {
            String[][] groups = RemoteAccessProfileUI.this.uiListener.getVisibleMachineGroups();
            final SimpleMachineGroupList groupTreePanel = new SimpleMachineGroupList(groups);
            final PanelGlassDialog dialog = new PanelGlassDialog(SwingUtil.getRootPaneContainer(RemoteAccessProfileUI.this.getRootComponent()), Language.get("GROUP_CHOOSE_DIALOG_TITLE"), 300, Language.get("GROUP_CHOOSE_OK"), Language.get("CANCEL"));
            groupTreePanel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    dialog.setOkEnabled(groupTreePanel.getSelectedGroup() != null);
                }
            });
            dialog.setContentPanel(groupTreePanel.getRootComponent());
            dialog.showDialog();
            if (dialog.isOK()) {
                String[] selectedGroup = groupTreePanel.getSelectedGroup();
                RemoteAccessProfileUI.this.serverTab.setSelectedGroup(selectedGroup);
                RemoteAccessProfileUI.this.saveToProfile();
                RemoteAccessProfileUI.this.uiListener.save(RemoteAccessProfileUI.this.appProfile);
            }
        }

        @Override
        public void setIgnoreEvents(boolean b) {
            this.ignoreEvents = b;
        }
    }
}

