/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile.ui;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.appprofile.GroupPermissionsPanel;
import com.aem.shelp.tech.appprofile.MonitoringPermissionsPanel;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import com.aem.shelp.tech.appprofile.ProfileAccountsPanel;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import com.aem.shelp.tech.appprofile.TechGroupsPanel;
import com.aem.shelp.tech.appprofile.ui.AbstractProfileUI;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class GroupAccessProfileUI
extends AbstractProfileUI {
    private TechGroupsPanel groupsPanel;
    private ProfileAccountsPanel accountsPanel;
    private GroupPermissionsPanel groupPermissionsPanel;
    private MonitoringPermissionsPanel monitoringPermissionsPanel;

    public GroupAccessProfileUI(AppProfile appProfile, ProfileUIListener uiListener, RootPaneContainer rpc, TechClient client) {
        super(appProfile, uiListener, rpc, client);
    }

    @Override
    public AbstractProfileUI.AppProfileTab[] getTabs() {
        ProfileAccountsConfig pconfig = new ProfileAccountsConfig(TechServerConfig.INSTANCE);
        this.accountsPanel = new ProfileAccountsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        this.groupsPanel = new TechGroupsPanel(this.client, pconfig);
        this.groupPermissionsPanel = new GroupPermissionsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        this.monitoringPermissionsPanel = new MonitoringPermissionsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        GbPanel main = new GbPanel();
        StrippedContentPanel contentPanel = new StrippedContentPanel(main, false);
        contentPanel.addContent(this.groupsPanel.getRootComponent(), Language.get("MACHINE_GROUPS"));
        contentPanel.addContent(this.accountsPanel, Language.get("USER_ACCOUNTS"));
        contentPanel.addContent(this.groupPermissionsPanel, Language.get("SESSION_RESTRICTIONS"));
        contentPanel.addContent(this.monitoringPermissionsPanel, Language.get("MONITORING_RESTRICTIONS"));
        contentPanel.addVerticalFiller();
        contentPanel.setBackgroundColours();
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        buttons.addAll(this.groupsPanel.getButtons());
        buttons.addAll(this.accountsPanel.getButtons());
        SwingUtil.setSizesToWidest(buttons);
        return new AbstractProfileUI.AppProfileTab[]{new AbstractProfileUI.AppProfileTab("Basic", ImageLoader.getImageIcon("images/svg/general/gear.svg,16"), main)};
    }

    @Override
    public void loadFromProfile(AppProfile appProfile) {
        this.resetTabs();
        this.accountsPanel.loadFromProfile(appProfile);
        this.groupsPanel.loadFromProfile(appProfile);
        this.groupPermissionsPanel.loadFromProfile(appProfile);
        this.monitoringPermissionsPanel.loadFromProfile(appProfile);
        Properties props = new Properties();
        props.setProperty(GroupAccessKeyset.ENABLED, "true");
        appProfile.setLaunchProperties(props);
        this.uiListener.save(appProfile);
    }
}

