/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.BorderPanel;

public class GroupPermissionsPanel
extends BorderPanel
implements ActionListener,
KeyListener,
ProfileAccountsConfig.ProfileAccountsReadyListener {
    private final ColorPropagatingGBPanel gb;
    AppProfile profile;
    ProfileAccountsConfig pconfig;
    TechClient client;
    RootPaneContainer rpc;
    JCheckBox allowFiles;
    JTextField group;
    JTextField user;
    boolean loadedConfig = false;

    public GroupPermissionsPanel(RootPaneContainer rpc, TechClient client, AppProfile profile, ProfileAccountsConfig config) {
        this.profile = profile;
        this.pconfig = config;
        this.client = client;
        this.rpc = rpc;
        config.addProfileAccountsReadyListener(this);
        this.allowFiles = new JCheckBox(Language.get("GROUP_ACCESS_ALLOW_FILETRANSFER"));
        JLabel maxGroup = new JLabel(Language.get("ADMIN_GROUP_MAX_SG_SESSIONS"));
        JLabel maxUser = new JLabel(Language.get("ADMIN_USER_MAX_SG_SESSIONS"));
        this.gb = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 5));
        this.group = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        this.user = TextField.getTextFieldForType(1, Language.get("UNLIMITED"));
        SwingUtil.setWidth(this.group, 100);
        SwingUtil.setWidth(this.user, 100);
        this.allowFiles.addActionListener(this);
        this.group.addKeyListener(this);
        this.user.addKeyListener(this);
        int N = 0;
        this.gb.add(this.allowFiles, 0, N++, 2, 1, 1, 1, 17, 0);
        this.gb.add(maxGroup, 0, N, 1, 1, 0, 1, 17, 0);
        this.gb.add(this.group, 1, N++, 1, 1, 1, 1, 17, 0);
        this.gb.add(maxUser, 0, N, 1, 1, 0, 1, 17, 0);
        this.gb.add(this.user, 1, N++, 1, 1, 1, 1, 17, 0);
        this.addCenter(this.gb);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.gb != null) {
            this.gb.setBackground(c);
        }
    }

    private void loadProfile() {
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        System.out.println("[Group Perms] Tech Group is " + tg.getName() + " / " + tg.getAssociatedAppProfileID());
        System.out.println("[Group Perms] Tech Group file transfer is " + tg.getPermissions().canUseFileTransfer());
        this.allowFiles.setSelected(tg.getPermissions().canUseFileTransfer());
        if (tg.isSgConcurrencyLimited()) {
            if (tg.getMaxSgGroupConcurrency() != -1) {
                this.group.setText(tg.getMaxSgGroupConcurrency() + "");
            } else {
                this.group.setText(null);
            }
            if (tg.getMaxSgUserConcurrency() != -1) {
                this.user.setText(tg.getMaxSgUserConcurrency() + "");
            } else {
                this.user.setText(null);
            }
        } else {
            this.group.setText(null);
            this.user.setText(null);
        }
    }

    public void loadFromProfile(AppProfile appProfile) {
        this.profile = appProfile;
        if (this.loadedConfig) {
            this.loadProfile();
        }
    }

    @Override
    public void profileAccountsReady() {
        this.loadedConfig = true;
        if (this.profile != null) {
            this.loadFromProfile(this.profile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.keyReleased(null);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.profile == null) {
            return;
        }
        if (this.pconfig == null) {
            return;
        }
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        if (tg == null) {
            return;
        }
        String grouptext = this.group.getText().trim();
        String usertext = this.user.getText().trim();
        int groupmax = 0;
        int usermax = 0;
        try {
            groupmax = Integer.parseInt(grouptext);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            usermax = Integer.parseInt(usertext);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (groupmax < 0) {
            groupmax = 0;
        }
        if (usermax < 0) {
            usermax = 0;
        }
        if (groupmax == 0) {
            tg.setMaxSgGroupConcurrency(-1);
        } else {
            tg.setMaxSgGroupConcurrency(groupmax);
        }
        if (usermax == 0) {
            tg.setMaxSgUserConcurrency(-1);
        } else {
            tg.setMaxSgUserConcurrency(usermax);
        }
        tg.getPermissions().setCanUseFileTransfer(this.allowFiles.isSelected());
        this.pconfig.saveAsync();
    }
}

