/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.events.server.ServerEventsDetailsPanel;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.ui.SelectEventTable;
import utils.swing.components.JEditableLabel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerEventsInfoPanel
extends GbPanel
implements JEditableLabel.EditListener {
    private JEditableLabel title = new JEditableLabel(true);
    private ServerEvent alert;
    private JLabel alertIconLabel;
    private Cursor iBeam = Cursor.getPredefinedCursor(2);
    private ServerEventsDetailsPanel detailsPanel;
    private JPanel selectEventsPanel;
    private SelectEventTable eventsTable;
    private boolean first = false;

    public void setTechClient(TechClient client) {
    }

    public void setMachineTreeModel(MachineTreeModel machines) {
    }

    public ServerEventsInfoPanel(ServerEventsDetailsPanel detailsPanel) {
        super(new Insets(0, 0, 0, 0));
        this.detailsPanel = detailsPanel;
        this.first = true;
    }

    private void initUI() {
        SimpleHelpEventRepository.getRepository().getAllEventInstances();
        int Y = 0;
        this.eventsTable = new SelectEventTable(Language.DEFLANG);
        this.eventsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ServerEventsInfoPanel.this.alert.setLogEventIDs(ServerEventsInfoPanel.this.eventsTable.getSelectedEventIDs());
                ServerEventsInfoPanel.this.detailsPanel.alertModified();
            }
        });
        JComponent componentInScrollPane = (JComponent)((JScrollPane)this.eventsTable.getScrollPaneComponent()).getViewport().getView();
        componentInScrollPane.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.title.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 3, 3));
        this.alertIconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
        JWrapLabel descriptionLabel = new JWrapLabel(Language.get("LOGGING_UI_SELECT_EVENTS_DESC"));
        this.add(this.alertIconLabel, 0, Y, 1, 1, 0, 0, 11, 2, new Insets(3, 3, 3, 3));
        this.add(this.title, 1, Y++, 3, 1, 1, 0, 11, 2, new Insets(3, 0, 3, 3));
        this.add(descriptionLabel, 0, Y++, 4, 1, 1, 1, 17, 2, new Insets(3, 3, 3, 3));
        this.add(componentInScrollPane, 0, Y++, 4, 1, 1, 1, 11, 1);
        if (this.detailsPanel != null) {
            this.title.addListener(this.detailsPanel);
        }
        this.title.addListener(this);
        this.title.setFont(SHStyle.largeFont);
        this.title.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ServerEventsInfoPanel.this.title.setCursor(ServerEventsInfoPanel.this.iBeam);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ServerEventsInfoPanel.this.title.getBounds().contains(e.getPoint())) {
                    return;
                }
                ServerEventsInfoPanel.this.title.setCursor(null);
            }
        });
    }

    public void initPanelWith(ServerEvent alert) {
        if (this.first) {
            this.first = false;
            this.initUI();
        }
        this.alert = alert;
        this.alertIconLabel.setIcon(ImageLoader.getImageIcon("images/svg/alert-flags/blue-down.svg,24"));
        this.alertIconLabel.repaint();
        this.title.setText("<html>" + alert.getName().getName());
        this.eventsTable.setSelectedEvents(alert.getLogEventIDs());
        this.repaint();
    }

    @Override
    public void editableLabelValueSet(String newValue) {
        this.detailsPanel.alertModified();
    }

    public LogEvent[] getSelectedEvents() {
        return this.eventsTable.getSelectedEventInstances();
    }

    @Override
    public void editableLabelStartEdit() {
    }
}

