/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.shelp.common.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.plaf.basic.BasicSpinnerUI;
import utils.swing.SwingUtil;
import utils.swing.components.SHComboBox;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.VariableLinePanel;
import utils.switches.Switches;

public class ScheduleField
extends AbstractField {
    private static final double MAX_COUNT = Math.pow(10.0, 100.0);
    public static final String SCHEDULE_TYPE = "schedule";
    private JComponent rootComponent;
    private VariableLinePanel vp;
    private VariableLinePanel vp2;
    private JTextField num;
    private JLabel from;
    private JSpinner timeSpinner;
    private SHComboBox blocks;
    private SHComboBox timezone;
    private JCheckBox repeatBox = null;

    public double getBlockCount() {
        if (Switches.SH_tool_schedule_ui) {
            if (this.repeatBox.isSelected()) {
                return Double.parseDouble(this.num.getText().trim());
            }
            return MAX_COUNT;
        }
        return Double.parseDouble(this.num.getText().trim());
    }

    public int getBlockUnit() {
        return this.blocks.getSelectedIndex();
    }

    public long getStartTime() {
        return ((Date)this.timeSpinner.getValue()).getTime();
    }

    public boolean useGMT() {
        return this.blocks.getSelectedIndex() == 1;
    }

    public void setBlockCount(double d) {
        if (Switches.SH_tool_schedule_ui) {
            if (d >= MAX_COUNT) {
                this.repeatBox.setSelected(false);
                this.num.setText("");
            } else {
                this.repeatBox.setSelected(true);
                this.num.setText("" + d);
            }
            this.updateEnabled();
        } else {
            this.num.setText("" + d);
        }
    }

    public void setBlockUnit(int n) {
        this.blocks.setSelectedIndex(n);
    }

    public void setStartTime(long d) {
        this.timeSpinner.setValue(new Date(d));
    }

    public void setUseGMT(boolean b) {
        if (b) {
            this.timezone.setSelectedIndex(1);
        } else {
            this.timezone.setSelectedIndex(0);
        }
    }

    public ScheduleField(String label, AbstractField.ChangeListener changeListener) {
        super(SCHEDULE_TYPE, label, changeListener);
        this.init();
    }

    private void init() {
        this.vp = new VariableLinePanel(1, false, true);
        if (Switches.SH_tool_schedule_ui) {
            this.vp2 = new VariableLinePanel(1, false, true);
            this.rootComponent = new JPanel(new GridLayout(2, 1, 5, 5));
            this.rootComponent.add(this.vp);
            this.rootComponent.add(this.vp2);
        } else {
            this.rootComponent = this.vp;
        }
        this.num = TextField.getTextFieldForType(2);
        this.num.addKeyListener(this.proxyChangeListener);
        SwingUtil.setWidth(this.num, SimpleHelpLookAndFeel.scale(100));
        this.timeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(this.timeSpinner, "EEE dd/MMM/yyyy HH:mm");
        this.timeSpinner.setEditor(timeEditor);
        this.timeSpinner.setValue(new Date());
        this.timeSpinner.setUI(new BasicSpinnerUI(){

            @Override
            protected Component createNextButton() {
                return null;
            }

            @Override
            protected Component createPreviousButton() {
                return null;
            }
        });
        this.timeSpinner.addChangeListener(this.proxyChangeListener);
        this.blocks = new SHComboBox(new Object[]{Language.get("UNIT_SECONDS"), Language.get("UNIT_MINUTES"), Language.get("UNIT_HOURS"), Language.get("UNIT_DAYS")});
        this.blocks.addActionListener(this.proxyChangeListener);
        this.timezone = new SHComboBox(new Object[]{Language.get("TIMEZONE_MACHINE"), Language.get("TIMEZONE_GMT")});
        this.timezone.addActionListener(this.proxyChangeListener);
        SwingUtil.setSizesToShortest(new JComponent[]{this.num, this.timeSpinner, this.timezone, this.blocks});
        this.timeSpinner.setBackground(this.num.getBackground());
        this.blocks.setBorder(null);
        this.timezone.setBorder(null);
        this.vp.setGridSpacing(new ScaledInsets(0, 0, 0, 4));
        if (Switches.SH_tool_schedule_ui) {
            this.from = new JLabel(Language.get("PERFORM_FROM_SPECIFIED_TIME2"));
            this.repeatBox = new JCheckBox(Language.get("REPEAT_EVERY"));
            this.repeatBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScheduleField.this.updateEnabled();
                }
            });
            this.repeatBox.addActionListener(this.proxyChangeListener);
            this.vp2.setGridSpacing(new ScaledInsets(0, 0, 0, 4));
            this.vp.add(this.from);
            this.vp.add(this.timeSpinner);
            this.vp.add(this.timezone);
            this.vp2.add(this.repeatBox);
            this.vp2.add(this.num);
            this.vp2.add(this.blocks);
            this.updateEnabled();
        } else {
            this.from = new JLabel(Language.get("PERFORM_FROM_SPECIFIED_TIME"));
            this.vp.add(this.num);
            this.vp.add(this.blocks);
            this.vp.add(this.from);
            this.vp.add(this.timeSpinner);
            this.vp.add(this.timezone);
        }
    }

    private void updateEnabled() {
        if (this.repeatBox != null) {
            if (this.repeatBox.isSelected()) {
                this.num.setEnabled(true);
                this.blocks.setEnabled(true);
            } else {
                this.num.setEnabled(false);
                this.blocks.setEnabled(false);
            }
        }
    }

    @Override
    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.timeSpinner.setBackground(backgroundColor);
        this.timezone.setBackground(backgroundColor);
    }

    @Override
    public JComponent getComponent() {
        return this.rootComponent;
    }

    @Override
    protected void toXML(StringBuffer buffer, int tabs) {
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return null;
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return null;
    }

    @Override
    public void setStorableFilledOutData(ResultPair storableFilledOutData) {
    }

    @Override
    public void clearContents() {
    }
}

