/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.AlertDetailsPanel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggersListPanel;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class AlertTriggersPanel {
    private TriggersListPanel triggers;
    private TriggersListPanel resets;
    private GbPanel rootComponent = new GbPanel(new ScaledInsets(0, 0, 0, 0));
    private AlertDetailsPanel detailsPanel;
    private LocatedAlert alert;

    public void setTechClient(TechClient client) {
        this.triggers.setTechClient(client);
        this.resets.setTechClient(client);
    }

    public void setMachineTreeModel(MachineTreeModel machines) {
        this.triggers.setMachineTreeModel(machines);
        this.resets.setMachineTreeModel(machines);
    }

    public AlertTriggersPanel(AlertDetailsPanel detailsPanel) {
        this.detailsPanel = detailsPanel;
        this.initUI();
    }

    private void initUI() {
        int Y = 0;
        this.triggers = new TriggersListPanel(this, this.detailsPanel, SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("ALERT_TRIGGER_AFTER_MINUTES"), true);
        this.resets = new TriggersListPanel(this, this.detailsPanel, SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("ALERT_RESET_AFTER_MINUTES"), false);
        JPanel testPanel = new JPanel(new GridLayout(1, 2));
        testPanel.add(this.triggers.getRootComponent());
        testPanel.add(this.resets.getRootComponent());
        this.rootComponent.add(testPanel, 0, Y++, 4, 1, 1, 1, 10, 1);
        this.resets.getRootComponent().setBorder(SHBorderFactory.createMatteBorder(0, 1, 0, 0, SHStyle.BORDER_COLOR));
        this.triggers.getRootComponent().setBorder(SHBorderFactory.createMatteBorder(0, 0, 0, 0, SHStyle.BORDER_COLOR));
    }

    public void updateCorollaryIfExists(Alert master, TriggersListPanel listp) {
        if (listp == this.triggers) {
            this.resets.updateCorollary(master);
        } else {
            this.triggers.updateCorollary(master);
        }
    }

    public void removeCorollaryIfExists(Alert master, TriggersListPanel listp) {
        if (listp == this.triggers) {
            this.resets.removeCorollary(master);
        } else {
            this.triggers.removeCorollary(master);
        }
    }

    public void corollaryCreated(Alert alert, TriggersListPanel listp, int group) {
        if (listp == this.triggers) {
            this.resets.addThreshold(alert, group);
        } else if (listp == this.resets) {
            this.triggers.addThreshold(alert, group);
        }
    }

    private ArrayList<TriggersListPanel.TriggerGroup> buildGroups(ArrayList<ArrayList<Alert>> all) {
        ArrayList<TriggersListPanel.TriggerGroup> groups = new ArrayList<TriggersListPanel.TriggerGroup>();
        ArrayList<ArrayList<Alert>> alerts = all;
        for (ArrayList<Alert> list : alerts) {
            TriggersListPanel.TriggerGroup tg = new TriggersListPanel.TriggerGroup();
            tg.triggers = new ArrayList();
            tg.triggers.addAll(list);
            groups.add(tg);
        }
        return groups;
    }

    public void initInfoPanelWith(LocatedAlert alert, ArrayList<String> triggeredMachines) {
        this.alert = alert;
        BasicAlert ba = (BasicAlert)alert.getAlert();
        this.triggers.initFor(this.buildGroups(ba.getTriggers()), !ba.getTriggerIntraGroupsAND(), ba.getTriggerTimeMS());
        this.resets.initFor(this.buildGroups(ba.getResets()), !ba.getResetIntraGroupsAND(), ba.getResetTimeMS());
        this.rootComponent.repaint();
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public void saveConfigurationTo(BasicAlert ba) {
        ba.setTrigger(!this.triggers.isConjunctionBetweenGroups(), this.triggers.getAlerts(), this.triggers.getTimeMS());
        ba.setReset(!this.resets.isConjunctionBetweenGroups(), this.resets.getAlerts(), this.resets.getTimeMS());
    }
}

