/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.alerts.utils.AlertSelection;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.LeftRightButton;
import utils.swing.components.LeftRightButtonInterface;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AlertsAdvancedPanel
extends GbPanel
implements ActionListener {
    private LeftRightButton removeButton;
    private AlertPanelListener alertPanelListener;
    private AlertSelection alerts;
    private JLabel summaryLabel;

    public AlertsAdvancedPanel(AlertPanelListener alertPanelListener) {
        super(new Insets(3, 3, 3, 3));
        this.alertPanelListener = alertPanelListener;
        this.initUI();
    }

    private JLabel getDescLabel(String text) {
        JWrapLabel descLabel = new JWrapLabel("<html>" + text);
        descLabel.setFont(SHStyle.smallerFont);
        descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        return descLabel;
    }

    public void initUI() {
        this.removeButton = new LeftRightButton(Language.get("REMOVE"), ImageLoader.getImageIcon("images/svg/general/trash.svg,16"));
        this.summaryLabel = new JLabel(Language.get("ADVANCED_MACHINE_SETTINGS"));
        this.summaryLabel.setBorder(SHBorderFactory.createEmptyBorder(3, 0, 5, 0));
        this.summaryLabel.setFont(SHStyle.largeFont);
        this.summaryLabel.setVisible(false);
        int Y = 0;
        this.add(this.summaryLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
    }

    public void initUIWithPermissions(TechGroupPermissions permissions) {
        int Y = this.getComponentCount();
        if (permissions.canManageAlerts()) {
            AbstractButton[] buttons = new AbstractButton[]{this.removeButton};
            String[] descriptions = new String[]{Language.get("ALERT_REMOVE_DESC")};
            for (int i = 0; i < buttons.length; ++i) {
                AbstractButton button = buttons[i];
                if (button instanceof LeftRightButtonInterface) {
                    ((LeftRightButtonInterface)((Object)button)).setRightColour(Color.GRAY);
                }
                button.addActionListener(this);
                button.setHorizontalAlignment(2);
                JLabel descLabel = this.getDescLabel(descriptions[i]);
                this.add(button, 0, Y, 1, 1, 0, 0, 10, 2, new Insets(3, 5, 3, 10));
                this.add(descLabel, 1, Y++, 1, 1, 1000, 0, 17, 2);
            }
        }
        this.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeButton) {
            this.alertPanelListener.removeAlerts((ResourceContainer[])this.alerts.getAllElements());
        }
    }

    private void setButtonAndDescVisible(AbstractButton button, boolean visible) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != button) continue;
            this.getComponent(i).setVisible(visible);
            this.getComponent(i + 1).setVisible(visible);
            return;
        }
    }

    public void initSelectedMachines(AlertSelection alerts) {
        this.alerts = alerts;
        if (alerts.machineCount == 1) {
            this.summaryLabel.setVisible(false);
        } else {
            this.summaryLabel.setText(alerts.machineCount + " " + Language.get("ALERTS"));
            this.summaryLabel.setVisible(true);
        }
        int count = alerts.machineCount;
        boolean singleSelection = count == 1;
        this.setButtonAndDescVisible(this.removeButton, true);
        if (!singleSelection) {
            this.removeButton.setLeftRightText(Language.get("REMOVE"), "" + count);
        }
    }
}

