/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminServerLog
extends SubSection
implements ActionListener {
    private static final AdminServerLog INSTANCE = new AdminServerLog();
    private JTextArea textArea;
    private JScrollPane pane;
    private JButton saveLogButton;
    private JButton refreshLogButton;
    private boolean first = true;

    public static AdminServerLog getInstance() {
        return INSTANCE;
    }

    private AdminServerLog() {
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    @Override
    protected void initUI() {
        this.rootComponent = new ColorPropagatingPanel(){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        GridBagLayout gbl = new GridBagLayout();
        this.rootComponent.setLayout(gbl);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(Color.WHITE);
        this.textArea.setBorder(SHBorderFactory.createEtchedBorder());
        this.pane = new JScrollPane(this.textArea);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.saveLogButton = new JButton();
        this.saveLogButton.setText(Language.get("SAVE"));
        this.saveLogButton.setToolTipText(Language.get("SAVE_LOG_TO_DISK"));
        this.saveLogButton.addActionListener(this);
        this.refreshLogButton = new JButton();
        this.refreshLogButton.setText(Language.get("REFRESH"));
        this.refreshLogButton.setToolTipText(Language.get("REFRESH_SERVER_LOG"));
        this.refreshLogButton.addActionListener(this);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JButton[]{this.saveLogButton, this.refreshLogButton});
        GbPanel buttonsBar = new GbPanel();
        buttonsBar.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsBar.add(this.saveLogButton, 0, 0, 1, 1, 0, 0, 17, 0, new Insets(0, 0, 0, 0));
        buttonsBar.add(this.refreshLogButton, 1, 0, 1, 1, 1, 0, 17, 0, new Insets(0, 0, 0, 0));
        SwingUtil.setSizesToWidest(new JButton[]{this.refreshLogButton, this.saveLogButton});
        gbl.setConstraints(this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(buttonsBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.rootComponent.add(this.pane);
        this.rootComponent.add(buttonsBar);
    }

    public void setServerLog(String serverLog) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText(serverLog);
            if (this.first) {
                this.first = false;
                this.textArea.setCaretPosition(0);
            }
        } else {
            SwingUtilities.invokeLater(new SetServerLog(serverLog));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.saveLogButton)) {
            String text = this.textArea.getText();
            File selectedFile = SafeJFileChooser.saveFile(this.rootComponent, new String[]{"zip"}, "serverlog.zip");
            if (selectedFile != null) {
                if (!selectedFile.getName().trim().endsWith(".zip")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName().trim() + ".zip");
                }
                try {
                    ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile)));
                    out.putNextEntry(new ZipEntry("server.log"));
                    out.write(text.getBytes("UTF8"));
                    out.close();
                    SHGlassOptionPane.showMessageDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("LOG_SAVE_MSG"), Language.get("LOG_SAVE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/information.svg,48"), Language.get("CLOSE"));
                }
                catch (Exception ex) {
                    SHGlassOptionPane.showErrorDialog(SwingUtil.getRootPaneContainer(this.rootComponent), Language.get("LOG_SAVE_FAIL_MSG") + "\n" + ex.getMessage(), Language.get("LOG_SAVE_FAIL_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                    ex.printStackTrace();
                }
            }
        } else if (e.getSource().equals(this.refreshLogButton)) {
            try {
                this.setServerLog(this.techClient.fetchServerLog());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SERVER_LOG_PANEL");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    class SetServerLog
    implements Runnable {
        String text;

        public SetServerLog(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            AdminServerLog.this.textArea.setText(this.text);
            if (AdminServerLog.this.first) {
                AdminServerLog.this.first = false;
                AdminServerLog.this.textArea.setCaretPosition(0);
            }
        }
    }
}

